/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.batch.job;

import br.com.elotech.core.utils.DateUtils;
import br.com.elotech.di.resource.web.EloJobExecutionInfo;
import br.com.elotech.di.resource.web.EloJobInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import lombok.Generated;
import org.springframework.batch.admin.service.JobService;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.repository.JobRepository;

public class JobUtils {
    @Generated
    private static final Logger log = Logger.getLogger(JobUtils.class.getName());
    private final JobService jobService;
    private final JobRepository jobRepository;
    private final JobExplorer jobExplorer;

    public JobUtils(JobService jobService, JobRepository jobRepository, JobExplorer jobExplorer) {
        this.jobService = jobService;
        this.jobRepository = jobRepository;
        this.jobExplorer = jobExplorer;
    }

    public JobParameters getLastJobParameters(String jobName) {
        return this.jobService.getLastJobParameters(jobName);
    }

    public JobExecution getLastJobExecution(String jobName) {
        return this.jobRepository.getLastJobExecution(jobName, this.getLastJobParameters(jobName));
    }

    public String getFailureMessages(JobExecution jobExecution) {
        StringBuilder failures = new StringBuilder();
        for (StepExecution stepExecution : jobExecution.getStepExecutions()) {
            if (!stepExecution.getStatus().isUnsuccessful()) continue;
            failures.append(String.format("Step: %s - %s", stepExecution.getStepName(), stepExecution.getExitStatus().getExitDescription()));
        }
        return failures.toString();
    }

    public String getFailureSteps(JobExecution jobExecution) {
        StringBuilder failures = new StringBuilder();
        for (StepExecution stepExecution : jobExecution.getStepExecutions()) {
            if (!stepExecution.getStatus().isUnsuccessful()) continue;
            failures.append(stepExecution.getStepName()).append(',');
        }
        return failures.toString();
    }

    public void resetStaleJobs() {
        List jobNames = this.jobExplorer.getJobNames();
        for (String jobName : jobNames) {
            this.resetStaleJob(jobName);
        }
    }

    public List<EloJobInfo> getJobExecutions(String jobName) {
        ArrayList<EloJobInfo> jobs = new ArrayList<EloJobInfo>();
        try {
            int count = this.jobService.countJobExecutionsForJob(jobName);
            List jobsInstances = this.jobExplorer.getJobInstances(jobName, 0, Integer.MAX_VALUE);
            ArrayList jobsExecutionInfo = Lists.newArrayList();
            for (JobInstance jobInstance : jobsInstances) {
                List executions = this.jobExplorer.getJobExecutions(jobInstance);
                for (JobExecution jobExecution : executions) {
                    EloJobExecutionInfo jobExecutionInfo = new EloJobExecutionInfo(jobExecution, DateUtils.TIMEZONE_SAO_PAULO);
                    jobsExecutionInfo.add(jobExecutionInfo);
                }
            }
            jobs.add(new EloJobInfo(jobName, count, (List)jobsExecutionInfo));
        }
        catch (NoSuchJobException e) {
            log.info("Job " + jobName + " without executions");
        }
        return jobs;
    }

    public BatchStatus getJobExecutionStatus(String jobName) {
        List jobsInstances = this.jobExplorer.getJobInstances(jobName, 0, Integer.MAX_VALUE);
        for (JobInstance jobInstance : jobsInstances) {
            List executions = this.jobExplorer.getJobExecutions(jobInstance);
            for (JobExecution jobExecution : executions) {
                if (!jobExecution.getJobInstance().getJobName().equals(jobName)) continue;
                return jobExecution.getStatus();
            }
        }
        return BatchStatus.UNKNOWN;
    }

    private void resetStaleJob(String jobName) {
        Set runningJobExecutions = this.jobExplorer.findRunningJobExecutions(jobName);
        for (JobExecution jobExecution : runningJobExecutions) {
            if (jobExecution == null || jobExecution.getStatus().isGreaterThan(BatchStatus.STARTED)) continue;
            this.resetStaleJobExecution(jobExecution);
            jobExecution.setStatus(BatchStatus.STOPPED);
            jobExecution.setEndTime(new Date());
            this.jobRepository.update(jobExecution);
        }
    }

    private void resetStaleJobExecution(JobExecution jobExecution) {
        for (StepExecution stepExecution : jobExecution.getStepExecutions()) {
            if (!stepExecution.getStatus().equals((Object)BatchStatus.STARTING) && !stepExecution.getStatus().equals((Object)BatchStatus.STARTED) && !stepExecution.getStatus().equals((Object)BatchStatus.UNKNOWN)) continue;
            stepExecution.setStatus(BatchStatus.STOPPED);
            stepExecution.setEndTime(new Date());
            this.jobRepository.update(stepExecution);
        }
    }

    public boolean isAllCompleteExecutions(String jobName) {
        List jobs = this.getJobExecutions(jobName);
        for (EloJobInfo eloJobInfo : jobs) {
            Optional lastExecution = eloJobInfo.getJobExecutions().stream().findFirst();
            if (!lastExecution.isPresent() || ((EloJobExecutionInfo)lastExecution.get()).getStatus().equals("COMPLETED")) continue;
            return false;
        }
        return !jobs.isEmpty();
    }
}

