/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.batch.job;

import br.com.elotech.di.batch.job.BatchContextHolder;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.launch.support.SimpleJobLauncher;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JobLauncherActiveContext
extends SimpleJobLauncher {
    @Autowired
    private JobRepository jobRepository;

    public JobExecution launch(Job job, JobParameters jobParameters) {
        return this.run(job, jobParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobExecution run(Job job, JobParameters jobParameters) {
        JobExecution jobExecution;
        BatchContextHolder.started((String)job.getName());
        try {
            jobExecution = super.run(job, jobParameters);
        }
        catch (Throwable throwable) {
            BatchContextHolder.stopped();
            throw throwable;
        }
        BatchContextHolder.stopped();
        return jobExecution;
    }

    public void afterPropertiesSet() {
        this.setJobRepository(this.jobRepository);
        super.afterPropertiesSet();
    }
}

