/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.batch.job;

import br.com.elotech.di.batch.job.BatchProgressReader;
import br.com.elotech.di.batch.job.IgnoreExceptionHandler;
import br.com.elotech.di.batch.job.JobListener;
import br.com.elotech.di.batch.job.PessoasDuplicadasBatchProcessor;
import br.com.elotech.di.batch.job.PessoasDuplicadasBatchReader;
import br.com.elotech.di.batch.job.PessoasDuplicadasBatchWriterPassThrough;
import br.com.elotech.di.batch.job.ProgressListener;
import br.com.elotech.di.batch.job.StepListener;
import br.com.elotech.di.config.BatchProperties;
import com.google.common.eventbus.EventBus;
import org.springframework.batch.core.ItemWriteListener;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.job.builder.FlowJobBuilder;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.batch.core.step.builder.AbstractTaskletStepBuilder;
import org.springframework.batch.core.step.builder.SimpleStepBuilder;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.repeat.exception.ExceptionHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.task.TaskExecutor;

@Configuration
public class CadastroDuplicateBatch {
    public static final String STEPNAME = "Pessoa";
    private static final Integer DEFAULT_CHUNK_SIZE = 10;
    @Autowired
    private BatchProperties batchProperties;
    @Autowired
    private StepBuilderFactory stepBuilderFactory;
    @Autowired
    private JobBuilderFactory jobBuilderFactory;
    @Autowired
    private EventBus eventBus;

    @Bean(name={"pessoaUnifica"})
    public Step pessoaUnifica(PessoasDuplicadasBatchReader reader, PessoasDuplicadasBatchProcessor processor, PessoasDuplicadasBatchWriterPassThrough writer, TaskExecutor taskExecutor) {
        ProgressListener progressListener = new ProgressListener(this.getClass().getPackage().getName() + ".Pessoa", this.eventBus, (BatchProgressReader)reader);
        StepListener listener = new StepListener(this.getClass().getPackage().getName() + ".Pessoa", this.eventBus);
        IgnoreExceptionHandler exceptionHandler = new IgnoreExceptionHandler();
        return ((SimpleStepBuilder)((AbstractTaskletStepBuilder)((AbstractTaskletStepBuilder)((SimpleStepBuilder)this.stepBuilderFactory.get(STEPNAME).chunk(DEFAULT_CHUNK_SIZE.intValue()).reader((ItemReader)reader).processor((ItemProcessor)processor).writer((ItemWriter)writer).taskExecutor(taskExecutor).throttleLimit(this.batchProperties.getThrottleLimit()).listener((Object)listener)).listener((ItemWriteListener)listener).listener((StepExecutionListener)listener)).listener((StepExecutionListener)progressListener)).listener((Object)progressListener)).exceptionHandler((ExceptionHandler)exceptionHandler).build();
    }

    @Profile(value={"!cloud"})
    @Bean
    public Job jobPessoUnifica(JobListener jobListener, Step pessoaUnifica) {
        return ((FlowJobBuilder)((JobBuilder)((JobBuilder)this.jobBuilderFactory.get("Unifica_Cadastro").incrementer((JobParametersIncrementer)new RunIdIncrementer())).listener((JobExecutionListener)jobListener)).flow(pessoaUnifica).end()).build();
    }
}

