/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.batch;

import br.com.elotech.di.batch.SpringBatchConfiguration;
import br.com.elotech.di.config.BatchProperties;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.springframework.batch.core.configuration.annotation.BatchConfigurer;
import org.springframework.batch.core.repository.ExecutionContextSerializer;
import org.springframework.batch.core.repository.dao.Jackson2ExecutionContextStringSerializer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
@EnableConfigurationProperties(value={BatchProperties.class, org.springframework.boot.autoconfigure.batch.BatchProperties.class})
public class SpringBatchConfiguration {
    public static final int MAX_VARCHAR_LENGTH = 4000;
    public static final int DEFAULT_CHUNK_SIZE = 500;
    public static final int DEFAULT_FLUSH_SIZE = 500;

    @Bean
    public ExecutionContextSerializer executionContextSerializer() {
        return new Jackson2ExecutionContextStringSerializer(new String[0]);
    }

    @Bean
    @Lazy
    public BatchConfigurer basicBatchConfigurer(org.springframework.boot.autoconfigure.batch.BatchProperties properties, DataSource dataSource, EntityManagerFactory entityManagerFactory, ExecutionContextSerializer serializer) {
        return new CustomBatchConfigurer(properties, dataSource, entityManagerFactory, serializer);
    }
}

