/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di;

import liquibase.integration.spring.SpringLiquibase;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.util.StringUtils;

@Configuration
@Profile(value={"production"})
public class AddValidationBeforeLiquibase
implements BeanFactoryPostProcessor {
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        this.addValidationBeforeLiquibase(beanFactory);
    }

    private void addValidationBeforeLiquibase(ConfigurableListableBeanFactory beanFactory) {
        String[] beanNames;
        for (String beanName : beanNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, SpringLiquibase.class, (boolean)true, (boolean)false)) {
            BeanDefinition definition = beanFactory.getBeanDefinition(beanName);
            definition.setDependsOn(StringUtils.addStringToArray((String[])definition.getDependsOn(), (String)"appValidateStart"));
        }
    }
}

