SELECT $[IDS_CONTRIBUINTE]   AS ids_contribuintes,
       V.NOME,
       V.CNPJCPF,
       V.VALOR
FROM (
	SELECT
	    ROW_NUMBER() OVER(ORDER BY P.NOME) AS ORDERID,
	    P.NOME AS NOME,
	    P.CGCCPF AS CNPJCPF,
	    VP.SITUACAO AS SITUACAO,
	    SUM(VP.VALOR) AS VALOR
	FROM ${db.smt.schema}.CADASTROGERAL CG
	    JOIN ${db.smt.schema}.CGCM P
	       ON P.CODIGO = CG.CODIGOCGCM
	    JOIN ${db.smt.schema}.VALORESPARCELAS VP
	        ON VP.TIPOCADASTRO = CG.TIPO
	        AND VP.CODIGOIMOVEL = CG.CODIGO
	WHERE VP.SITUACAO IN (1,2)
	$[FILTRO]
	GROUP BY P.NOME, P.CGCCPF, VP.SITUACAO
) V WHERE V.ORDERID BETWEEN :start AND :end;
