SELECT TB2.ENTIDADE,
       TB2.EXERCICIO,
       TB2.CONTA,
       TB2.DESCRICAO,
       TB2.IDCONTACORRENTE, 
       ABS(TB2.SALDOEXERCICIOANTERIOR + TB2.VALORLANCADO) AS VALORLANCADO,  
       TB2.VALORDEVOLVIDO,
       TB2.VALORRECEBIDO,
       TB2.TIPO,
       TB2.NOMEFORNECEDOR,
       TB2.VALORPREVISTORECEBER,
       TB2.VALORPREVISTOREPASSAR,
       CASE 
         WHEN (TB2.VALORPREVISTORECEBER - (TB2.VALORRECEBIDO + TB2.VALORDEVOLVIDO)) > 0
         THEN (TB2.VALORPREVISTORECEBER - (TB2.VALORRECEBIDO + TB2.VALORDEVOLVIDO))
         ELSE 0 
       END AS VALORRESTANTERECEBER,
       CASE 
         WHEN (TB2.VALORPREVISTOREPASSAR - (TB2.VALORRECEBIDO + TB2.VALORDEVOLVIDO)) > 0
         THEN (TB2.VALORPREVISTOREPASSAR - (TB2.VALORRECEBIDO + TB2.VALORDEVOLVIDO))
         ELSE 0 
       END AS VALORRESTANTEREPASSAR
  FROM (SELECT TB1.ENTIDADE,
               TB1.EXERCICIO,
               TB1.CONTA,
               COALESCE(TB1.DESCRICAO, F.DESCRICAO) AS DESCRICAO,
               TB1.IDCONTACORRENTE,      
               TB1.VALORLANCADO,  
               TB1.VALORDEVOLVIDO,
               TB1.VALORRECEBIDO,
               TB1.TIPO,
               TB1.NOMEFORNECEDOR,
               (SELECT COALESCE(SUM(CASE E.DEBCRED WHEN 'D' THEN E.VALOR ELSE E.VALOR * -1 END),0)
                  FROM ${db.contabilidade.schema}.EVENTOSLANCADOSCONTA E 
                 WHERE E.ENTIDADE = TB1.ENTIDADE
                   AND E.EXERCICIO = TB1.EXERCICIO
                   AND E.CONTA = TB1.CONTA
                   AND E.IDCONTACORRENTE = TB1.IDCONTACORRENTE
                   AND E.GRUPOEVENTO = 85
                   AND E.EVENTO IN (SELECT EVENTO 
                                      FROM ${db.contabilidade.schema}.TABELAEVENTO  
                                     WHERE ENTIDADE = TB1.ENTIDADE 
                                       AND EXERCICIO = TB1.EXERCICIO 
                                       AND GRUPOEVENTO = 85 
                                       AND ATUALIZAPLANO = 'N')) AS SALDOEXERCICIOANTERIOR,
               (SELECT COALESCE(SUM(VALORATIVA),0) 
                  FROM ${db.contabilidade.schema}.ORCINTERFERENCIA O 
                  JOIN ${db.contabilidade.schema}.ENTIDADE ENTIDADEDESTINO 
                    ON ENTIDADEDESTINO.ENTIDADE = O.ENTIDADEDESTINO
                 WHERE O.ENTIDADEORIGEM     = TB1.ENTIDADE 
                   AND O.EXERCICIO          = TB1.EXERCICIO
                   AND ENTIDADEDESTINO.CNPJ = TB1.CNPJFORNECEDOR) AS VALORPREVISTOREPASSAR,
               (SELECT COALESCE(SUM(VALORATIVA),0) 
                  FROM ${db.contabilidade.schema}.ORCINTERFERENCIA O 
                 WHERE O.ENTIDADEDESTINO = TB1.ENTIDADE 
                   AND O.EXERCICIO      = TB1.EXERCICIO) AS VALORPREVISTORECEBER
          FROM (SELECT A.ENTIDADE,
                       A.EXERCICIO,
                       A.CONTA,
                       D.DESCRICAO,
                       D.IDCONTACORRENTE,      
                       SUM(CASE C.DEBCRED WHEN 'D' THEN C.VALOR ELSE C.VALOR * -1 END) AS VALORLANCADO,
                       SUM(CASE C.DEBCRED WHEN 'D' THEN C.VALOR ELSE 0 END) AS VALORDEVOLVIDO,
                       SUM(CASE C.DEBCRED WHEN 'C' then C.VALOR ELSE 0 END) AS VALORRECEBIDO,
                       A.TIPO,
                       FORN.NOME AS NOMEFORNECEDOR,
                       FORN.CNPJ CNPJFORNECEDOR
                  FROM ELOPORTALREPASSES A
                  LEFT OUTER JOIN ${db.contabilidade.schema}.EVENTOSLANCADOSCONTA C
                    ON C.ENTIDADE  = A.ENTIDADE 
                   AND C.EXERCICIO = A.EXERCICIO 
                   AND C.CONTA     = A.CONTA 
                  LEFT OUTER JOIN ${db.contabilidade.schema}.EVENTOSLANCADOS B
                    ON B.ENTIDADE      = C.ENTIDADE 
                   AND B.EXERCICIO     = C.EXERCICIO 
                   AND B.TIPOEVENTO    = C.TIPOEVENTO 
                   AND B.GRUPOEVENTO   = C.GRUPOEVENTO 
                   AND B.EVENTO        = C.EVENTO 
                   AND B.NROLANCAMENTO = C.NROLANCAMENTO 
                  LEFT OUTER JOIN ${db.contabilidade.schema}.CONTACORRENTE D
                    ON D.ENTIDADE        = C.ENTIDADE 
                   AND D.IDCONTACORRENTE = C.IDCONTACORRENTE
                  LEFT JOIN ${db.contabilidade.schema}.CADASTROEXTRA CE
                    ON CE.ENTIDADE = D.ENTIDADE 
                   AND CE.ID = D.IDCADASTROEXTRA 
                  LEFT JOIN ${db.contabilidade.schema}.FORNECEDOR FORN
                    ON FORN.FORNECEDOR = CE.FORNECEDOR
                 WHERE A.ENTIDADE  = :entidade
                   AND A.EXERCICIO = :exercicio
                   AND A.TIPO      = :tipo
                   AND C.GRUPOEVENTO NOT IN (80,81,85,86) 
                 GROUP BY  A.ENTIDADE, A.EXERCICIO, A.CONTA, D.DESCRICAO, D.DESCRICAO, D.IDCONTACORRENTE, A.TIPO, CE.FORNECEDOR, FORN.NOME, FORN.CNPJ
     ) TB1
  JOIN ${db.contabilidade.schema}.PLANO F
    ON F.ENTIDADE = TB1.ENTIDADE 
   AND F.EXERCICIO = TB1.EXERCICIO 
   AND F.CONTA = TB1.CONTA) TB2 
 ORDER BY TB2.DESCRICAO
 