SELECT TB2.ENTIDADE,
       TB2.EXERCICIO,
       TB2.MES,
       ABS(TB2.SALDOEXERCICIOANTERIOR + TB2.VALORLANCADO) AS VALORLANCADO,  
       TB2.VALORDEVOLVIDO,
       TB2.VALORRECEBIDO,
       TB2.VALORPREVISTORECEBER AS VALORPREVISTORECEBERMENSAL, 
       (TB2.VALORRECEBIDO - TB2.VALORPREVISTORECEBER) AS VALORRESTANTERECEBER,
	   TB2.VALORAUTORIZADO AS VALORAUTORIZADOMENSAL,
       (TB2.VALORRECEBIDO - TB2.VALORAUTORIZADO) AS VALORRESTANTEAUTORIZADO
  FROM (SELECT TB1.ENTIDADE,
               TB1.EXERCICIO,
			   TB1.MES,
               SUM(TB1.VALORLANCADO) VALORLANCADO,  
               SUM(TB1.VALORDEVOLVIDO) VALORDEVOLVIDO,
               SUM(TB1.VALORRECEBIDO) VALORRECEBIDO,
               SUM(TB1.SALDOEXERCICIOANTERIOR) SALDOEXERCICIOANTERIOR,
               (SELECT COALESCE(SUM(VALORATIVA),0) / 12
                  FROM ${db.contabilidade.schema}.ORCINTERFERENCIA O 
                 WHERE O.ENTIDADEDESTINO = TB1.ENTIDADE 
                   AND O.EXERCICIO       = TB1.EXERCICIO) AS VALORPREVISTORECEBER,
               (SELECT COALESCE(SUM(VALORAUTORIZADO),0) / 12 
                  FROM ${db.contabilidade.schema}.ORCINTERFERENCIA O 
                 WHERE O.ENTIDADEDESTINO = TB1.ENTIDADE 
                   AND O.EXERCICIO       = TB1.EXERCICIO) AS VALORAUTORIZADO               
          FROM (SELECT A.ENTIDADE,
                       A.EXERCICIO,
                       A.CONTA,
                       SUM(CASE WHEN EXTRACT(MONTH FROM B.DATA) = M.MES THEN 
                                CASE C.DEBCRED WHEN 'D' THEN C.VALOR ELSE C.VALOR * -1 END 
						   ELSE 0 END) AS VALORLANCADO,
                       SUM(CASE WHEN EXTRACT(MONTH FROM B.DATA) = M.MES THEN 
                                CASE C.DEBCRED WHEN 'D' THEN C.VALOR ELSE 0 END 
                           ELSE 0 END) AS VALORDEVOLVIDO,
                       SUM(CASE WHEN EXTRACT(MONTH FROM B.DATA) = M.MES THEN 
                                CASE C.DEBCRED WHEN 'C' THEN C.VALOR ELSE 0 END 
                           ELSE 0 END) AS VALORRECEBIDO,
					   M.MES,
					   (SELECT COALESCE(SUM(CASE E.DEBCRED WHEN 'D' THEN E.VALOR ELSE E.VALOR * -1 END),0)
					      FROM ${db.contabilidade.schema}.EVENTOSLANCADOSCONTA E 
					     WHERE E.ENTIDADE        = A.ENTIDADE
					       AND E.EXERCICIO       = A.EXERCICIO
					       AND E.CONTA           = A.CONTA
					       AND E.IDCONTACORRENTE = C.IDCONTACORRENTE
					       AND E.GRUPOEVENTO     = 85
					       AND E.EVENTO IN (SELECT EVENTO 
					                          FROM ${db.contabilidade.schema}.TABELAEVENTO 
					                         WHERE ENTIDADE      = A.ENTIDADE 
					                           AND EXERCICIO     = A.EXERCICIO 
					                           AND GRUPOEVENTO   = 85 
					                           AND ATUALIZAPLANO = 'N')) AS SALDOEXERCICIOANTERIOR
                  FROM ${db.contabilidade.schema}.EXERCICIO_MES M
                  LEFT JOIN ELOPORTALREPASSES A
				    ON A.ENTIDADE  = M.ENTIDADE
                   AND A.EXERCICIO = M.EXERCICIO
				   AND A.TIPO      = 'R'
                  LEFT JOIN ${db.contabilidade.schema}.EVENTOSLANCADOSCONTA C
                    ON C.ENTIDADE  = A.ENTIDADE 
                   AND C.EXERCICIO = A.EXERCICIO 
                   AND C.CONTA     = A.CONTA 
				   AND C.GRUPOEVENTO NOT IN (80,81,85,86) 
                  LEFT JOIN ${db.contabilidade.schema}.EVENTOSLANCADOS B
                    ON B.ENTIDADE                 = C.ENTIDADE 
                   AND B.EXERCICIO                = C.EXERCICIO 
                   AND B.TIPOEVENTO               = C.TIPOEVENTO 
                   AND B.GRUPOEVENTO              = C.GRUPOEVENTO 
                   AND B.EVENTO                   = C.EVENTO 
                   AND B.NROLANCAMENTO            = C.NROLANCAMENTO 
				   AND EXTRACT(MONTH FROM B.DATA) = M.MES
                 WHERE M.ENTIDADE  = :entidade
                   AND M.EXERCICIO = :exercicio
                 GROUP BY  A.ENTIDADE, A.EXERCICIO, A.CONTA, C.IDCONTACORRENTE, A.TIPO, M.MES
     ) TB1
     GROUP BY TB1.ENTIDADE, TB1.EXERCICIO, TB1.MES
) TB2 
