SELECT X.TIPOLANCAMENTO,
       X.DESCRICAOTIPOLANCAMENTO,
       X.EXERCICIOLIQUIDACAO,
       X.NOLIQUIDACAO,
       X.EXERCICIOPAGAMENTO,
       X.NOPAGAMENTO,
       X.DATA,
       X.VALOR,
       X.NRODOCUMENTO,
       (X.VALOREMPENHO - X.VALORANULACAO + X.VALORESTANULACAO - X.VALORLIQUIDACAO + X.VALORESTLIQUIDACAO) AS VALORALIQUIDAR,
       (X.VALOREMPENHO - X.VALORANULACAO + X.VALORESTANULACAO - X.VALORPAGAMENTO + X.VALORESTPAGAMENTO - X.VALORRETENCAO + X.VALORESTRETENCAO) AS VALORAPAGAR
FROM (
SELECT 20 AS TIPOLANCAMENTO,
       'Empenho' AS DESCRICAOTIPOLANCAMENTO,
       0 AS EXERCICIOLIQUIDACAO,
       0 AS NOLIQUIDACAO,
       0 AS EXERCICIOPAGAMENTO,
       0 AS NOPAGAMENTO,
       E.DATA,
       E.VALOR,
       CAST('Emp: '||E.EMPENHO AS VARCHAR(100)) AS NRODOCUMENTO,
       E.VALOR AS VALOREMPENHO,
       0 AS VALORANULACAO,
	   0 AS VALORESTANULACAO,	  
	   0 AS VALORLIQUIDACAO,
	   0 AS VALORESTLIQUIDACAO,
	   0 AS VALORPAGAMENTO,
	   0 AS VALORESTPAGAMENTO,
	   0 AS VALORRETENCAO,
	   0 AS VALORESTRETENCAO
FROM ${db.contabilidade.schema}.EMPENHO E
WHERE E.ENTIDADE = :entidade
AND E.EXERCICIO = :exercicio
AND E.EMPENHO = :empenho
UNION ALL
SELECT 21 AS TIPOLANCAMENTO,
       'Anulação Empenho' AS DESCRICAOTIPOLANCAMENTO,
       0 AS EXERCICIOLIQUIDACAO,
       0 AS NOLIQUIDACAO,
       0 AS EXERCICIOPAGAMENTO,
       0 AS NOPAGAMENTO,
       E.DATA,
       E.VALOR,
       CAST('Anul:'||E.ANULACAO AS VARCHAR(100)) AS NRODOCUMENTO,
       EMP.VALOR AS VALOREMPENHO,
       (COALESCE((SELECT SUM(AE.VALOR)
                    FROM ${db.contabilidade.schema}.ANULACAOEMPENHO AE
                   WHERE AE.ENTIDADE  = :entidade
                     AND AE.EXERCICIO = :exercicio
                     AND AE.EMPENHO   = :empenho
	                 AND AE.DATA     <= E.DATA
                     AND AE.ANULACAO <= E.ANULACAO),0) +
		COALESCE((SELECT SUM(C.VALOR)
                    FROM ${db.contabilidade.schema}.CANCELAMENTORESTOS C
                   WHERE C.ENTIDADE  = :entidade
                     AND C.EXERCICIO = :exercicio
                     AND C.EMPENHO   = :empenho
	                 AND C.DATA      < E.DATA),0)) AS VALORANULACAO,
	   (COALESCE((SELECT SUM(AE.VALOR)
                    FROM ${db.contabilidade.schema}.ANULACAOEMPENHO AE
                   WHERE AE.ENTIDADE     = :entidade
                     AND AE.EXERCICIO    = :exercicio
                     AND AE.EMPENHO      = :empenho
	                 AND AE.DATAESTORNO  < E.DATA
					 AND AE.DATAESTORNO IS NOT NULL),0) +
		COALESCE((SELECT SUM(C.VALOR)
                    FROM ${db.contabilidade.schema}.CANCELAMENTORESTOS C
                   WHERE C.ENTIDADE    = :entidade
                     AND C.EXERCICIO   = :exercicio
                     AND C.EMPENHO     = :empenho
	                 AND C.DATA        < E.DATA
					 AND C.FLAGESTORNO = 'S'),0)) AS VALORESTANULACAO,	   
	   (COALESCE((SELECT SUM(LIQ.VALOR)
                    FROM ${db.contabilidade.schema}.LIQUIDACAO LIQ
                   WHERE LIQ.ENTIDADE     = :entidade
                     AND LIQ.ANODOCORIGEM = :exercicio
					 AND LIQ.NODOCORIGEM  = :empenho
					 AND LIQ.DATA         < E.DATA),0)) AS VALORLIQUIDACAO,
	   (COALESCE((SELECT SUM(ESTLIQ.VALOR)
                    FROM ${db.contabilidade.schema}.ESTORNOLIQUIDACAO ESTLIQ
                   WHERE ESTLIQ.ENTIDADE     = :entidade
                     AND ESTLIQ.ANODOCORIGEM = :exercicio
					 AND ESTLIQ.NODOCORIGEM  = :empenho
					 AND ESTLIQ.DATA         < E.DATA),0)) AS VALORESTLIQUIDACAO,
	   (COALESCE((SELECT SUM(OP.VALOR)
                    FROM ${db.contabilidade.schema}.ORDEMPAGAMENTO_LIQUIDACAO OP
					LEFT JOIN ${db.contabilidade.schema}.PAGAMENTO P
                      ON P.ENTIDADE          = OP.ENTIDADE
                     AND P.ANOORDEMPAGAMENTO = OP.EXERCICIO
                     AND P.NOORDEMPAGAMENTO  = OP.NOORDEM
                   WHERE OP.ENTIDADE     = :entidade
                     AND OP.ANODOCORIGEM = :exercicio
					 AND OP.NODOCORIGEM  = :empenho
					 AND P.DATA          < E.DATA),0)) AS VALORPAGAMENTO,
	   (COALESCE((SELECT SUM(ESTPAG.VALOR)
                    FROM ${db.contabilidade.schema}.ESTORNOPAGAMENTO ESTPAG
					LEFT JOIN ${db.contabilidade.schema}.PAGAMENTO P
                      ON P.ENTIDADE    = ESTPAG.ENTIDADE
                     AND P.EXERCICIO   = ESTPAG.EXERCICIO
                     AND P.NOPAGAMENTO = ESTPAG.NOPAGAMENTO
					LEFT JOIN ${db.contabilidade.schema}.ORDEMPAGAMENTO_LIQUIDACAO OP
                      ON OP.ENTIDADE  = P.ENTIDADE
                     AND OP.EXERCICIO = P.ANOORDEMPAGAMENTO
                     AND OP.NOORDEM   = P.NOORDEMPAGAMENTO
                   WHERE OP.ENTIDADE     = :entidade
                     AND OP.ANODOCORIGEM = :exercicio
					 AND OP.NODOCORIGEM  = :empenho
					 AND ESTPAG.DATA     < E.DATA),0)) AS VALORESTPAGAMENTO,
	   (COALESCE((SELECT SUM(RET.VALOR)
                    FROM ${db.contabilidade.schema}.RETENCOESLIQUIDACAO RET
                   WHERE RET.ENTIDADE          = :entidade
                     AND RET.ANODOCORIGEM      = :exercicio
					 AND RET.NODOCORIGEM       = :empenho
					 AND RET.DATACONTABILIZADO < E.DATA),0)) AS VALORRETENCAO,
	   (COALESCE((SELECT SUM(RET.VALOR)
                    FROM ${db.contabilidade.schema}.RETENCOESLIQUIDACAO RET
                   WHERE RET.ENTIDADE             = :entidade
                     AND RET.ANODOCORIGEM         = :exercicio
					 AND RET.NODOCORIGEM          = :empenho
					 AND RET.DATAESTCONTABILIZADO < E.DATA
					 AND RET.DATAESTCONTABILIZADO IS NOT NULL),0)) AS VALORESTRETENCAO
FROM ${db.contabilidade.schema}.ANULACAOEMPENHO E
 LEFT OUTER JOIN ${db.contabilidade.schema}.EMPENHO EMP
   ON EMP.ENTIDADE  = E.ENTIDADE
  AND EMP.EXERCICIO = E.EXERCICIO
  AND EMP.EMPENHO   = E.EMPENHO
WHERE E.ENTIDADE = :entidade
AND E.EXERCICIO = :exercicio
AND E.EMPENHO = :empenho
UNION ALL
SELECT 22 AS TIPOLANCAMENTO,
       'Estorno Anulação Empenho' AS DESCRICAOTIPOLANCAMENTO,
       0 AS EXERCICIOLIQUIDACAO,
       0 AS NOLIQUIDACAO,
       0 AS EXERCICIOPAGAMENTO,
       0 AS NOPAGAMENTO,
       E.DATAESTORNO AS DATA,
       E.VALOR,
       CAST('Ref. a Anulação:'||E.ANULACAO AS VARCHAR(100)) AS NRODOCUMENTO,
       EMP.VALOR AS VALOREMPENHO,
	   (COALESCE((SELECT SUM(AE.VALOR)
                    FROM ${db.contabilidade.schema}.ANULACAOEMPENHO AE
                   WHERE AE.ENTIDADE  = :entidade
                     AND AE.EXERCICIO = :exercicio
                     AND AE.EMPENHO   = :empenho
                     AND AE.DATA     <= E.DATAESTORNO),0) +
		COALESCE((SELECT SUM(C.VALOR)
                    FROM ${db.contabilidade.schema}.CANCELAMENTORESTOS C
                   WHERE C.ENTIDADE  = :entidade
                     AND C.EXERCICIO = :exercicio
                     AND C.EMPENHO   = :empenho
                     AND C.DATA     <= E.DATAESTORNO),0)) AS VALORANULACAO,
	   (COALESCE((SELECT SUM(AE.VALOR)
                    FROM ${db.contabilidade.schema}.ANULACAOEMPENHO AE
                   WHERE AE.ENTIDADE     = :entidade
                     AND AE.EXERCICIO    = :exercicio
                     AND AE.EMPENHO      = :empenho
	                 AND AE.DATAESTORNO <= E.DATAESTORNO
                     AND AE.ANULACAO    <= E.ANULACAO
					 AND AE.DATAESTORNO IS NOT NULL),0) +
		COALESCE((SELECT SUM(C.VALOR)
                    FROM ${db.contabilidade.schema}.CANCELAMENTORESTOS C
                   WHERE C.ENTIDADE    = :entidade
                     AND C.EXERCICIO   = :exercicio
                     AND C.EMPENHO     = :empenho
	                 AND C.DATA        < E.DATAESTORNO
					 AND C.FLAGESTORNO = 'S'),0)) AS VALORESTANULACAO,
	   (COALESCE((SELECT SUM(LIQ.VALOR)
                    FROM ${db.contabilidade.schema}.LIQUIDACAO LIQ
                   WHERE LIQ.ENTIDADE     = :entidade
                     AND LIQ.ANODOCORIGEM = :exercicio
					 AND LIQ.NODOCORIGEM  = :empenho
					 AND LIQ.DATA         < E.DATAESTORNO),0)) AS VALORLIQUIDACAO,
	   (COALESCE((SELECT SUM(ESTLIQ.VALOR)
                    FROM ${db.contabilidade.schema}.ESTORNOLIQUIDACAO ESTLIQ
                   WHERE ESTLIQ.ENTIDADE     = :entidade
                     AND ESTLIQ.ANODOCORIGEM = :exercicio
					 AND ESTLIQ.NODOCORIGEM  = :empenho
					 AND ESTLIQ.DATA         < E.DATAESTORNO),0)) AS VALORESTLIQUIDACAO,
	   (COALESCE((SELECT SUM(OP.VALOR)
                    FROM ${db.contabilidade.schema}.ORDEMPAGAMENTO_LIQUIDACAO OP
					LEFT JOIN ${db.contabilidade.schema}.PAGAMENTO P
                      ON P.ENTIDADE          = OP.ENTIDADE
                     AND P.ANOORDEMPAGAMENTO = OP.EXERCICIO
                     AND P.NOORDEMPAGAMENTO  = OP.NOORDEM
                   WHERE OP.ENTIDADE     = :entidade
                     AND OP.ANODOCORIGEM = :exercicio
					 AND OP.NODOCORIGEM  = :empenho
					 AND P.DATA          < E.DATAESTORNO),0)) AS VALORPAGAMENTO,
	   (COALESCE((SELECT SUM(ESTPAG.VALOR)
                    FROM ${db.contabilidade.schema}.ESTORNOPAGAMENTO ESTPAG
					LEFT JOIN ${db.contabilidade.schema}.PAGAMENTO P
                      ON P.ENTIDADE    = ESTPAG.ENTIDADE
                     AND P.EXERCICIO   = ESTPAG.EXERCICIO
                     AND P.NOPAGAMENTO = ESTPAG.NOPAGAMENTO
					LEFT JOIN ${db.contabilidade.schema}.ORDEMPAGAMENTO_LIQUIDACAO OP
                      ON OP.ENTIDADE  = P.ENTIDADE
                     AND OP.EXERCICIO = P.ANOORDEMPAGAMENTO
                     AND OP.NOORDEM   = P.NOORDEMPAGAMENTO
                   WHERE OP.ENTIDADE     = :entidade
                     AND OP.ANODOCORIGEM = :exercicio
					 AND OP.NODOCORIGEM  = :empenho
					 AND ESTPAG.DATA     < E.DATAESTORNO),0)) AS VALORESTPAGAMENTO,
	   (COALESCE((SELECT SUM(RET.VALOR)
                    FROM ${db.contabilidade.schema}.RETENCOESLIQUIDACAO RET
                   WHERE RET.ENTIDADE          = :entidade
                     AND RET.ANODOCORIGEM      = :exercicio
					 AND RET.NODOCORIGEM       = :empenho
					 AND RET.DATACONTABILIZADO < E.DATAESTORNO),0)) AS VALORRETENCAO,
	   (COALESCE((SELECT SUM(RET.VALOR)
                    FROM ${db.contabilidade.schema}.RETENCOESLIQUIDACAO RET
                   WHERE RET.ENTIDADE             = :entidade
                     AND RET.ANODOCORIGEM         = :exercicio
					 AND RET.NODOCORIGEM          = :empenho
					 AND RET.DATAESTCONTABILIZADO < E.DATAESTORNO
					 AND RET.DATAESTCONTABILIZADO IS NOT NULL),0)) AS VALORESTRETENCAO
FROM ${db.contabilidade.schema}.ANULACAOEMPENHO E
 LEFT OUTER JOIN ${db.contabilidade.schema}.EMPENHO EMP
   ON EMP.ENTIDADE  = E.ENTIDADE
  AND EMP.EXERCICIO = E.EXERCICIO
  AND EMP.EMPENHO   = E.EMPENHO
WHERE E.ENTIDADE = :entidade
AND E.EXERCICIO = :exercicio
AND E.EMPENHO = :empenho
AND E.DATAESTORNO IS NOT NULL
UNION ALL
SELECT 21 AS TIPOLANCAMENTO,
       'Cancelamento Empenho' AS DESCRICAOTIPOLANCAMENTO,
       0 AS EXERCICIOLIQUIDACAO,
       0 AS NOLIQUIDACAO,
       0 AS EXERCICIOPAGAMENTO,
       0 AS NOPAGAMENTO,
       E.DATA,
       E.VALOR,
       CAST('Cancel: '||E.CANCELAMENTORESTOS AS VARCHAR(100)) AS NRODOCUMENTO,
       EMP.VALOR AS VALOREMPENHO,
       (COALESCE((SELECT SUM(AE.VALOR)
                    FROM ${db.contabilidade.schema}.ANULACAOEMPENHO AE
                   WHERE AE.ENTIDADE  = :entidade
                     AND AE.EXERCICIO = :exercicio
                     AND AE.EMPENHO   = :empenho
                     AND AE.DATA     <= E.DATA),0) +
		COALESCE((SELECT SUM(C.VALOR)
                    FROM ${db.contabilidade.schema}.CANCELAMENTORESTOS C
                   WHERE C.ENTIDADE            = :entidade
                     AND C.EXERCICIO           = :exercicio
                     AND C.EMPENHO             = :empenho
                     AND C.DATA               <= E.DATA
					 AND C.CANCELAMENTORESTOS <= E.CANCELAMENTORESTOS),0)) AS VALORANULACAO,
	   (COALESCE((SELECT SUM(AE.VALOR)
                    FROM ${db.contabilidade.schema}.ANULACAOEMPENHO AE
                   WHERE AE.ENTIDADE     = :entidade
                     AND AE.EXERCICIO    = :exercicio
                     AND AE.EMPENHO      = :empenho
	                 AND AE.DATAESTORNO  < E.DATA
					 AND AE.DATAESTORNO IS NOT NULL),0) +
		COALESCE((SELECT SUM(C.VALOR)
                    FROM ${db.contabilidade.schema}.CANCELAMENTORESTOS C
                   WHERE C.ENTIDADE    = :entidade
                     AND C.EXERCICIO   = :exercicio
                     AND C.EMPENHO     = :empenho
	                 AND C.DATA        < E.DATA
					 AND C.FLAGESTORNO = 'S'),0)) AS VALORESTANULACAO,
	   (COALESCE((SELECT SUM(LIQ.VALOR)
                    FROM ${db.contabilidade.schema}.LIQUIDACAO LIQ
                   WHERE LIQ.ENTIDADE     = :entidade
                     AND LIQ.ANODOCORIGEM = :exercicio
					 AND LIQ.NODOCORIGEM  = :empenho
					 AND LIQ.DATA         < E.DATA),0)) AS VALORLIQUIDACAO,
	   (COALESCE((SELECT SUM(ESTLIQ.VALOR)
                    FROM ${db.contabilidade.schema}.ESTORNOLIQUIDACAO ESTLIQ
                   WHERE ESTLIQ.ENTIDADE     = :entidade
                     AND ESTLIQ.ANODOCORIGEM = :exercicio
					 AND ESTLIQ.NODOCORIGEM  = :empenho
					 AND ESTLIQ.DATA         < E.DATA),0)) AS VALORESTLIQUIDACAO,
	   (COALESCE((SELECT SUM(OP.VALOR)
                    FROM ${db.contabilidade.schema}.ORDEMPAGAMENTO_LIQUIDACAO OP
					LEFT JOIN ${db.contabilidade.schema}.PAGAMENTO P
                      ON P.ENTIDADE          = OP.ENTIDADE
                     AND P.ANOORDEMPAGAMENTO = OP.EXERCICIO
                     AND P.NOORDEMPAGAMENTO  = OP.NOORDEM
                   WHERE OP.ENTIDADE     = :entidade
                     AND OP.ANODOCORIGEM = :exercicio
					 AND OP.NODOCORIGEM  = :empenho
					 AND P.DATA          < E.DATA),0)) AS VALORPAGAMENTO,
	   (COALESCE((SELECT SUM(ESTPAG.VALOR)
                    FROM ${db.contabilidade.schema}.ESTORNOPAGAMENTO ESTPAG
					LEFT JOIN ${db.contabilidade.schema}.PAGAMENTO P
                      ON P.ENTIDADE    = ESTPAG.ENTIDADE
                     AND P.EXERCICIO   = ESTPAG.EXERCICIO
                     AND P.NOPAGAMENTO = ESTPAG.NOPAGAMENTO
					LEFT JOIN ${db.contabilidade.schema}.ORDEMPAGAMENTO_LIQUIDACAO OP
                      ON OP.ENTIDADE  = P.ENTIDADE
                     AND OP.EXERCICIO = P.ANOORDEMPAGAMENTO
                     AND OP.NOORDEM   = P.NOORDEMPAGAMENTO
                   WHERE OP.ENTIDADE     = :entidade
                     AND OP.ANODOCORIGEM = :exercicio
					 AND OP.NODOCORIGEM  = :empenho
					 AND ESTPAG.DATA     < E.DATA),0)) AS VALORESTPAGAMENTO,
	   (COALESCE((SELECT SUM(RET.VALOR)
                    FROM ${db.contabilidade.schema}.RETENCOESLIQUIDACAO RET
                   WHERE RET.ENTIDADE          = :entidade
                     AND RET.ANODOCORIGEM      = :exercicio
					 AND RET.NODOCORIGEM       = :empenho
					 AND RET.DATACONTABILIZADO < E.DATA),0)) AS VALORRETENCAO,
	   (COALESCE((SELECT SUM(RET.VALOR)
                    FROM ${db.contabilidade.schema}.RETENCOESLIQUIDACAO RET
                   WHERE RET.ENTIDADE             = :entidade
                     AND RET.ANODOCORIGEM         = :exercicio
					 AND RET.NODOCORIGEM          = :empenho
					 AND RET.DATAESTCONTABILIZADO < E.DATA
					 AND RET.DATAESTCONTABILIZADO IS NOT NULL),0)) AS VALORESTRETENCAO
FROM ${db.contabilidade.schema}.CANCELAMENTORESTOS E
 LEFT OUTER JOIN ${db.contabilidade.schema}.EMPENHO EMP
   ON EMP.ENTIDADE  = E.ENTIDADE
  AND EMP.EXERCICIO = E.EXERCICIO
  AND EMP.EMPENHO   = E.EMPENHO
WHERE E.ENTIDADE = :entidade
AND E.EXERCICIO = :exercicio
AND E.EMPENHO = :empenho
UNION ALL
SELECT 22 AS TIPOLANCAMENTO,
       'Estorno Cancelamento Empenho' AS DESCRICAOTIPOLANCAMENTO,
       0 AS EXERCICIOLIQUIDACAO,
       0 AS NOLIQUIDACAO,
       0 AS EXERCICIOPAGAMENTO,
       0 AS NOPAGAMENTO,
       E.DATA,
       E.VALOR,
       CAST('Ref. ao Cancelamento '||E.CANCELAMENTORESTOS AS VARCHAR(100)) AS NRODOCUMENTO,
       EMP.VALOR AS VALOREMPENHO,
       (COALESCE((SELECT SUM(AE.VALOR)
                    FROM ${db.contabilidade.schema}.ANULACAOEMPENHO AE
                   WHERE AE.ENTIDADE  = :entidade
                     AND AE.EXERCICIO = :exercicio
                     AND AE.EMPENHO   = :empenho
                     AND AE.DATA     <= E.DATA),0) +
		COALESCE((SELECT SUM(C.VALOR)
                    FROM ${db.contabilidade.schema}.CANCELAMENTORESTOS C
                   WHERE C.ENTIDADE  = :entidade
                     AND C.EXERCICIO = :exercicio
                     AND C.EMPENHO   = :empenho
                     AND C.DATA     <= E.DATA),0)) AS VALORANULACAO,
	   (COALESCE((SELECT SUM(AE.VALOR)
                    FROM ${db.contabilidade.schema}.ANULACAOEMPENHO AE
                   WHERE AE.ENTIDADE     = :entidade
                     AND AE.EXERCICIO    = :exercicio
                     AND AE.EMPENHO      = :empenho
	                 AND AE.DATAESTORNO <= E.DATA
					 AND AE.DATAESTORNO IS NOT NULL),0) +
		COALESCE((SELECT SUM(C.VALOR)
                    FROM ${db.contabilidade.schema}.CANCELAMENTORESTOS C
                   WHERE C.ENTIDADE            = :entidade
                     AND C.EXERCICIO           = :exercicio
                     AND C.EMPENHO             = :empenho
	                 AND C.DATA               <= E.DATA
					 AND C.CANCELAMENTORESTOS <= E.CANCELAMENTORESTOS
					 AND C.FLAGESTORNO         = 'S'),0)) AS VALORESTANULACAO,	   
	   (COALESCE((SELECT SUM(LIQ.VALOR)
                    FROM ${db.contabilidade.schema}.LIQUIDACAO LIQ
                   WHERE LIQ.ENTIDADE     = :entidade
                     AND LIQ.ANODOCORIGEM = :exercicio
					 AND LIQ.NODOCORIGEM  = :empenho
					 AND LIQ.DATA         < E.DATA),0)) AS VALORLIQUIDACAO,
	   (COALESCE((SELECT SUM(ESTLIQ.VALOR)
                    FROM ${db.contabilidade.schema}.ESTORNOLIQUIDACAO ESTLIQ
                   WHERE ESTLIQ.ENTIDADE     = :entidade
                     AND ESTLIQ.ANODOCORIGEM = :exercicio
					 AND ESTLIQ.NODOCORIGEM  = :empenho
					 AND ESTLIQ.DATA         < E.DATA),0)) AS VALORESTLIQUIDACAO,
	   (COALESCE((SELECT SUM(OP.VALOR)
                    FROM ${db.contabilidade.schema}.ORDEMPAGAMENTO_LIQUIDACAO OP
					LEFT JOIN ${db.contabilidade.schema}.PAGAMENTO P
                      ON P.ENTIDADE          = OP.ENTIDADE
                     AND P.ANOORDEMPAGAMENTO = OP.EXERCICIO
                     AND P.NOORDEMPAGAMENTO  = OP.NOORDEM
                   WHERE OP.ENTIDADE     = :entidade
                     AND OP.ANODOCORIGEM = :exercicio
					 AND OP.NODOCORIGEM  = :empenho
					 AND P.DATA          < E.DATA),0)) AS VALORPAGAMENTO,
	   (COALESCE((SELECT SUM(ESTPAG.VALOR)
                    FROM ${db.contabilidade.schema}.ESTORNOPAGAMENTO ESTPAG
					LEFT JOIN ${db.contabilidade.schema}.PAGAMENTO P
                      ON P.ENTIDADE    = ESTPAG.ENTIDADE
                     AND P.EXERCICIO   = ESTPAG.EXERCICIO
                     AND P.NOPAGAMENTO = ESTPAG.NOPAGAMENTO
					LEFT JOIN ${db.contabilidade.schema}.ORDEMPAGAMENTO_LIQUIDACAO OP
                      ON OP.ENTIDADE  = P.ENTIDADE
                     AND OP.EXERCICIO = P.ANOORDEMPAGAMENTO
                     AND OP.NOORDEM   = P.NOORDEMPAGAMENTO
                   WHERE OP.ENTIDADE     = :entidade
                     AND OP.ANODOCORIGEM = :exercicio
					 AND OP.NODOCORIGEM  = :empenho
					 AND ESTPAG.DATA     < E.DATA),0)) AS VALORESTPAGAMENTO,
	   (COALESCE((SELECT SUM(RET.VALOR)
                    FROM ${db.contabilidade.schema}.RETENCOESLIQUIDACAO RET
                   WHERE RET.ENTIDADE          = :entidade
                     AND RET.ANODOCORIGEM      = :exercicio
					 AND RET.NODOCORIGEM       = :empenho
					 AND RET.DATACONTABILIZADO < E.DATA),0)) AS VALORRETENCAO,
	   (COALESCE((SELECT SUM(RET.VALOR)
                    FROM ${db.contabilidade.schema}.RETENCOESLIQUIDACAO RET
                   WHERE RET.ENTIDADE             = :entidade
                     AND RET.ANODOCORIGEM         = :exercicio
					 AND RET.NODOCORIGEM          = :empenho
					 AND RET.DATAESTCONTABILIZADO < E.DATA
					 AND RET.DATAESTCONTABILIZADO IS NOT NULL),0)) AS VALORESTRETENCAO
FROM ${db.contabilidade.schema}.CANCELAMENTORESTOS E
 LEFT OUTER JOIN ${db.contabilidade.schema}.EMPENHO EMP
   ON EMP.ENTIDADE  = E.ENTIDADE
  AND EMP.EXERCICIO = E.EXERCICIO
  AND EMP.EMPENHO   = E.EMPENHO
WHERE E.ENTIDADE = :entidade
AND E.EXERCICIO = :exercicio
AND E.EMPENHO = :empenho
AND E.FLAGESTORNO = 'S'
UNION ALL
SELECT 30 AS TIPOLANCAMENTO,
       'Liquidação ' AS DESCRICAOTIPOLANCAMENTO,
       L.EXERCICIO AS EXERCICIOLIQUIDACAO,
       L.NOLIQUIDACAO,
       0 AS EXERCICIOPAGAMENTO,
       0 AS NOPAGAMENTO,
       L.DATA,
       L.VALOR,
       CAST('Liq: '||L.NOLIQUIDACAO||'/'||L.EXERCICIO AS VARCHAR(100)) AS NRODOCUMENTO,
	   E.VALOR AS VALOREMPENHO,
       (COALESCE((SELECT SUM(AE.VALOR)
                    FROM ${db.contabilidade.schema}.ANULACAOEMPENHO AE
                   WHERE AE.ENTIDADE  = :entidade
                     AND AE.EXERCICIO = :exercicio
                     AND AE.EMPENHO   = :empenho
                     AND AE.DATA     <= L.DATA),0) +
		COALESCE((SELECT SUM(C.VALOR)
                    FROM ${db.contabilidade.schema}.CANCELAMENTORESTOS C
                   WHERE C.ENTIDADE  = :entidade
                     AND C.EXERCICIO = :exercicio
                     AND C.EMPENHO   = :empenho
                     AND C.DATA     <= L.DATA),0)) AS VALORANULACAO,
	   (COALESCE((SELECT SUM(AE.VALOR)
                    FROM ${db.contabilidade.schema}.ANULACAOEMPENHO AE
                   WHERE AE.ENTIDADE     = :entidade
                     AND AE.EXERCICIO    = :exercicio
                     AND AE.EMPENHO      = :empenho
	                 AND AE.DATAESTORNO <= L.DATA
					 AND AE.DATAESTORNO IS NOT NULL),0) +
		COALESCE((SELECT SUM(C.VALOR)
                    FROM ${db.contabilidade.schema}.CANCELAMENTORESTOS C
                   WHERE C.ENTIDADE           = :entidade
                     AND C.EXERCICIO          = :exercicio
                     AND C.EMPENHO            = :empenho
	                 AND C.DATA              <= L.DATA
					 AND C.FLAGESTORNO        = 'S'),0)) AS VALORESTANULACAO,	   
	   (COALESCE((SELECT SUM(LIQ.VALOR)
                    FROM ${db.contabilidade.schema}.LIQUIDACAO LIQ
                   WHERE LIQ.ENTIDADE      = :entidade
                     AND LIQ.ANODOCORIGEM  = :exercicio
					 AND LIQ.NODOCORIGEM   = :empenho
					 AND LIQ.DATA         <= L.DATA
					 AND LIQ.NOLIQUIDACAO <= L.NOLIQUIDACAO),0)) AS VALORLIQUIDACAO,
	   (COALESCE((SELECT SUM(ESTLIQ.VALOR)
                    FROM ${db.contabilidade.schema}.ESTORNOLIQUIDACAO ESTLIQ
                   WHERE ESTLIQ.ENTIDADE     = :entidade
                     AND ESTLIQ.ANODOCORIGEM = :exercicio
					 AND ESTLIQ.NODOCORIGEM  = :empenho
					 AND ESTLIQ.DATA         < L.DATA),0)) AS VALORESTLIQUIDACAO,
	   (COALESCE((SELECT SUM(OP.VALOR)
                    FROM ${db.contabilidade.schema}.ORDEMPAGAMENTO_LIQUIDACAO OP
					LEFT JOIN ${db.contabilidade.schema}.PAGAMENTO P
                      ON P.ENTIDADE          = OP.ENTIDADE
                     AND P.ANOORDEMPAGAMENTO = OP.EXERCICIO
                     AND P.NOORDEMPAGAMENTO  = OP.NOORDEM
                   WHERE OP.ENTIDADE     = :entidade
                     AND OP.ANODOCORIGEM = :exercicio
					 AND OP.NODOCORIGEM  = :empenho
					 AND P.DATA          < L.DATA),0)) AS VALORPAGAMENTO,
	   (COALESCE((SELECT SUM(ESTPAG.VALOR)
                    FROM ${db.contabilidade.schema}.ESTORNOPAGAMENTO ESTPAG
					LEFT JOIN ${db.contabilidade.schema}.PAGAMENTO P
                      ON P.ENTIDADE    = ESTPAG.ENTIDADE
                     AND P.EXERCICIO   = ESTPAG.EXERCICIO
                     AND P.NOPAGAMENTO = ESTPAG.NOPAGAMENTO
					LEFT JOIN ${db.contabilidade.schema}.ORDEMPAGAMENTO_LIQUIDACAO OP
                      ON OP.ENTIDADE  = P.ENTIDADE
                     AND OP.EXERCICIO = P.ANOORDEMPAGAMENTO
                     AND OP.NOORDEM   = P.NOORDEMPAGAMENTO
                   WHERE OP.ENTIDADE     = :entidade
                     AND OP.ANODOCORIGEM = :exercicio
					 AND OP.NODOCORIGEM  = :empenho
					 AND ESTPAG.DATA     < L.DATA),0)) AS VALORESTPAGAMENTO,
	   (COALESCE((SELECT SUM(RET.VALOR)
                    FROM ${db.contabilidade.schema}.RETENCOESLIQUIDACAO RET
                   WHERE RET.ENTIDADE          = :entidade
                     AND RET.ANODOCORIGEM      = :exercicio
					 AND RET.NODOCORIGEM       = :empenho
					 AND RET.DATACONTABILIZADO < L.DATA),0)) AS VALORRETENCAO,
	   (COALESCE((SELECT SUM(RET.VALOR)
                    FROM ${db.contabilidade.schema}.RETENCOESLIQUIDACAO RET
                   WHERE RET.ENTIDADE             = :entidade
                     AND RET.ANODOCORIGEM         = :exercicio
					 AND RET.NODOCORIGEM          = :empenho
					 AND RET.DATAESTCONTABILIZADO < L.DATA
					 AND RET.DATAESTCONTABILIZADO IS NOT NULL),0)) AS VALORESTRETENCAO      
FROM ${db.contabilidade.schema}.LIQUIDACAO L
LEFT OUTER JOIN ${db.contabilidade.schema}.EMPENHO E
  ON L.ENTIDADE         = E.ENTIDADE
 AND L.ANODOCORIGEM     = E.EXERCICIO
 AND L.NODOCORIGEM      = E.EMPENHO
 AND L.UNIDADEDOCORIGEM = E.UNIDADEORCAMENTARIA
WHERE E.ENTIDADE = :entidade
AND E.EXERCICIO = :exercicio
AND E.EMPENHO = :empenho
UNION ALL
SELECT 31 AS TIPOLANCAMENTO,
       'Estorno Liquidação ' AS DESCRICAOTIPOLANCAMENTO,
       L.EXERCICIOLIQ AS EXERCICIOLIQUIDACAO,
       L.NOLIQUIDACAO,
       0 AS EXERCICIOPAGAMENTO,
       0 AS NOPAGAMENTO,
       L.DATA,
       L.VALOR,
       CAST('Ref. a Liq: '||L.NOLIQUIDACAO||'/'||L.EXERCICIOLIQ AS VARCHAR(100)) AS NRODOCUMENTO,
       E.VALOR AS VALOREMPENHO,
       (COALESCE((SELECT SUM(AE.VALOR)
                    FROM ${db.contabilidade.schema}.ANULACAOEMPENHO AE
                   WHERE AE.ENTIDADE  = :entidade
                     AND AE.EXERCICIO = :exercicio
                     AND AE.EMPENHO   = :empenho
                     AND AE.DATA     <= L.DATA),0) +
		COALESCE((SELECT SUM(C.VALOR)
                    FROM ${db.contabilidade.schema}.CANCELAMENTORESTOS C
                   WHERE C.ENTIDADE  = :entidade
                     AND C.EXERCICIO = :exercicio
                     AND C.EMPENHO   = :empenho
                     AND C.DATA     <= L.DATA),0)) AS VALORANULACAO,
	   (COALESCE((SELECT SUM(AE.VALOR)
                    FROM ${db.contabilidade.schema}.ANULACAOEMPENHO AE
                   WHERE AE.ENTIDADE     = :entidade
                     AND AE.EXERCICIO    = :exercicio
                     AND AE.EMPENHO      = :empenho
	                 AND AE.DATAESTORNO <= L.DATA
					 AND AE.DATAESTORNO IS NOT NULL),0) +
		COALESCE((SELECT SUM(C.VALOR)
                    FROM ${db.contabilidade.schema}.CANCELAMENTORESTOS C
                   WHERE C.ENTIDADE           = :entidade
                     AND C.EXERCICIO          = :exercicio
                     AND C.EMPENHO            = :empenho
	                 AND C.DATA              <= L.DATA
					 AND C.FLAGESTORNO        = 'S'),0)) AS VALORESTANULACAO,	   
	   (COALESCE((SELECT SUM(LIQ.VALOR)
                    FROM ${db.contabilidade.schema}.LIQUIDACAO LIQ
                   WHERE LIQ.ENTIDADE      = :entidade
                     AND LIQ.ANODOCORIGEM  = :exercicio
					 AND LIQ.NODOCORIGEM   = :empenho
					 AND LIQ.DATA         <= L.DATA),0)) AS VALORLIQUIDACAO,
	   (COALESCE((SELECT SUM(ESTLIQ.VALOR)
                    FROM ${db.contabilidade.schema}.ESTORNOLIQUIDACAO ESTLIQ
                   WHERE ESTLIQ.ENTIDADE      = :entidade
                     AND ESTLIQ.ANODOCORIGEM  = :exercicio
					 AND ESTLIQ.NODOCORIGEM   = :empenho
					 AND ESTLIQ.DATA         <= L.DATA
					 AND ESTLIQ.NOLIQUIDACAO <= L.NOLIQUIDACAO),0)) AS VALORESTLIQUIDACAO,
	   (COALESCE((SELECT SUM(OP.VALOR)
                    FROM ${db.contabilidade.schema}.ORDEMPAGAMENTO_LIQUIDACAO OP
					LEFT JOIN ${db.contabilidade.schema}.PAGAMENTO P
                      ON P.ENTIDADE          = OP.ENTIDADE
                     AND P.ANOORDEMPAGAMENTO = OP.EXERCICIO
                     AND P.NOORDEMPAGAMENTO  = OP.NOORDEM
                   WHERE OP.ENTIDADE     = :entidade
                     AND OP.ANODOCORIGEM = :exercicio
					 AND OP.NODOCORIGEM  = :empenho
					 AND P.DATA          < L.DATA),0)) AS VALORPAGAMENTO,
	   (COALESCE((SELECT SUM(ESTPAG.VALOR)
                    FROM ${db.contabilidade.schema}.ESTORNOPAGAMENTO ESTPAG
					LEFT JOIN ${db.contabilidade.schema}.PAGAMENTO P
                      ON P.ENTIDADE    = ESTPAG.ENTIDADE
                     AND P.EXERCICIO   = ESTPAG.EXERCICIO
                     AND P.NOPAGAMENTO = ESTPAG.NOPAGAMENTO
					LEFT JOIN ${db.contabilidade.schema}.ORDEMPAGAMENTO_LIQUIDACAO OP
                      ON OP.ENTIDADE  = P.ENTIDADE
                     AND OP.EXERCICIO = P.ANOORDEMPAGAMENTO
                     AND OP.NOORDEM   = P.NOORDEMPAGAMENTO
                   WHERE OP.ENTIDADE     = :entidade
                     AND OP.ANODOCORIGEM = :exercicio
					 AND OP.NODOCORIGEM  = :empenho
					 AND ESTPAG.DATA     < L.DATA),0)) AS VALORESTPAGAMENTO,
	   (COALESCE((SELECT SUM(RET.VALOR)
                    FROM ${db.contabilidade.schema}.RETENCOESLIQUIDACAO RET
                   WHERE RET.ENTIDADE          = :entidade
                     AND RET.ANODOCORIGEM      = :exercicio
					 AND RET.NODOCORIGEM       = :empenho
					 AND RET.DATACONTABILIZADO < L.DATA),0)) AS VALORRETENCAO,
	   (COALESCE((SELECT SUM(RET.VALOR)
                    FROM ${db.contabilidade.schema}.RETENCOESLIQUIDACAO RET
                   WHERE RET.ENTIDADE             = :entidade
                     AND RET.ANODOCORIGEM         = :exercicio
					 AND RET.NODOCORIGEM          = :empenho
					 AND RET.DATAESTCONTABILIZADO < L.DATA
					 AND RET.DATAESTCONTABILIZADO IS NOT NULL),0)) AS VALORESTRETENCAO
FROM ${db.contabilidade.schema}.ESTORNOLIQUIDACAO L
LEFT OUTER JOIN ${db.contabilidade.schema}.EMPENHO E
  ON L.ENTIDADE = E.ENTIDADE
 AND L.ANODOCORIGEM = E.EXERCICIO
 AND L.NODOCORIGEM = E.EMPENHO
 AND L.UNIDADEDOCORIGEM = E.UNIDADEORCAMENTARIA
WHERE E.ENTIDADE = :entidade
AND E.EXERCICIO = :exercicio
AND E.EMPENHO = :empenho
UNION ALL
SELECT 40 AS TIPOLANCAMENTO,
       'Pagamento ' AS DESCRICAOTIPOLANCAMENTO,
       PAG.EXERCICIO AS EXERCICIOPAGAMENTO,
       PAG.NOPAGAMENTO,
       A.EXERCICIOLIQ AS EXERCICIOLIQUIDACAO,
       A.NOLIQUIDACAO,
       PAG.DATA,
       A.VALOR,
       CAST('Pagto No. '||PAG.NOPAGAMENTO||'/'||PAG.EXERCICIO AS VARCHAR(100)) AS NRODOCUMENTO,
       E.VALOR AS VALOREMPENHO,
       (COALESCE((SELECT SUM(AE.VALOR)
                    FROM ${db.contabilidade.schema}.ANULACAOEMPENHO AE
                   WHERE AE.ENTIDADE  = :entidade
                     AND AE.EXERCICIO = :exercicio
                     AND AE.EMPENHO   = :empenho
                     AND AE.DATA     <= PAG.DATA),0) +
		COALESCE((SELECT SUM(C.VALOR)
                    FROM ${db.contabilidade.schema}.CANCELAMENTORESTOS C
                   WHERE C.ENTIDADE  = :entidade
                     AND C.EXERCICIO = :exercicio
                     AND C.EMPENHO   = :empenho
                     AND C.DATA     <= PAG.DATA),0)) AS VALORANULACAO,
	   (COALESCE((SELECT SUM(AE.VALOR)
                    FROM ${db.contabilidade.schema}.ANULACAOEMPENHO AE
                   WHERE AE.ENTIDADE     = :entidade
                     AND AE.EXERCICIO    = :exercicio
                     AND AE.EMPENHO      = :empenho
	                 AND AE.DATAESTORNO <= PAG.DATA
					 AND AE.DATAESTORNO IS NOT NULL),0) +
		COALESCE((SELECT SUM(C.VALOR)
                    FROM ${db.contabilidade.schema}.CANCELAMENTORESTOS C
                   WHERE C.ENTIDADE           = :entidade
                     AND C.EXERCICIO          = :exercicio
                     AND C.EMPENHO            = :empenho
	                 AND C.DATA              <= PAG.DATA
					 AND C.FLAGESTORNO        = 'S'),0)) AS VALORESTANULACAO,	   
	   (COALESCE((SELECT SUM(LIQ.VALOR)
                    FROM ${db.contabilidade.schema}.LIQUIDACAO LIQ
                   WHERE LIQ.ENTIDADE      = :entidade
                     AND LIQ.ANODOCORIGEM  = :exercicio
					 AND LIQ.NODOCORIGEM   = :empenho
					 AND LIQ.DATA         <= PAG.DATA),0)) AS VALORLIQUIDACAO,
	   (COALESCE((SELECT SUM(ESTLIQ.VALOR)
                    FROM ${db.contabilidade.schema}.ESTORNOLIQUIDACAO ESTLIQ
                   WHERE ESTLIQ.ENTIDADE     = :entidade
                     AND ESTLIQ.ANODOCORIGEM = :exercicio
					 AND ESTLIQ.NODOCORIGEM  = :empenho
					 AND ESTLIQ.DATA        <= PAG.DATA),0)) AS VALORESTLIQUIDACAO,
	   (COALESCE((SELECT SUM(OP.VALOR)
                    FROM ${db.contabilidade.schema}.ORDEMPAGAMENTO_LIQUIDACAO OP
					LEFT JOIN ${db.contabilidade.schema}.PAGAMENTO P
                      ON P.ENTIDADE          = OP.ENTIDADE
                     AND P.ANOORDEMPAGAMENTO = OP.EXERCICIO
                     AND P.NOORDEMPAGAMENTO  = OP.NOORDEM
                   WHERE OP.ENTIDADE     = :entidade
                     AND OP.ANODOCORIGEM = :exercicio
					 AND OP.NODOCORIGEM  = :empenho
					 AND P.DATA         <= PAG.DATA
					 AND CAST(P.EXERCICIO || LPAD(CAST(P.NOPAGAMENTO AS VARCHAR(10)),10,'0') AS VARCHAR(14)) <=
					     CAST(PAG.EXERCICIO || LPAD(CAST(PAG.NOPAGAMENTO AS VARCHAR(10)),10,'0') AS VARCHAR(14))),0)) AS VALORPAGAMENTO,
	   (COALESCE((SELECT SUM(ESTPAG.VALOR)
                    FROM ${db.contabilidade.schema}.ESTORNOPAGAMENTO ESTPAG
					LEFT JOIN ${db.contabilidade.schema}.PAGAMENTO P
                      ON P.ENTIDADE    = ESTPAG.ENTIDADE
                     AND P.EXERCICIO   = ESTPAG.EXERCICIO
                     AND P.NOPAGAMENTO = ESTPAG.NOPAGAMENTO
					LEFT JOIN ${db.contabilidade.schema}.ORDEMPAGAMENTO_LIQUIDACAO OP
                      ON OP.ENTIDADE  = P.ENTIDADE
                     AND OP.EXERCICIO = P.ANOORDEMPAGAMENTO
                     AND OP.NOORDEM   = P.NOORDEMPAGAMENTO
                   WHERE OP.ENTIDADE     = :entidade
                     AND OP.ANODOCORIGEM = :exercicio
					 AND OP.NODOCORIGEM  = :empenho
					 AND ESTPAG.DATA     < PAG.DATA),0)) AS VALORESTPAGAMENTO,
	   (COALESCE((SELECT SUM(RET.VALOR)
                    FROM ${db.contabilidade.schema}.RETENCOESLIQUIDACAO RET
                   WHERE RET.ENTIDADE          = :entidade
                     AND RET.ANODOCORIGEM      = :exercicio
					 AND RET.NODOCORIGEM       = :empenho
					 AND RET.DATACONTABILIZADO < PAG.DATA),0)) AS VALORRETENCAO,
	   (COALESCE((SELECT SUM(RET.VALOR)
                    FROM ${db.contabilidade.schema}.RETENCOESLIQUIDACAO RET
                   WHERE RET.ENTIDADE             = :entidade
                     AND RET.ANODOCORIGEM         = :exercicio
					 AND RET.NODOCORIGEM          = :empenho
					 AND RET.DATAESTCONTABILIZADO < PAG.DATA
					 AND RET.DATAESTCONTABILIZADO IS NOT NULL),0)) AS VALORESTRETENCAO
 FROM ${db.contabilidade.schema}.PAGAMENTO PAG
 LEFT OUTER JOIN ${db.contabilidade.schema}.ORDEMPAGAMENTO_LIQUIDACAO A
   ON A.ENTIDADE = PAG.ENTIDADE
  AND A.EXERCICIO = PAG.ANOORDEMPAGAMENTO
  AND A.NOORDEM = PAG.NOORDEMPAGAMENTO
 LEFT OUTER JOIN ${db.contabilidade.schema}.ORDEMPAGAMENTO OP
   ON A.ENTIDADE = OP.ENTIDADE
  AND A.EXERCICIO = OP.EXERCICIO
  AND A.NOORDEM = OP.NOORDEM
 LEFT OUTER JOIN ${db.contabilidade.schema}.TIPODOCUMENTO TD
   ON PAG.TIPO = TD.TIPODOCUMENTO
 LEFT OUTER JOIN ${db.contabilidade.schema}.CONTACORRENTE CC
   ON PAG.ENTIDADE = CC.ENTIDADE
  AND PAG.IDCONTACORRENTE = CC.IDCONTACORRENTE
 LEFT OUTER JOIN ${db.contabilidade.schema}.CONTABANCARIAVINCULO CBV
   ON CC.ENTIDADE = CBV.ENTIDADE
  AND CC.IDCONTABANCARIAVINCULO = CBV.ID
 LEFT OUTER JOIN ${db.contabilidade.schema}.CONTABANCARIA CB
   ON PAG.ENTIDADE = CB.ENTIDADE
  AND CBV.REDUZIDO = CB.REDUZIDO
 LEFT OUTER JOIN ${db.contabilidade.schema}.EMPENHO E
   ON A.ENTIDADE = E.ENTIDADE
  AND A.ANODOCORIGEM = E.EXERCICIO
  AND A.NODOCORIGEM = E.EMPENHO
  AND A.UNIDADEDOCORIGEM = E.UNIDADEORCAMENTARIA 
WHERE E.ENTIDADE = :entidade
AND E.EXERCICIO = :exercicio
AND E.EMPENHO = :empenho
UNION ALL
SELECT 41 AS TIPOLANCAMENTO,
       'Estorno Pagamento' AS DESCRICAOTIPOLANCAMENTO,
       PAG.EXERCICIO AS EXERCICIOPAGAMENTO,
       PAG.NOPAGAMENTO,
       A.EXERCICIOLIQ AS EXERCICIOLIQUIDACAO,
       A.NOLIQUIDACAO,
       EST.DATA,
       EST.VALOR,
       CAST('Ref. ao Pagto No. '||PAG.NOPAGAMENTO||'/'||PAG.EXERCICIO AS VARCHAR(100)) AS NRODOCUMENTO,
       E.VALOR AS VALOREMPENHO,
       (COALESCE((SELECT SUM(AE.VALOR)
                    FROM ${db.contabilidade.schema}.ANULACAOEMPENHO AE
                   WHERE AE.ENTIDADE  = :entidade
                     AND AE.EXERCICIO = :exercicio
                     AND AE.EMPENHO   = :empenho
                     AND AE.DATA     <= EST.DATA),0) +
		COALESCE((SELECT SUM(C.VALOR)
                    FROM ${db.contabilidade.schema}.CANCELAMENTORESTOS C
                   WHERE C.ENTIDADE  = :entidade
                     AND C.EXERCICIO = :exercicio
                     AND C.EMPENHO   = :empenho
                     AND C.DATA     <= EST.DATA),0)) AS VALORANULACAO,
	   (COALESCE((SELECT SUM(AE.VALOR)
                    FROM ${db.contabilidade.schema}.ANULACAOEMPENHO AE
                   WHERE AE.ENTIDADE     = :entidade
                     AND AE.EXERCICIO    = :exercicio
                     AND AE.EMPENHO      = :empenho
	                 AND AE.DATAESTORNO <= EST.DATA
					 AND AE.DATAESTORNO IS NOT NULL),0) +
		COALESCE((SELECT SUM(C.VALOR)
                    FROM ${db.contabilidade.schema}.CANCELAMENTORESTOS C
                   WHERE C.ENTIDADE           = :entidade
                     AND C.EXERCICIO          = :exercicio
                     AND C.EMPENHO            = :empenho
	                 AND C.DATA              <= EST.DATA
					 AND C.FLAGESTORNO        = 'S'),0)) AS VALORESTANULACAO,	   
	   (COALESCE((SELECT SUM(LIQ.VALOR)
                    FROM ${db.contabilidade.schema}.LIQUIDACAO LIQ
                   WHERE LIQ.ENTIDADE      = :entidade
                     AND LIQ.ANODOCORIGEM  = :exercicio
					 AND LIQ.NODOCORIGEM   = :empenho
					 AND LIQ.DATA         <= EST.DATA),0)) AS VALORLIQUIDACAO,
	   (COALESCE((SELECT SUM(ESTLIQ.VALOR)
                    FROM ${db.contabilidade.schema}.ESTORNOLIQUIDACAO ESTLIQ
                   WHERE ESTLIQ.ENTIDADE     = :entidade
                     AND ESTLIQ.ANODOCORIGEM = :exercicio
					 AND ESTLIQ.NODOCORIGEM  = :empenho
					 AND ESTLIQ.DATA        <= EST.DATA),0)) AS VALORESTLIQUIDACAO,
	   (COALESCE((SELECT SUM(OP.VALOR)
                    FROM ${db.contabilidade.schema}.ORDEMPAGAMENTO_LIQUIDACAO OP
					LEFT JOIN ${db.contabilidade.schema}.PAGAMENTO P
                      ON P.ENTIDADE          = OP.ENTIDADE
                     AND P.ANOORDEMPAGAMENTO = OP.EXERCICIO
                     AND P.NOORDEMPAGAMENTO  = OP.NOORDEM
                   WHERE OP.ENTIDADE     = :entidade
                     AND OP.ANODOCORIGEM = :exercicio
					 AND OP.NODOCORIGEM  = :empenho
					 AND P.DATA         <= EST.DATA),0)) AS VALORPAGAMENTO,
	   (COALESCE((SELECT SUM(ESTPAG.VALOR)
                    FROM ${db.contabilidade.schema}.ESTORNOPAGAMENTO ESTPAG
					LEFT JOIN ${db.contabilidade.schema}.PAGAMENTO P
                      ON P.ENTIDADE    = ESTPAG.ENTIDADE
                     AND P.EXERCICIO   = ESTPAG.EXERCICIO
                     AND P.NOPAGAMENTO = ESTPAG.NOPAGAMENTO
					LEFT JOIN ${db.contabilidade.schema}.ORDEMPAGAMENTO_LIQUIDACAO OP
                      ON OP.ENTIDADE  = P.ENTIDADE
                     AND OP.EXERCICIO = P.ANOORDEMPAGAMENTO
                     AND OP.NOORDEM   = P.NOORDEMPAGAMENTO
                   WHERE OP.ENTIDADE     = :entidade
                     AND OP.ANODOCORIGEM = :exercicio
					 AND OP.NODOCORIGEM  = :empenho
					 AND ESTPAG.DATA    <= EST.DATA
					 AND CAST(P.EXERCICIO || LPAD(CAST(P.NOPAGAMENTO AS VARCHAR(10)),10,'0') AS VARCHAR(14)) <=
					     CAST(PAG.EXERCICIO || LPAD(CAST(PAG.NOPAGAMENTO AS VARCHAR(10)),10,'0') AS VARCHAR(14))),0)) AS VALORESTPAGAMENTO,
	   (COALESCE((SELECT SUM(RET.VALOR)
                    FROM ${db.contabilidade.schema}.RETENCOESLIQUIDACAO RET
                   WHERE RET.ENTIDADE          = :entidade
                     AND RET.ANODOCORIGEM      = :exercicio
					 AND RET.NODOCORIGEM       = :empenho
					 AND RET.DATACONTABILIZADO < EST.DATA),0)) AS VALORRETENCAO,
	   (COALESCE((SELECT SUM(RET.VALOR)
                    FROM ${db.contabilidade.schema}.RETENCOESLIQUIDACAO RET
                   WHERE RET.ENTIDADE             = :entidade
                     AND RET.ANODOCORIGEM         = :exercicio
					 AND RET.NODOCORIGEM          = :empenho
					 AND RET.DATAESTCONTABILIZADO < EST.DATA
					 AND RET.DATAESTCONTABILIZADO IS NOT NULL),0)) AS VALORESTRETENCAO
FROM ${db.contabilidade.schema}.ESTORNOPAGAMENTO EST
LEFT OUTER JOIN ${db.contabilidade.schema}.PAGAMENTO PAG
   ON EST.ENTIDADE = PAG.ENTIDADE
  AND EST.EXERCICIO = PAG.EXERCICIO
  AND EST.NOPAGAMENTO = PAG.NOPAGAMENTO
 LEFT OUTER JOIN ${db.contabilidade.schema}.ORDEMPAGAMENTO_LIQUIDACAO A
   ON A.ENTIDADE = PAG.ENTIDADE
  AND A.EXERCICIO = PAG.ANOORDEMPAGAMENTO
  AND A.NOORDEM = PAG.NOORDEMPAGAMENTO
 LEFT OUTER JOIN ${db.contabilidade.schema}.EMPENHO E
   ON A.ENTIDADE = E.ENTIDADE
  AND A.ANODOCORIGEM = E.EXERCICIO
  AND A.NODOCORIGEM = E.EMPENHO
  AND A.UNIDADEDOCORIGEM = E.UNIDADEORCAMENTARIA 
WHERE E.ENTIDADE = :entidade
AND E.EXERCICIO = :exercicio
AND E.EMPENHO = :empenho
UNION ALL
SELECT 50 AS TIPOLANCAMENTO,
       'Retenção ' AS DESCRICAOTIPOLANCAMENTO,
       A.EXERCICIO AS EXERCICIOLIQUIDACAO,
       A.NOLIQUIDACAO,
       0 AS EXERCICIOPAGAMENTO,
       0 AS NOPAGAMENTO,
       A.DATACONTABILIZADO AS DATA,
       SUM(A.VALOR) AS VALOR,
       CAST('Retenção Liq. '||A.NOLIQUIDACAO||'/'||A.EXERCICIO AS VARCHAR(100)) AS NRODOCUMENTO,
       E.VALOR AS VALOREMPENHO,
       (COALESCE((SELECT SUM(AE.VALOR)
                    FROM ${db.contabilidade.schema}.ANULACAOEMPENHO AE
                   WHERE AE.ENTIDADE  = :entidade
                     AND AE.EXERCICIO = :exercicio
                     AND AE.EMPENHO   = :empenho
                     AND AE.DATA     <= A.DATACONTABILIZADO),0) +
		COALESCE((SELECT SUM(C.VALOR)
                    FROM ${db.contabilidade.schema}.CANCELAMENTORESTOS C
                   WHERE C.ENTIDADE  = :entidade
                     AND C.EXERCICIO = :exercicio
                     AND C.EMPENHO   = :empenho
                     AND C.DATA     <= A.DATACONTABILIZADO),0)) AS VALORANULACAO,
	   (COALESCE((SELECT SUM(AE.VALOR)
                    FROM ${db.contabilidade.schema}.ANULACAOEMPENHO AE
                   WHERE AE.ENTIDADE     = :entidade
                     AND AE.EXERCICIO    = :exercicio
                     AND AE.EMPENHO      = :empenho
	                 AND AE.DATAESTORNO <= A.DATACONTABILIZADO
					 AND AE.DATAESTORNO IS NOT NULL),0) +
		COALESCE((SELECT SUM(C.VALOR)
                    FROM ${db.contabilidade.schema}.CANCELAMENTORESTOS C
                   WHERE C.ENTIDADE           = :entidade
                     AND C.EXERCICIO          = :exercicio
                     AND C.EMPENHO            = :empenho
	                 AND C.DATA              <= A.DATACONTABILIZADO
					 AND C.FLAGESTORNO        = 'S'),0)) AS VALORESTANULACAO,	   
	   (COALESCE((SELECT SUM(LIQ.VALOR)
                    FROM ${db.contabilidade.schema}.LIQUIDACAO LIQ
                   WHERE LIQ.ENTIDADE      = :entidade
                     AND LIQ.ANODOCORIGEM  = :exercicio
					 AND LIQ.NODOCORIGEM   = :empenho
					 AND LIQ.DATA         <= A.DATACONTABILIZADO),0)) AS VALORLIQUIDACAO,
	   (COALESCE((SELECT SUM(ESTLIQ.VALOR)
                    FROM ${db.contabilidade.schema}.ESTORNOLIQUIDACAO ESTLIQ
                   WHERE ESTLIQ.ENTIDADE     = :entidade
                     AND ESTLIQ.ANODOCORIGEM = :exercicio
					 AND ESTLIQ.NODOCORIGEM  = :empenho
					 AND ESTLIQ.DATA        <= A.DATACONTABILIZADO),0)) AS VALORESTLIQUIDACAO,
	   (COALESCE((SELECT SUM(OP.VALOR)
                    FROM ${db.contabilidade.schema}.ORDEMPAGAMENTO_LIQUIDACAO OP
					LEFT JOIN ${db.contabilidade.schema}.PAGAMENTO P
                      ON P.ENTIDADE          = OP.ENTIDADE
                     AND P.ANOORDEMPAGAMENTO = OP.EXERCICIO
                     AND P.NOORDEMPAGAMENTO  = OP.NOORDEM
                   WHERE OP.ENTIDADE     = :entidade
                     AND OP.ANODOCORIGEM = :exercicio
					 AND OP.NODOCORIGEM  = :empenho
					 AND P.DATA         <= A.DATACONTABILIZADO),0)) AS VALORPAGAMENTO,
	   (COALESCE((SELECT SUM(ESTPAG.VALOR)
                    FROM ${db.contabilidade.schema}.ESTORNOPAGAMENTO ESTPAG
					LEFT JOIN ${db.contabilidade.schema}.PAGAMENTO P
                      ON P.ENTIDADE    = ESTPAG.ENTIDADE
                     AND P.EXERCICIO   = ESTPAG.EXERCICIO
                     AND P.NOPAGAMENTO = ESTPAG.NOPAGAMENTO
					LEFT JOIN ${db.contabilidade.schema}.ORDEMPAGAMENTO_LIQUIDACAO OP
                      ON OP.ENTIDADE  = P.ENTIDADE
                     AND OP.EXERCICIO = P.ANOORDEMPAGAMENTO
                     AND OP.NOORDEM   = P.NOORDEMPAGAMENTO
                   WHERE OP.ENTIDADE     = :entidade
                     AND OP.ANODOCORIGEM = :exercicio
					 AND OP.NODOCORIGEM  = :empenho
					 AND ESTPAG.DATA    <= A.DATACONTABILIZADO),0)) AS VALORESTPAGAMENTO,
	   (COALESCE((SELECT SUM(RET.VALOR)
                    FROM ${db.contabilidade.schema}.RETENCOESLIQUIDACAO RET
                   WHERE RET.ENTIDADE           = :entidade
                     AND RET.ANODOCORIGEM       = :exercicio
					 AND RET.NODOCORIGEM        = :empenho
					 AND RET.DATACONTABILIZADO <= A.DATACONTABILIZADO
					 AND RET.NOLIQUIDACAO      <= A.NOLIQUIDACAO),0)) AS VALORRETENCAO,
	   (COALESCE((SELECT SUM(RET.VALOR)
                    FROM ${db.contabilidade.schema}.RETENCOESLIQUIDACAO RET
                   WHERE RET.ENTIDADE             = :entidade
                     AND RET.ANODOCORIGEM         = :exercicio
					 AND RET.NODOCORIGEM          = :empenho
					 AND RET.DATAESTCONTABILIZADO < A.DATACONTABILIZADO
					 AND RET.DATAESTCONTABILIZADO IS NOT NULL),0)) AS VALORESTRETENCAO
 FROM ${db.contabilidade.schema}.RETENCOESLIQUIDACAO A
 LEFT OUTER JOIN ${db.contabilidade.schema}.EMPENHO E
   ON A.ENTIDADE = E.ENTIDADE
  AND A.ANODOCORIGEM = E.EXERCICIO
  AND A.NODOCORIGEM = E.EMPENHO
  AND A.UNIDADEDOCORIGEM = E.UNIDADEORCAMENTARIA 
WHERE E.ENTIDADE = :entidade
AND E.EXERCICIO = :exercicio
AND E.EMPENHO = :empenho
AND A.DATACONTABILIZADO IS NOT NULL
GROUP BY A.EXERCICIO, A.NOLIQUIDACAO, A.DATACONTABILIZADO, E.VALOR
UNION ALL
SELECT 51 AS TIPOLANCAMENTO,
       'Est Retenção ' AS DESCRICAOTIPOLANCAMENTO,
       A.EXERCICIO AS EXERCICIOLIQUIDACAO,
       A.NOLIQUIDACAO,
       0 AS EXERCICIOPAGAMENTO,
       0 AS NOPAGAMENTO,
       A.DATAESTCONTABILIZADO AS DATA,
       SUM(A.VALOR) AS VALOR,
       CAST('Est Ret Liq. '||A.NOLIQUIDACAO||'/'||A.EXERCICIO AS VARCHAR(100)) AS NRODOCUMENTO,
       E.VALOR AS VALOREMPENHO,
       (COALESCE((SELECT SUM(AE.VALOR)
                    FROM ${db.contabilidade.schema}.ANULACAOEMPENHO AE
                   WHERE AE.ENTIDADE  = :entidade
                     AND AE.EXERCICIO = :exercicio
                     AND AE.EMPENHO   = :empenho
                     AND AE.DATA     <= A.DATAESTCONTABILIZADO),0) +
		COALESCE((SELECT SUM(C.VALOR)
                    FROM ${db.contabilidade.schema}.CANCELAMENTORESTOS C
                   WHERE C.ENTIDADE  = :entidade
                     AND C.EXERCICIO = :exercicio
                     AND C.EMPENHO   = :empenho
                     AND C.DATA     <= A.DATAESTCONTABILIZADO),0)) AS VALORANULACAO,
	   (COALESCE((SELECT SUM(AE.VALOR)
                    FROM ${db.contabilidade.schema}.ANULACAOEMPENHO AE
                   WHERE AE.ENTIDADE     = :entidade
                     AND AE.EXERCICIO    = :exercicio
                     AND AE.EMPENHO      = :empenho
	                 AND AE.DATAESTORNO <= A.DATAESTCONTABILIZADO
					 AND AE.DATAESTORNO IS NOT NULL),0) +
		COALESCE((SELECT SUM(C.VALOR)
                    FROM ${db.contabilidade.schema}.CANCELAMENTORESTOS C
                   WHERE C.ENTIDADE           = :entidade
                     AND C.EXERCICIO          = :exercicio
                     AND C.EMPENHO            = :empenho
	                 AND C.DATA              <= A.DATAESTCONTABILIZADO
					 AND C.FLAGESTORNO        = 'S'),0)) AS VALORESTANULACAO,	   
	   (COALESCE((SELECT SUM(LIQ.VALOR)
                    FROM ${db.contabilidade.schema}.LIQUIDACAO LIQ
                   WHERE LIQ.ENTIDADE      = :entidade
                     AND LIQ.ANODOCORIGEM  = :exercicio
					 AND LIQ.NODOCORIGEM   = :empenho
					 AND LIQ.DATA         <= A.DATAESTCONTABILIZADO),0)) AS VALORLIQUIDACAO,
	   (COALESCE((SELECT SUM(ESTLIQ.VALOR)
                    FROM ${db.contabilidade.schema}.ESTORNOLIQUIDACAO ESTLIQ
                   WHERE ESTLIQ.ENTIDADE     = :entidade
                     AND ESTLIQ.ANODOCORIGEM = :exercicio
					 AND ESTLIQ.NODOCORIGEM  = :empenho
					 AND ESTLIQ.DATA        <= A.DATAESTCONTABILIZADO),0)) AS VALORESTLIQUIDACAO,
	   (COALESCE((SELECT SUM(OP.VALOR)
                    FROM ${db.contabilidade.schema}.ORDEMPAGAMENTO_LIQUIDACAO OP
					LEFT JOIN ${db.contabilidade.schema}.PAGAMENTO P
                      ON P.ENTIDADE          = OP.ENTIDADE
                     AND P.ANOORDEMPAGAMENTO = OP.EXERCICIO
                     AND P.NOORDEMPAGAMENTO  = OP.NOORDEM
                   WHERE OP.ENTIDADE     = :entidade
                     AND OP.ANODOCORIGEM = :exercicio
					 AND OP.NODOCORIGEM  = :empenho
					 AND P.DATA         <= A.DATAESTCONTABILIZADO),0)) AS VALORPAGAMENTO,
	   (COALESCE((SELECT SUM(ESTPAG.VALOR)
                    FROM ${db.contabilidade.schema}.ESTORNOPAGAMENTO ESTPAG
					LEFT JOIN ${db.contabilidade.schema}.PAGAMENTO P
                      ON P.ENTIDADE    = ESTPAG.ENTIDADE
                     AND P.EXERCICIO   = ESTPAG.EXERCICIO
                     AND P.NOPAGAMENTO = ESTPAG.NOPAGAMENTO
					LEFT JOIN ${db.contabilidade.schema}.ORDEMPAGAMENTO_LIQUIDACAO OP
                      ON OP.ENTIDADE  = P.ENTIDADE
                     AND OP.EXERCICIO = P.ANOORDEMPAGAMENTO
                     AND OP.NOORDEM   = P.NOORDEMPAGAMENTO
                   WHERE OP.ENTIDADE     = :entidade
                     AND OP.ANODOCORIGEM = :exercicio
					 AND OP.NODOCORIGEM  = :empenho
					 AND ESTPAG.DATA    <= A.DATAESTCONTABILIZADO),0)) AS VALORESTPAGAMENTO,
	   (COALESCE((SELECT SUM(RET.VALOR)
                    FROM ${db.contabilidade.schema}.RETENCOESLIQUIDACAO RET
                   WHERE RET.ENTIDADE           = :entidade
                     AND RET.ANODOCORIGEM       = :exercicio
					 AND RET.NODOCORIGEM        = :empenho
					 AND RET.DATACONTABILIZADO <= A.DATAESTCONTABILIZADO),0)) AS VALORRETENCAO,
	   (COALESCE((SELECT SUM(RET.VALOR)
                    FROM ${db.contabilidade.schema}.RETENCOESLIQUIDACAO RET
                   WHERE RET.ENTIDADE              = :entidade
                     AND RET.ANODOCORIGEM          = :exercicio
					 AND RET.NODOCORIGEM           = :empenho
					 AND RET.DATAESTCONTABILIZADO <= A.DATAESTCONTABILIZADO
					 AND RET.NOLIQUIDACAO         <= A.NOLIQUIDACAO 
					 AND RET.DATAESTCONTABILIZADO IS NOT NULL),0)) AS VALORESTRETENCAO
 FROM ${db.contabilidade.schema}.RETENCOESLIQUIDACAO A
 LEFT OUTER JOIN ${db.contabilidade.schema}.EMPENHO E
   ON A.ENTIDADE = E.ENTIDADE
  AND A.ANODOCORIGEM = E.EXERCICIO
  AND A.NODOCORIGEM = E.EMPENHO
  AND A.UNIDADEDOCORIGEM = E.UNIDADEORCAMENTARIA 
WHERE E.ENTIDADE = :entidade
AND E.EXERCICIO = :exercicio
AND E.EMPENHO = :empenho
AND A.DATAESTCONTABILIZADO IS NOT NULL
GROUP BY A.EXERCICIO, A.NOLIQUIDACAO, A.DATAESTCONTABILIZADO, E.VALOR
UNION ALL
SELECT 33 AS TIPOLANCAMENTO,
       'Em Liquidação' AS DESCRICAOTIPOLANCAMENTO,
       EML.EXERCICIO AS EXERCICIOLIQUIDACAO,
       EML.NOEMLIQUIDACAO,
       0 AS EXERCICIOPAGAMENTO,
       0 AS NOPAGAMENTO,
       EML.DATA AS DATA,
       SUM(EML.VALOR) AS VALOR,
       CAST('Em Liq. '||EML.NOEMLIQUIDACAO||'/'||EML.EXERCICIO AS VARCHAR(100)) AS NRODOCUMENTO,
       E.VALOR AS VALOREMPENHO,
       (COALESCE((SELECT SUM(AE.VALOR)
                    FROM ${db.contabilidade.schema}.ANULACAOEMPENHO AE
                   WHERE AE.ENTIDADE  = :entidade
                     AND AE.EXERCICIO = :exercicio
                     AND AE.EMPENHO   = :empenho
                     AND AE.DATA     <= EML.DATA),0) +
		COALESCE((SELECT SUM(C.VALOR)
                    FROM ${db.contabilidade.schema}.CANCELAMENTORESTOS C
                   WHERE C.ENTIDADE  = :entidade
                     AND C.EXERCICIO = :exercicio
                     AND C.EMPENHO   = :empenho
                     AND C.DATA     <= EML.DATA),0)) AS VALORANULACAO,
	   (COALESCE((SELECT SUM(AE.VALOR)
                    FROM ${db.contabilidade.schema}.ANULACAOEMPENHO AE
                   WHERE AE.ENTIDADE     = :entidade
                     AND AE.EXERCICIO    = :exercicio
                     AND AE.EMPENHO      = :empenho
	                 AND AE.DATAESTORNO <= EML.DATA
					 AND AE.DATAESTORNO IS NOT NULL),0) +
		COALESCE((SELECT SUM(C.VALOR)
                    FROM ${db.contabilidade.schema}.CANCELAMENTORESTOS C
                   WHERE C.ENTIDADE           = :entidade
                     AND C.EXERCICIO          = :exercicio
                     AND C.EMPENHO            = :empenho
	                 AND C.DATA              <= EML.DATA
					 AND C.FLAGESTORNO        = 'S'),0)) AS VALORESTANULACAO,	  
	   (COALESCE((SELECT SUM(LIQ.VALOR)
                    FROM ${db.contabilidade.schema}.LIQUIDACAO LIQ
                   WHERE LIQ.ENTIDADE      = :entidade
                     AND LIQ.ANODOCORIGEM  = :exercicio
					 AND LIQ.NODOCORIGEM   = :empenho
					 AND LIQ.DATA         <= EML.DATA),0)) AS VALORLIQUIDACAO,
	   (COALESCE((SELECT SUM(ESTLIQ.VALOR)
                    FROM ${db.contabilidade.schema}.ESTORNOLIQUIDACAO ESTLIQ
                   WHERE ESTLIQ.ENTIDADE     = :entidade
                     AND ESTLIQ.ANODOCORIGEM = :exercicio
					 AND ESTLIQ.NODOCORIGEM  = :empenho
					 AND ESTLIQ.DATA        <= EML.DATA),0)) AS VALORESTLIQUIDACAO,
	   (COALESCE((SELECT SUM(OP.VALOR)
                    FROM ${db.contabilidade.schema}.ORDEMPAGAMENTO_LIQUIDACAO OP
					LEFT JOIN ${db.contabilidade.schema}.PAGAMENTO P
                      ON P.ENTIDADE          = OP.ENTIDADE
                     AND P.ANOORDEMPAGAMENTO = OP.EXERCICIO
                     AND P.NOORDEMPAGAMENTO  = OP.NOORDEM
                   WHERE OP.ENTIDADE     = :entidade
                     AND OP.ANODOCORIGEM = :exercicio
					 AND OP.NODOCORIGEM  = :empenho
					 AND P.DATA          < EML.DATA),0)) AS VALORPAGAMENTO,
	   (COALESCE((SELECT SUM(ESTPAG.VALOR)
                    FROM ${db.contabilidade.schema}.ESTORNOPAGAMENTO ESTPAG
					LEFT JOIN ${db.contabilidade.schema}.PAGAMENTO P
                      ON P.ENTIDADE    = ESTPAG.ENTIDADE
                     AND P.EXERCICIO   = ESTPAG.EXERCICIO
                     AND P.NOPAGAMENTO = ESTPAG.NOPAGAMENTO
					LEFT JOIN ${db.contabilidade.schema}.ORDEMPAGAMENTO_LIQUIDACAO OP
                      ON OP.ENTIDADE  = P.ENTIDADE
                     AND OP.EXERCICIO = P.ANOORDEMPAGAMENTO
                     AND OP.NOORDEM   = P.NOORDEMPAGAMENTO
                   WHERE OP.ENTIDADE     = :entidade
                     AND OP.ANODOCORIGEM = :exercicio
					 AND OP.NODOCORIGEM  = :empenho
					 AND ESTPAG.DATA     < EML.DATA),0)) AS VALORESTPAGAMENTO,
	   (COALESCE((SELECT SUM(RET.VALOR)
                    FROM ${db.contabilidade.schema}.RETENCOESLIQUIDACAO RET
                   WHERE RET.ENTIDADE          = :entidade
                     AND RET.ANODOCORIGEM      = :exercicio
					 AND RET.NODOCORIGEM       = :empenho
					 AND RET.DATACONTABILIZADO < EML.DATA),0)) AS VALORRETENCAO,
	   (COALESCE((SELECT SUM(RET.VALOR)
                    FROM ${db.contabilidade.schema}.RETENCOESLIQUIDACAO RET
                   WHERE RET.ENTIDADE             = :entidade
                     AND RET.ANODOCORIGEM         = :exercicio
					 AND RET.NODOCORIGEM          = :empenho
					 AND RET.DATAESTCONTABILIZADO < EML.DATA
					 AND RET.DATAESTCONTABILIZADO IS NOT NULL),0)) AS VALORESTRETENCAO
 FROM ${db.contabilidade.schema}.EMLIQUIDACAO EML
 LEFT OUTER JOIN ${db.contabilidade.schema}.EMPENHO E
   ON E.ENTIDADE  = EML.ENTIDADE
  AND E.EXERCICIO = EML.ANODOCORIGEM
  AND E.EMPENHO   = EML.NODOCORIGEM
WHERE EML.ENTIDADE   = :entidade
AND EML.ANODOCORIGEM = :exercicio
AND EML.NODOCORIGEM  = :empenho
GROUP BY EML.EXERCICIO, EML.NOEMLIQUIDACAO, EML.DATA, E.VALOR
) X
ORDER BY X.DATA, X.TIPOLANCAMENTO, X.NRODOCUMENTO