SELECT E.ENTIDADE,
       E.EXERCICIO,
       E.EMPENHO,
       E.UNIDADEORCAMENTARIA,
       A.EXERCICIO AS EXERCICIOLIQUIDACAO,
       A.NOLIQUIDACAO,
       A.SEQUENCIA, 
       B.DESCRICAO,
       A.NODOCUMENTO, 
       A.DATA, 
       A.VALOR,
       A.CHAVEACESSO,
	   A.TIPODOCUMENTO,
       (SELECT COUNT(*) 
          FROM ${db.contabilidade.schema}.LIQUIDACAODOCUMENTOSPDF PDF
         WHERE A.ENTIDADE = PDF.ENTIDADE
           AND A.EXERCICIO = PDF.EXERCICIO
           AND A.EXERCICIOEMPENHO = PDF.EXERCICIOEMPENHO
           AND A.EMPENHO = PDF.EMPENHO
           AND A.UNIDADEORCAMENTARIA = PDF.UNIDADEORCAMENTARIA
           AND A.NOLIQUIDACAO = PDF.NOLIQUIDACAO
           AND A.SEQUENCIA = PDF.SEQUENCIA) AS TOTALARQUIVO,
	   (SELECT COALESCE(VALORESTLIQUIDACAO,0)
		FROM ${db.contabilidade.schema}.LIQUIDACAO
		WHERE  ENTIDADE         = A.ENTIDADE 
		AND    EXERCICIO 			  = A.EXERCICIO
		AND    NODOCORIGEM		  = A.EMPENHO
		AND    ANODOCORIGEM 	  = A.EXERCICIOEMPENHO
		AND    UNIDADEDOCORIGEM = A.UNIDADEORCAMENTARIA
		AND    NOLIQUIDACAO 	  = A.NOLIQUIDACAO) AS valorEstornado
  FROM ${db.contabilidade.schema}.LIQUIDACAODOCUMENTOS A
  LEFT OUTER JOIN ${db.contabilidade.schema}.TIPODOCFISCAL B
    ON A.ENTIDADE = B.ENTIDADE
   AND A.EXERCICIO = B.EXERCICIO
   AND A.TIPODOCUMENTO = B.TIPO 
  LEFT OUTER JOIN ${db.contabilidade.schema}.EMPENHO E
    ON A.ENTIDADE = E.ENTIDADE
   AND A.EXERCICIOEMPENHO = E.EXERCICIO
   AND A.EMPENHO = E.EMPENHO
   AND A.UNIDADEORCAMENTARIA = E.UNIDADEORCAMENTARIA  
  
 