/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.protocportal.service.impl;

import br.com.elotech.core.common.dto.MailResultInfo;
import br.com.elotech.core.utils.EloPage;
import br.com.elotech.portaltransparencia.protocportal.domain.Escolaridade;
import br.com.elotech.portaltransparencia.protocportal.dto.SituacaoDTO;
import br.com.elotech.portaltransparencia.protocportal.params.ConsultaProcessoParams;
import br.com.elotech.portaltransparencia.protocportal.params.SalvaProcessoParams;
import br.com.elotech.portaltransparencia.protocportal.service.ProcessoService;
import br.com.elotech.protocolo.client.feign.AssuntoClientFeign;
import br.com.elotech.protocolo.client.feign.EscolaridadeClientFeign;
import br.com.elotech.protocolo.client.feign.ProcessoClientFeign;
import br.com.elotech.protocolo.client.feign.ProcessoExternoClientFeign;
import br.com.elotech.protocolo.client.feign.ProtocoloPessoaClientFeign;
import br.com.elotech.protocolo.client.feign.SituacaoClientFeign;
import br.com.elotech.protocolo.dto.AssuntoDTO;
import br.com.elotech.protocolo.dto.EntidadeDTO;
import br.com.elotech.protocolo.dto.EscolaridadeDTO;
import br.com.elotech.protocolo.dto.PessoaDTO;
import br.com.elotech.protocolo.dto.PessoaSexo;
import br.com.elotech.protocolo.dto.ProcessoDTO;
import br.com.elotech.protocolo.dto.TipoProcessoDTO;
import br.com.elotech.protocolo.dto.TipoProcessoSimpleDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service
public class ProcessoServiceOxy
implements ProcessoService {
    public static final String OBSERVACAO_PADRAO = "Aberto pelo Portal da Transpar\u00eancia (e-SIC)";
    public static final String USUARIO_REGISTRO = "e-SIC";
    @Autowired
    private ProcessoExternoClientFeign processoExternoClientFeign;
    @Autowired
    private EscolaridadeClientFeign escolaridadeClientFeign;
    @Autowired
    private ProtocoloPessoaClientFeign protocoloPessoaClientFeign;
    @Autowired
    private AssuntoClientFeign assuntoClientFeign;
    @Autowired
    private SituacaoClientFeign situacaoClientFeign;
    @Autowired
    private ProcessoClientFeign processoClientFeign;

    public br.com.elotech.portaltransparencia.protocportal.dto.ProcessoDTO salvaProcesso(SalvaProcessoParams params) {
        ProcessoDTO processoOxy = this.buildProcessoOxy(params);
        if (processoOxy == null) {
            return null;
        }
        processoOxy = this.processoExternoClientFeign.saveByEntidade(params.getEntidade(), processoOxy);
        return br.com.elotech.portaltransparencia.protocportal.dto.ProcessoDTO.fromOxyProcesso((ProcessoDTO)processoOxy);
    }

    private ProcessoDTO buildProcessoOxy(SalvaProcessoParams params) {
        if (params == null) {
            return null;
        }
        ProcessoDTO processoOxy = new ProcessoDTO();
        processoOxy.setEntidade(EntidadeDTO.of((Long)Optional.ofNullable(params.getEntidadeProtocolo()).orElse(params.getEntidade())));
        processoOxy.setUsuarioRegistro(USUARIO_REGISTRO);
        processoOxy.setOuvidoria(Boolean.FALSE);
        processoOxy.setOuvidoriaAnonima(Boolean.valueOf(params.getPessoa() == null));
        TipoProcessoDTO tipoProcessoDTO = (TipoProcessoDTO)this.processoExternoClientFeign.getTipoProcessoExternoPadrao().getBody();
        if (Objects.nonNull(tipoProcessoDTO) && Objects.nonNull(tipoProcessoDTO.getId())) {
            processoOxy.setTipo(TipoProcessoSimpleDTO.of((Long)tipoProcessoDTO.getId()));
        }
        if (params.getPessoa() == null) {
            processoOxy.setPessoa(new PessoaDTO());
        } else {
            if (params.getPessoa().getCnpjCpf() != null) {
                processoOxy.setPessoa(this.protocoloPessoaClientFeign.consultaPessoaByCpfCnpj(params.getPessoa().getCnpjCpf()));
            }
            if (processoOxy.getPessoa() == null) {
                processoOxy.setPessoa(new PessoaDTO());
                processoOxy.getPessoa().setId(params.getPessoa().getId());
            }
            if (params.getDataNascimento() != null) {
                processoOxy.getPessoa().setDataNascimento(params.getDataNascimento());
            }
            processoOxy.setEmail(params.getPessoa().fetchEmail());
            processoOxy.setCelular(params.getPessoa().fetchCelular());
            processoOxy.getPessoa().setCnpjCpf(params.getPessoa().getCnpjCpf());
            processoOxy.getPessoa().setRg(params.getPessoa().getRg());
            processoOxy.getPessoa().setTelefone(params.getPessoa().fetchTelefone());
            processoOxy.getPessoa().setCelular(params.getPessoa().fetchCelular());
            processoOxy.getPessoa().setEmail(params.getPessoa().fetchEmail());
            processoOxy.getPessoa().setNome(params.getPessoa().getNome());
        }
        if (params.getEndereco() != null) {
            processoOxy.setEndereco(String.format("%s, %s - %s - %s - %s/%s", params.getEndereco().getEndereco(), params.getEndereco().getNumero(), params.getEndereco().getCep(), params.getEndereco().getBairroAux(), params.getEndereco().getCidadeAux(), params.getEndereco().getUfId()));
            processoOxy.setCep(params.getEndereco().getCep());
            processoOxy.setComplemento(params.getEndereco().getComplemento());
            processoOxy.setNumeroEndereco(params.getEndereco().getNumero());
            processoOxy.setUf(params.getEndereco().getUfId());
            processoOxy.setBairroAux(params.getEndereco().getBairroAux());
            processoOxy.setCidadeAux(params.getEndereco().getCidadeAux());
        }
        processoOxy.setObservacao(OBSERVACAO_PADRAO);
        processoOxy.setAssunto(AssuntoDTO.of((Long)params.getAssuntoOxy()));
        processoOxy.setComplementoAssunto(params.getAssunto());
        processoOxy.setDigitacao(params.getDigitacao());
        processoOxy.setAno(params.getExercicio());
        processoOxy.setProcessoReferencia(params.getProcessoReferencia());
        if (params.getEscolaridade() != null) {
            processoOxy.setEscolaridade(new EscolaridadeDTO());
            processoOxy.getEscolaridade().setId(params.getEscolaridade());
        }
        if (params.getSexo() != null) {
            processoOxy.setSexo(PessoaSexo.fromValue((String)params.getSexo()));
        }
        return processoOxy;
    }

    public Future<MailResultInfo> enviaeSicEmail(br.com.elotech.portaltransparencia.protocportal.dto.ProcessoDTO processo) {
        return null;
    }

    public Future<MailResultInfo> enviaContatoEmail(br.com.elotech.portaltransparencia.protocportal.dto.ProcessoDTO processo) {
        return null;
    }

    public List<Escolaridade> loadEscolaridades() {
        return Optional.ofNullable(this.escolaridadeClientFeign.findAll((Pageable)PageRequest.of((int)0, (int)50))).orElse(new EloPage(new ArrayList())).getContent().stream().map(Escolaridade::fromOxy).collect(Collectors.toList());
    }

    public List<AssuntoDTO> loadAssuntos(Long entidade, String search) {
        String query = "esic==true and ativo==true";
        if (StringUtils.isNotBlank((CharSequence)search)) {
            query = String.format("%s and %s", query, search);
        }
        return this.assuntoClientFeign.findAllByEntidade(query, entidade, (Pageable)PageRequest.of((int)0, (int)30));
    }

    public List<SituacaoDTO> loadSituacoes(Long entidade, Long exercicio) {
        return Optional.ofNullable(this.situacaoClientFeign.findAll("ativa==true", (Pageable)PageRequest.of((int)0, (int)50, (Sort)Sort.by((String[])new String[]{"descricao"})))).orElse(new EloPage(new ArrayList())).getContent().stream().map(SituacaoDTO::fromOxySituacao).collect(Collectors.toList());
    }

    public Page<br.com.elotech.portaltransparencia.protocportal.dto.ProcessoDTO> findAll(ConsultaProcessoParams params, Pageable pageable) {
        EloPage processos = this.processoClientFeign.findAllPortal(params.getRSqlWhereToOxy(), pageable);
        List processosMap = processos.getContent().stream().map(br.com.elotech.portaltransparencia.protocportal.dto.ProcessoDTO::fromOxyProcesso).collect(Collectors.toList());
        return new PageImpl(processosMap, pageable, processos.getTotalElements());
    }

    @Generated
    public ProcessoServiceOxy(ProcessoExternoClientFeign processoExternoClientFeign, EscolaridadeClientFeign escolaridadeClientFeign, ProtocoloPessoaClientFeign protocoloPessoaClientFeign, AssuntoClientFeign assuntoClientFeign, SituacaoClientFeign situacaoClientFeign, ProcessoClientFeign processoClientFeign) {
        this.processoExternoClientFeign = processoExternoClientFeign;
        this.escolaridadeClientFeign = escolaridadeClientFeign;
        this.protocoloPessoaClientFeign = protocoloPessoaClientFeign;
        this.assuntoClientFeign = assuntoClientFeign;
        this.situacaoClientFeign = situacaoClientFeign;
        this.processoClientFeign = processoClientFeign;
    }
}

