/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.folhaportal.service;

import br.com.elotech.core.utils.EloPage;
import br.com.elotech.folhapagamento.client.IntegracaoFolhaPortalTransparenciaClient;
import br.com.elotech.folhapagamento.client.domain.PortalTransparenciaDadosServidorDTO;
import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.service.PortalParametroService;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.EstagiarioDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter.EstagiarioDTOConverter;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter.ServidorParamsConverter;
import br.com.elotech.portaltransparencia.aiseportal.service.EstagiarioService;
import br.com.elotech.portaltransparencia.contabportal.domain.PortalParametroContabil;
import br.com.elotech.portaltransparencia.folhaportal.service.ServidorServiceOxy;
import br.com.elotech.portaltransparencia.web.rest.params.ServidorParams;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.unico.client.EntidadeFeignClient;
import br.com.elotech.unico.client.domain.EntidadeDTO;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class EstagiarioServiceOxy
implements EstagiarioService {
    private final IntegracaoFolhaPortalTransparenciaClient integracaoFolhaPortalTransparenciaClient;
    private final EntidadeFeignClient entidadeClient;
    private final BaseExport baseExport;
    private final PortalParametroService portalParametroService;
    private final ServidorServiceOxy servidorServiceOxy;
    private static final String headerFields = "Nome,Matr\u00edcula,Situa\u00e7\u00e3o,Cargo,Lota\u00e7\u00e3o,In\u00edcio de Contrato,T\u00e9rmino de Contrato";
    private static final String fields = "nome,matricula,situacao,descricaoCargo,descricaoLotacao,dataAdmissao,dataFimContrato";

    public Page<EstagiarioDTO> loadEstagiarios(ServidorParams params, Pageable pageable) {
        if (this.utilizaWebService(params.getExercicio(), params.getEntidade())) {
            return this.servidorServiceOxy.getEstagiariosByWebService(params, pageable);
        }
        EloPage estagiarios = this.integracaoFolhaPortalTransparenciaClient.getEstagiarios(ServidorParamsConverter.toDTO((ServidorParams)params), pageable);
        return new PageImpl(estagiarios.getContent().stream().map(EstagiarioDTOConverter::portalTransparenciaServidoresDTOToEstagiarioDTO).collect(Collectors.toList()), pageable, estagiarios.getTotalElements());
    }

    public Optional<EstagiarioDTO> loadEstagiario(ServidorParams params) {
        if (this.utilizaWebService(params.getExercicio(), params.getEntidade())) {
            return this.servidorServiceOxy.loadServidor(params).map(EstagiarioDTOConverter::ServidorDTOToEstagiarioDTO);
        }
        Long entidade = (Long)ObjectUtils.defaultIfNull((Object)params.getEntidadeAise(), (Object)params.getEntidade());
        return Optional.of(EstagiarioDTOConverter.portalTransparenciaDadosServidorDTOToEstagiarioDTO((PortalTransparenciaDadosServidorDTO)this.integracaoFolhaPortalTransparenciaClient.getDadosEstagiario(entidade, params.getExercicio(), params.getMatricula())));
    }

    public String findNomeEntidadeById(Long entidadeId) {
        EntidadeDTO entidadeDTO = this.entidadeClient.findOne(entidadeId);
        return Objects.nonNull(entidadeDTO) ? entidadeDTO.getNome() : "";
    }

    public String headerFields() {
        return headerFields;
    }

    public String fields() {
        return fields;
    }

    public float[] fieldsPerc() {
        return new float[]{1.5f, 0.8f, 1.0f, 1.5f, 1.5f, 0.8f, 0.8f};
    }

    public int[] fieldTab() {
        return new int[]{100, 50, 20, 100, 100, 50, 50};
    }

    private boolean utilizaWebService(Long exercicio, Long entidade) {
        PortalParametroContabil parametro = this.portalParametroService.getPortalParametro(entidade, exercicio, Parametros.PARAM_WEBSERVICE_MARINGA);
        return Objects.nonNull(parametro) && "1".equals(parametro.getValor());
    }

    @Generated
    public EstagiarioServiceOxy(IntegracaoFolhaPortalTransparenciaClient integracaoFolhaPortalTransparenciaClient, EntidadeFeignClient entidadeClient, BaseExport baseExport, PortalParametroService portalParametroService, ServidorServiceOxy servidorServiceOxy) {
        this.integracaoFolhaPortalTransparenciaClient = integracaoFolhaPortalTransparenciaClient;
        this.entidadeClient = entidadeClient;
        this.baseExport = baseExport;
        this.portalParametroService = portalParametroService;
        this.servidorServiceOxy = servidorServiceOxy;
    }

    @Generated
    public BaseExport getBaseExport() {
        return this.baseExport;
    }
}

