/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service.impl;

import br.com.elotech.core.service.support.ReadOnlyService;
import br.com.elotech.portaltransparencia.admportal.repository.AcordoSemRecursoRepository;
import br.com.elotech.portaltransparencia.contabportal.domain.AcordoSemRecurso;
import br.com.elotech.portaltransparencia.contabportal.domain.Fornecedor;
import br.com.elotech.portaltransparencia.contabportal.resource.params.AcordoSemRecursoParams;
import br.com.elotech.portaltransparencia.contabportal.service.AcordoSemRecursoService;
import br.com.elotech.portaltransparencia.contabportal.service.FornecedorService;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class AcordoSemRecursoServiceOxyImpl
extends ReadOnlyService<AcordoSemRecurso, Long>
implements AcordoSemRecursoService {
    private final FornecedorService fornecedorService;
    private final AcordoSemRecursoRepository repository;

    public Page<AcordoSemRecurso> findByParams(AcordoSemRecursoParams params, Pageable pageable) {
        List<AcordoSemRecurso> acordos = this.repository.findAll(this.createSpecification(Optional.empty(), this.createRsql(params)), pageable).stream().toList();
        if (!acordos.isEmpty()) {
            Map credorById = this.fornecedorService.findAllById(acordos.stream().map(AcordoSemRecurso::getFornecedor).collect(Collectors.toSet())).stream().collect(Collectors.toMap(Fornecedor::getId, Function.identity()));
            acordos.forEach(a -> a.setNomeFornecedor(((Fornecedor)credorById.get(a.getFornecedor())).getNome()));
            if (params.getNomeFornecedor().isPresent()) {
                List<AcordoSemRecurso> acordosCredorFiltered = acordos.stream().filter(a -> a.getNomeFornecedor().toLowerCase().contains(((String)params.getNomeFornecedor().get()).toLowerCase())).toList();
                return new PageImpl(acordosCredorFiltered, pageable, (long)acordosCredorFiltered.size());
            }
        }
        return new PageImpl(acordos, pageable, (long)acordos.size());
    }

    private String createRsql(AcordoSemRecursoParams params) {
        StringBuilder filter = new StringBuilder();
        this.attrParameterIfExists(filter, "entidade==", (Long)params.getEntidade().orElse(null));
        this.attrParameterIfExists(filter, " and numero==", (Long)params.getNumero().orElse(null));
        this.attrParameterIfExists(filter, " and exercicio==", (Long)params.getExercicio().orElse(null));
        this.attrParameterIfExists(filter, " and ano==", (Long)params.getAno().orElse(null));
        this.attrParameterIfExists(filter, " and tipo==", (String)params.getTipo().orElse(null));
        this.attrParameterIfExists(filter, " and situacao==", (String)params.getSituacao().orElse(null));
        this.attrParameterIfExists(filter, " and dataInicio>=", (LocalDate)params.getDataInicio().orElse(null));
        this.attrParameterIfExists(filter, " and dataTermino<=", (LocalDate)params.getDataTermino().orElse(null));
        this.attrParameterIfExists(filter, " and objeto==", (String)params.getObjeto().orElse(null));
        return filter.toString();
    }

    public void attrParameterIfExists(StringBuilder filter, String name, String value) {
        Optional.ofNullable(value).ifPresent(o -> filter.append(name).append(String.format("'*%s*'", o)));
    }

    public void attrParameterIfExists(StringBuilder filter, String name, Long value) {
        Optional.ofNullable(value).ifPresent(o -> filter.append(name).append(o));
    }

    public void attrParameterIfExists(StringBuilder filter, String name, LocalDate value) {
        Optional.ofNullable(value).ifPresent(o -> filter.append(name).append(o));
    }

    public AcordoSemRecurso getById(Long id) {
        AcordoSemRecurso acordo = (AcordoSemRecurso)this.repository.findOne((Object)id);
        acordo.setNomeFornecedor(this.fornecedorService.findById(acordo.getFornecedor()).getNome());
        return acordo;
    }

    @Generated
    public AcordoSemRecursoServiceOxyImpl(FornecedorService fornecedorService, AcordoSemRecursoRepository repository) {
        this.fornecedorService = fornecedorService;
        this.repository = repository;
    }
}

