/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.core.config.DBConfigProperties;
import br.com.elotech.portaltransparencia.config.AuthenticationClientUnico;
import br.com.elotech.portaltransparencia.config.PessoaClientUnico;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class IntegradoComUnicoService {
    private final DBConfigProperties dbConfigProperties;
    private final AuthenticationClientUnico authClient;
    public static final String JOB_UNIFICACAO_COMPLETA = "Unifica\u00e7\u00e3o";
    private static final Duration TIMEOUT = Duration.ofSeconds(10L);
    private static final Logger LOGGER = LoggerFactory.getLogger(PessoaClientUnico.class);
    private final String eurekaHost;

    @Autowired
    public IntegradoComUnicoService(DBConfigProperties dbConfigProperties, AuthenticationClientUnico authClient, @Value(value="${eureka-host:}") String eurekaHost) {
        this.dbConfigProperties = dbConfigProperties;
        this.authClient = authClient;
        this.eurekaHost = eurekaHost;
    }

    public boolean isIntegradoComUnico() {
        return this.dbConfigProperties.getUnico().getHost() != null && this.dbConfigProperties.getUnico().getUser() != null && !this.dbConfigProperties.getUnico().getHost().isEmpty() && !this.dbConfigProperties.getUnico().getUser().isEmpty();
    }

    public boolean isIntegradoComUnicoCompleto() {
        try {
            if (this.isIntegradoComUnico()) {
                String token = this.authClient.authenticateAndReturnToken();
                HttpResponse<String> response = HttpClient.newBuilder().build().send(HttpRequest.newBuilder().uri(URI.create(this.eurekaHost + "/unico-api/rest/jobs/" + this.encodeUrl(JOB_UNIFICACAO_COMPLETA) + "/status")).header("Content-Type", "application/json").header("Authorization", token).timeout(TIMEOUT).GET().build(), HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() == HttpStatus.OK.value()) {
                    return response.body().contains("COMPLETED");
                }
            }
            return false;
        }
        catch (IOException | InterruptedException e) {
            LOGGER.error("Erro inesperado ao consultar status do \u00fanico. [{}]", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    private String encodeUrl(String str) {
        return URLEncoder.encode(str, StandardCharsets.UTF_8);
    }
}

