/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource.params;

import br.com.elotech.portaltransparencia.contabportal.resource.params.DespesaParams;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class DespesaParams {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private Long entidade;
    private Long exercicio;
    private Long nivel;
    private Long nivelPrograma;
    private String exportType;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    private LocalDate dataInicial;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    private LocalDate dataFinal;

    public Optional<LocalDate> getDataInicial() {
        return Optional.ofNullable(this.dataInicial);
    }

    public Optional<LocalDate> getDataFinal() {
        return Optional.ofNullable(this.dataFinal);
    }

    public MapSqlParameterSource toJdbcParameter() {
        MapSqlParameterSource params = new MapSqlParameterSource();
        this.addDataInicial(params);
        this.addDataFinal(params);
        return params;
    }

    private void addDataInicial(MapSqlParameterSource params) {
        if (Objects.nonNull(this.dataInicial)) {
            params.addValue("dataInicial", (Object)this.dataInicial.format(DATE_FORMAT), 91);
        }
    }

    private void addDataFinal(MapSqlParameterSource params) {
        if (Objects.nonNull(this.dataFinal)) {
            params.addValue("dataFinal", (Object)this.dataFinal.format(DATE_FORMAT), 91);
        }
    }

    @Generated
    public static DespesaParamsBuilder builder() {
        return new DespesaParamsBuilder();
    }

    @Generated
    public String toString() {
        return "DespesaParams(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", nivel=" + this.getNivel() + ", nivelPrograma=" + this.getNivelPrograma() + ", exportType=" + this.getExportType() + ", dataInicial=" + String.valueOf(this.getDataInicial()) + ", dataFinal=" + String.valueOf(this.getDataFinal()) + ")";
    }

    @Generated
    public DespesaParams() {
    }

    @Generated
    public DespesaParams(Long entidade, Long exercicio, Long nivel, Long nivelPrograma, String exportType, LocalDate dataInicial, LocalDate dataFinal) {
        this.entidade = entidade;
        this.exercicio = exercicio;
        this.nivel = nivel;
        this.nivelPrograma = nivelPrograma;
        this.exportType = exportType;
        this.dataInicial = dataInicial;
        this.dataFinal = dataFinal;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getNivel() {
        return this.nivel;
    }

    @Generated
    public Long getNivelPrograma() {
        return this.nivelPrograma;
    }

    @Generated
    public String getExportType() {
        return this.exportType;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setNivel(Long nivel) {
        this.nivel = nivel;
    }

    @Generated
    public void setNivelPrograma(Long nivelPrograma) {
        this.nivelPrograma = nivelPrograma;
    }

    @Generated
    public void setExportType(String exportType) {
        this.exportType = exportType;
    }

    @Generated
    public void setDataInicial(LocalDate dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Generated
    public void setDataFinal(LocalDate dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DespesaParams)) {
            return false;
        }
        DespesaParams other = (DespesaParams)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$nivel = this.getNivel();
        Long other$nivel = other.getNivel();
        if (this$nivel == null ? other$nivel != null : !((Object)this$nivel).equals(other$nivel)) {
            return false;
        }
        Long this$nivelPrograma = this.getNivelPrograma();
        Long other$nivelPrograma = other.getNivelPrograma();
        if (this$nivelPrograma == null ? other$nivelPrograma != null : !((Object)this$nivelPrograma).equals(other$nivelPrograma)) {
            return false;
        }
        String this$exportType = this.getExportType();
        String other$exportType = other.getExportType();
        if (this$exportType == null ? other$exportType != null : !this$exportType.equals(other$exportType)) {
            return false;
        }
        Optional this$dataInicial = this.getDataInicial();
        Optional other$dataInicial = other.getDataInicial();
        if (this$dataInicial == null ? other$dataInicial != null : !((Object)this$dataInicial).equals(other$dataInicial)) {
            return false;
        }
        Optional this$dataFinal = this.getDataFinal();
        Optional other$dataFinal = other.getDataFinal();
        return !(this$dataFinal == null ? other$dataFinal != null : !((Object)this$dataFinal).equals(other$dataFinal));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DespesaParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $nivel = this.getNivel();
        result = result * 59 + ($nivel == null ? 43 : ((Object)$nivel).hashCode());
        Long $nivelPrograma = this.getNivelPrograma();
        result = result * 59 + ($nivelPrograma == null ? 43 : ((Object)$nivelPrograma).hashCode());
        String $exportType = this.getExportType();
        result = result * 59 + ($exportType == null ? 43 : $exportType.hashCode());
        Optional $dataInicial = this.getDataInicial();
        result = result * 59 + ($dataInicial == null ? 43 : ((Object)$dataInicial).hashCode());
        Optional $dataFinal = this.getDataFinal();
        result = result * 59 + ($dataFinal == null ? 43 : ((Object)$dataFinal).hashCode());
        return result;
    }
}

