/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.dto.EnumCodigoDescricaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ArquivoPessoalDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.DiariaMovimentacaoPassagensDTO;
import br.com.elotech.portaltransparencia.contabportal.resource.params.FindPessoalParams;
import br.com.elotech.portaltransparencia.contabportal.service.PassagemService;
import java.util.List;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/passagens"})
public class PassagemResource {
    private final PassagemService passagemService;

    @GetMapping
    public ResponseEntity<Page<DiariaMovimentacaoPassagensDTO>> findPassagens(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, FindPessoalParams params, Pageable pageable) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.passagemService.findPassagens(params, pageable));
    }

    @GetMapping(value={"/tipos-passagem"})
    public ResponseEntity<List<EnumCodigoDescricaoDTO<Long>>> getTiposPassagem() {
        return ResponseEntity.ok((Object)this.passagemService.getTiposPassagem());
    }

    @GetMapping(value={"/detail"})
    public ResponseEntity<DiariaMovimentacaoPassagensDTO> findPassagem(FindPessoalParams filter) {
        return ResponseEntity.ok((Object)((DiariaMovimentacaoPassagensDTO)this.passagemService.findPassagem(filter).orElseThrow(RestException::notFound)));
    }

    @GetMapping(value={"/arquivos"})
    public ResponseEntity<List<ArquivoPessoalDTO>> findArquivos(FindPessoalParams findPessoalParams) {
        return ResponseEntity.ok((Object)this.passagemService.findArquivos(findPessoalParams));
    }

    @Generated
    public PassagemResource(PassagemService passagemService) {
        this.passagemService = passagemService;
    }
}

