/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository.impl;

import br.com.elotech.contabilidade.client.LiquidacaoFeignClient;
import br.com.elotech.contabilidade.client.PagamentoFeignClient;
import br.com.elotech.contabilidade.client.dto.LiquidacaoSaldoValoresDTO;
import br.com.elotech.contabilidade.client.dto.PagamentoDTO;
import br.com.elotech.contabilidade.client.enums.SituacaoEventoLancamento;
import br.com.elotech.contabilidade.client.params.LiquidacaoParamsDTO;
import br.com.elotech.contabilidade.client.params.PagamentoParamsDTO;
import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.core.utils.EloPage;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ContaPagamentoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.LiquidacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.LiquidacaoRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.LiquidacaoParams;
import com.google.common.base.Strings;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import lombok.Generated;
import org.apache.commons.lang.NotImplementedException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class LiquidacaoOxyRepositoryImpl
implements LiquidacaoRepository {
    private static final String VALOR = "valor";
    private static final String DATAMOVIMENTO_INICIO = "dataMovimentoInicio";
    private static final String DATAMOVIMENTO_FIM = "dataMovimentoFim";
    private static final String DATA_INICIO = "dataInicio";
    private static final String DATA_FIM = "dataFim";
    private static final String EMPENHO = "empenho";
    private static final String LIQUIDACAO = "liquidacao";
    private static final String APTOS_PAGAMENTO = "aptos-pagamentos";
    private static final HashMap<String, BiFunction<Sort.Order, String, Sort.Order>> ORDERS = new HashMap();
    private static final HashMap<String, BiFunction<String, String, String>> FILTERS = new HashMap();
    private static final String DESPESA_ORCAMENTARIA = "2";
    private static final String DATAVENCIMENTO_INICIO = "dataVencimentoInicio";
    private static final String DATAVENCIMENTO_FIM = "dataVencimentoFim";
    public static final String LIQUIDACAO_PREFIX = ";liquidacao.";
    private final PagamentoFeignClient pagamentoFeignClient;
    private final LiquidacaoFeignClient liquidacaoFeignClient;

    public Page<LiquidacaoDTO> findLiquidacoesAPagar(LiquidacaoParams params, Pageable pageable) {
        LiquidacaoParamsDTO liquidacaoParams = new LiquidacaoParamsDTO();
        liquidacaoParams.setEntidade(params.getEntidade().orElse(0L));
        liquidacaoParams.setExercicio(params.getExercicio().orElse(0L));
        liquidacaoParams.setDataInicio(params.getDataInicialMovimentacao());
        liquidacaoParams.setDataFim(params.getDataFinalMovimentacao());
        liquidacaoParams.setDataInicio(params.getDataInicial());
        liquidacaoParams.setDataFim(params.getDataFinal());
        liquidacaoParams.setOnlyRestoPagar(params.getIsPendentes());
        liquidacaoParams.setOnlySaldoWithAProcessar(Boolean.TRUE);
        EloPage liquidacoes = this.liquidacaoFeignClient.findAllLiquidacoesSaldo(this.buildSearch(params, ";"), this.buildSort(pageable, Boolean.valueOf(false)), liquidacaoParams);
        ArrayList liquidacoesDTO = new ArrayList();
        liquidacoes.getContent().forEach(l -> liquidacoesDTO.add(new LiquidacaoDTO(l)));
        return new PageImpl(liquidacoesDTO, pageable, liquidacoes.getTotalElements());
    }

    public Page<LiquidacaoDTO> findAgendaPrevisaoPagamento(LiquidacaoParams params, Pageable pageable) {
        return this.findLiquidacoesAPagar(params, pageable);
    }

    public Page<LiquidacaoDTO> findLiquidacoesPagas(LiquidacaoParams params, Pageable pageable) {
        PagamentoParamsDTO pagamentoParams = this.buildPagamentoParamsDTO(params);
        EloPage pagamentos = this.pagamentoFeignClient.findAllPagamentosSaldo(this.buildSearchPagamento(params), this.buildSort(pageable, Boolean.valueOf(true)), pagamentoParams);
        ArrayList liquidacoes = new ArrayList();
        pagamentos.getContent().forEach(pagamento -> liquidacoes.add(new LiquidacaoDTO(pagamento)));
        return new PageImpl(liquidacoes, pageable, pagamentos.getTotalElements());
    }

    public LiquidacaoDTO findLiquidacoesPagasTotal(LiquidacaoParams params) {
        PagamentoParamsDTO pagamentoParams = this.buildPagamentoParamsDTO(params);
        EloPage pagamentos = this.pagamentoFeignClient.findAllPagamentosSaldo(this.buildSearchPagamento(params), Pageable.unpaged(), pagamentoParams);
        BigDecimal total = pagamentos.getContent().stream().map(PagamentoDTO::getValorLiquido).reduce(BigDecimal.ZERO, BigDecimal::add);
        return LiquidacaoDTO.builder().valor(total).build();
    }

    private PagamentoParamsDTO buildPagamentoParamsDTO(LiquidacaoParams params) {
        PagamentoParamsDTO pagamentoParams = new PagamentoParamsDTO();
        pagamentoParams.setEntidade(params.getEntidade().orElse(0L));
        pagamentoParams.setExercicio(params.getExercicio().orElse(0L));
        pagamentoParams.setDataInicio(params.getDataInicialMovimentacao());
        pagamentoParams.setDataFim(params.getDataFinalMovimentacao());
        pagamentoParams.setDataInicio(params.getDataInicial());
        pagamentoParams.setDataFim(params.getDataFinal());
        pagamentoParams.setSomenteEmpenhosExercicio(params.getIsPorExercicio());
        pagamentoParams.setSomenteEmpenhosRestos(params.getIsPendentes());
        pagamentoParams.setFilterContabilizacao(SituacaoEventoLancamento.CONTABILIZADOS);
        return pagamentoParams;
    }

    public LiquidacaoDTO findLiquidacoesAPagarTotal(LiquidacaoParams params) {
        LiquidacaoParamsDTO liquidacaoParams = new LiquidacaoParamsDTO();
        liquidacaoParams.setEntidade(params.getEntidade().orElse(0L));
        liquidacaoParams.setExercicio(params.getExercicio().orElse(0L));
        liquidacaoParams.setDataInicio(params.getDataInicialMovimentacao());
        liquidacaoParams.setDataFim(params.getDataFinalMovimentacao());
        liquidacaoParams.setDataInicio(params.getDataInicial());
        liquidacaoParams.setDataFim(params.getDataFinal());
        liquidacaoParams.setOnlyRestoPagar(params.getIsPendentes());
        liquidacaoParams.setOnlySaldoWithAProcessar(Boolean.TRUE);
        LiquidacaoSaldoValoresDTO valoresDTO = this.liquidacaoFeignClient.findTotalWithMovimentacao(this.buildSearch(params, ";"), liquidacaoParams);
        return LiquidacaoDTO.builder().valor(valoresDTO.getLiquidado()).saldo(valoresDTO.getSaldoDisponivel()).build();
    }

    public ContaPagamentoDTO findContaPagamento(LiquidacaoParams params) {
        throw new NotImplementedException();
    }

    private String buildSearch(LiquidacaoParams params, String prefix) {
        StringBuilder search = new StringBuilder();
        params.getCnpjCpf().ifPresent(cnpjCpf -> search.append((String)((BiFunction)FILTERS.get("cnpjCpf")).apply(cnpjCpf, prefix)));
        params.getNome().ifPresent(nome -> search.append((String)((BiFunction)FILTERS.get("nome")).apply(nome, prefix)));
        params.getEmpenho().ifPresent(empenho -> search.append((String)((BiFunction)FILTERS.get(EMPENHO)).apply(empenho.toString(), prefix)));
        params.getOrgao().ifPresent(orgao -> search.append((String)((BiFunction)FILTERS.get("orgao")).apply(orgao, prefix)));
        params.getUnidade().ifPresent(unidade -> search.append((String)((BiFunction)FILTERS.get("unidade")).apply(unidade, prefix)));
        params.getFuncao().ifPresent(funcao -> search.append((String)((BiFunction)FILTERS.get("funcao")).apply(funcao, prefix)));
        params.getSubFuncao().ifPresent(subFuncao -> search.append((String)((BiFunction)FILTERS.get("subFuncao")).apply(subFuncao, prefix)));
        params.getPrograma().ifPresent(programa -> search.append((String)((BiFunction)FILTERS.get("programa")).apply(programa, prefix)));
        params.getProjeto().ifPresent(projeto -> search.append((String)((BiFunction)FILTERS.get("projeto")).apply(projeto, prefix)));
        params.getElemento().ifPresent(elemento -> search.append((String)((BiFunction)FILTERS.get("elemento")).apply(elemento, prefix)));
        params.getDesdobramento().ifPresent(desdobramento -> search.append((String)((BiFunction)FILTERS.get("desdobramento")).apply(desdobramento, prefix)));
        params.getSubDesdobramento().ifPresent(subDesdobramento -> search.append((String)((BiFunction)FILTERS.get("subDesdobramento")).apply(subDesdobramento, prefix)));
        params.getFonteRecurso().ifPresent(fonteRecurso -> search.append((String)((BiFunction)FILTERS.get("fonteRecurso")).apply(fonteRecurso, prefix)));
        if (!Strings.isNullOrEmpty((String)params.getNotaFiscal())) {
            search.append((String)((BiFunction)FILTERS.get("notaFiscal")).apply(params.getNotaFiscal(), prefix));
        }
        if (Objects.nonNull(params.getDataInicialMovimentacao())) {
            search.append((String)((BiFunction)FILTERS.get(DATAMOVIMENTO_INICIO)).apply(params.getDataInicialMovimentacao().toString(), prefix + "empenho.data"));
        }
        if (Objects.nonNull(params.getDataFinalMovimentacao())) {
            search.append((String)((BiFunction)FILTERS.get(DATAMOVIMENTO_FIM)).apply(params.getDataFinalMovimentacao().toString(), prefix + "empenho.data"));
        }
        if (Objects.nonNull(params.getDataInicial())) {
            if (!prefix.contains(LIQUIDACAO)) {
                search.append((String)((BiFunction)FILTERS.get(DATA_INICIO)).apply(params.getDataInicial().toString(), ";dataLiquidacao"));
            } else {
                search.append((String)((BiFunction)FILTERS.get(DATA_INICIO)).apply(params.getDataInicial().toString(), ";centralPagamento.data"));
            }
        }
        if (Objects.nonNull(params.getDataFinal())) {
            if (!prefix.contains(LIQUIDACAO)) {
                search.append((String)((BiFunction)FILTERS.get(DATA_FIM)).apply(params.getDataFinal().toString(), ";dataLiquidacao"));
            } else {
                search.append((String)((BiFunction)FILTERS.get(DATA_FIM)).apply(params.getDataFinal().toString(), ";centralPagamento.data"));
            }
        }
        if (prefix.contains(LIQUIDACAO)) {
            search.append(";tipoDespesa==").append(DESPESA_ORCAMENTARIA);
        }
        if (APTOS_PAGAMENTO.equals(params.getTipo())) {
            search.append(";empenho.tipoLicitacao.codigo!=0");
        }
        if (Objects.nonNull(params.getIsCovid()) && SimNao.toBoolean((String)params.getIsCovid().replace("'", "")).booleanValue()) {
            search.append(prefix).append("empenho.covid==true");
        }
        if (search.toString().isEmpty()) {
            return "";
        }
        return search.substring(1);
    }

    private void resolveTipoContrato(String tipoContrato, StringBuilder search) {
        String basefilter = ";liquidacao.empenho.contrato.tipoContrato==";
        String resultado = switch (tipoContrato) {
            case "fornecimentoBens" -> ";liquidacao.empenho.contrato.tipoContrato==5";
            case "locacoes" -> ";liquidacao.empenho.contrato.tipoContrato==4";
            case "prestacaoServicos" -> ";liquidacao.empenho.contrato.tipoContrato==3";
            case "obras" -> ";liquidacao.empenho.despesaElemento=='51'";
            default -> "";
        };
        search.append(resultado);
    }

    private String buildSearchPagamento(LiquidacaoParams params) {
        StringBuilder search = new StringBuilder(";").append(this.buildSearch(params, LIQUIDACAO_PREFIX));
        if (Boolean.TRUE.equals(params.getIsPorExercicio())) {
            search.append((String)((BiFunction)FILTERS.get("somenteExercicio")).apply(params.getExercicio().orElse(0L).toString(), LIQUIDACAO_PREFIX));
        }
        if (Boolean.TRUE.equals(params.getIsPendentes())) {
            search.append((String)((BiFunction)FILTERS.get("somenteRestos")).apply(params.getExercicio().orElse(0L).toString(), LIQUIDACAO_PREFIX));
        }
        search.append(";centralPagamento.contabilizado==true");
        params.getTipoContrato().ifPresent(tipoContrato -> this.resolveTipoContrato(tipoContrato, search));
        return search.substring(1);
    }

    private Pageable buildSort(Pageable pageable, Boolean pagamento) {
        ArrayList orders = new ArrayList();
        if (pageable.getSort().isSorted()) {
            pageable.getSort().toList().forEach(sort -> {
                if (pagamento.booleanValue()) {
                    this.addSortPagamento(orders, sort);
                } else {
                    this.addSortLiquidacao(orders, sort);
                }
            });
        } else if (pagamento.booleanValue()) {
            this.setOrdemPadraoPagamento(orders);
        }
        return PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)Sort.by(orders));
    }

    private void setOrdemPadraoPagamento(List<Sort.Order> orders) {
        orders.add(Sort.Order.asc((String)"liquidacao.empenho.fonteRecurso"));
        orders.add(Sort.Order.desc((String)"liquidacao.dataVencimento"));
        orders.add(Sort.Order.desc((String)"centralPagamento.data"));
    }

    private void addSortLiquidacao(List<Sort.Order> orders, Sort.Order sort) {
        if ("data".equals(sort.getProperty())) {
            orders.add((Sort.Order)((BiFunction)ORDERS.get("data")).apply(sort, "dataLiquidacao"));
        } else if ("dataVencimento".equals(sort.getProperty())) {
            orders.add((Sort.Order)((BiFunction)ORDERS.get("data")).apply(sort, "dataVencimento"));
        } else if (VALOR.equals(sort.getProperty())) {
            orders.add((Sort.Order)((BiFunction)ORDERS.get(VALOR)).apply(sort, VALOR));
        } else {
            orders.add((Sort.Order)((BiFunction)ORDERS.get(sort.getProperty())).apply(sort, ""));
        }
    }

    private void addSortPagamento(List<Sort.Order> orders, Sort.Order sort) {
        if (sort.getProperty().equals("data")) {
            orders.add((Sort.Order)((BiFunction)ORDERS.get(sort.getProperty())).apply(sort, "centralPagamento.data"));
        } else if (sort.getProperty().equals("valorParametro")) {
            orders.add((Sort.Order)((BiFunction)ORDERS.get(sort.getProperty())).apply(sort, "valorLiquido"));
        } else if (sort.getProperty().equals(VALOR)) {
            orders.add((Sort.Order)((BiFunction)ORDERS.get(sort.getProperty())).apply(sort, "valorLiquido"));
        } else {
            orders.add((Sort.Order)((BiFunction)ORDERS.get(sort.getProperty())).apply(sort, "liquidacao."));
        }
    }

    @Generated
    public LiquidacaoOxyRepositoryImpl(PagamentoFeignClient pagamentoFeignClient, LiquidacaoFeignClient liquidacaoFeignClient) {
        this.pagamentoFeignClient = pagamentoFeignClient;
        this.liquidacaoFeignClient = liquidacaoFeignClient;
    }

    static {
        ORDERS.put("fonteRecurso", (sort, prefix) -> new Sort.Order(sort.getDirection(), prefix + "empenho.fonteRecurso"));
        ORDERS.put("ordemFonteRecurso", (sort, prefix) -> new Sort.Order(sort.getDirection(), prefix + "empenho.fonteRecurso"));
        ORDERS.put("data", (sort, prefix) -> new Sort.Order(sort.getDirection(), prefix));
        ORDERS.put(EMPENHO, (sort, prefix) -> new Sort.Order(sort.getDirection(), prefix + "empenho.numeroEmpenho"));
        ORDERS.put("noLiquidacao", (sort, prefix) -> new Sort.Order(sort.getDirection(), prefix + "numeroLiquidacao"));
        ORDERS.put("fornecedor", (sort, prefix) -> new Sort.Order(sort.getDirection(), prefix + "empenho.credor.cnpjCpf"));
        ORDERS.put("tipoLicitacao", (sort, prefix) -> new Sort.Order(sort.getDirection(), prefix + "empenho.tipoLicitacao.codigo"));
        ORDERS.put("licitacao", (sort, prefix) -> new Sort.Order(sort.getDirection(), prefix + "empenho.licitacao.numeroLicitacao"));
        ORDERS.put("valorParametro", (sort, prefix) -> new Sort.Order(sort.getDirection(), prefix));
        ORDERS.put(VALOR, (sort, prefix) -> new Sort.Order(sort.getDirection(), prefix));
        ORDERS.put("dataVencimento", (sort, prefix) -> new Sort.Order(sort.getDirection(), prefix + "dataVencimento"));
        ORDERS.put("dataLiquidacao", (sort, prefix) -> new Sort.Order(sort.getDirection(), prefix + "dataLiquidacao"));
        FILTERS.put("cnpjCpf", (filter, prefix) -> prefix + "empenho.credor.cnpjCpf=='*" + filter + "*'");
        FILTERS.put("nome", (filter, prefix) -> prefix + "empenho.credor.nome=='*" + filter + "*'");
        FILTERS.put(EMPENHO, (filter, prefix) -> prefix + "empenho.numeroEmpenho==" + filter);
        FILTERS.put("notaFiscal", (filter, prefix) -> prefix + "documentos.numeroDocumento=='*" + filter + "*'");
        FILTERS.put(DATAMOVIMENTO_INICIO, (filter, prefix) -> prefix + ">=" + filter);
        FILTERS.put(DATAMOVIMENTO_FIM, (filter, prefix) -> prefix + "<=" + filter);
        FILTERS.put(DATA_INICIO, (filter, prefix) -> prefix + ">=" + filter);
        FILTERS.put(DATA_FIM, (filter, prefix) -> prefix + "<=" + filter);
        FILTERS.put("somenteExercicio", (filter, prefix) -> prefix + "empenho.exercicio.exercicio==" + filter);
        FILTERS.put("somenteRestos", (filter, prefix) -> prefix + "empenho.exercicio.exercicio!=" + filter);
        FILTERS.put("orgao", (filter, prefix) -> prefix + "empenho.orgao.codigo=='" + filter + "'");
        FILTERS.put("unidade", (filter, prefix) -> prefix + "empenho.unidade.codigo=='" + filter + "'");
        FILTERS.put("funcao", (filter, prefix) -> prefix + "empenho.funcao.codigo=='" + filter + "'");
        FILTERS.put("subFuncao", (filter, prefix) -> prefix + "empenho.subFuncao.codigo=='" + filter + "'");
        FILTERS.put("programa", (filter, prefix) -> prefix + "empenho.programa.codigo=='" + filter + "'");
        FILTERS.put("projeto", (filter, prefix) -> prefix + "empenho.projeto.codigo=='" + filter + "'");
        FILTERS.put("elemento", (filter, prefix) -> prefix + "empenho.elemento.codigo=='" + filter + "'");
        FILTERS.put("desdobramento", (filter, prefix) -> prefix + "empenho.desdobramento.codigo=='" + filter + "'");
        FILTERS.put("subDesdobramento", (filter, prefix) -> prefix + "empenho.subDesdobramento.codigo=='" + filter + "'");
        FILTERS.put("fonteRecurso", (filter, prefix) -> prefix + "empenho.fonteRecurso.codigo=='" + filter + "'");
        FILTERS.put(DATAVENCIMENTO_INICIO, (filter, prefix) -> prefix + ">=" + filter);
        FILTERS.put(DATAVENCIMENTO_FIM, (filter, prefix) -> prefix + "<=" + filter);
    }
}

