/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.domain.dto;

import br.com.elotech.contabilidade.client.dto.ExercicioDTO;
import br.com.elotech.contabilidade.client.dto.ExtraOrcamentarioDTO;
import br.com.elotech.contabilidade.client.dto.LiquidacaoDTO;
import br.com.elotech.contabilidade.client.dto.RetencaoLiquidacaoDTO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Optional;
import lombok.Generated;

public class EmpenhoRetencaoDTO {
    private Long entidade;
    private Long exercicio;
    private Long empenho;
    private String unidadeOrcamentaria;
    private Long exercicioLiquidacao;
    private Long noLiquidacao;
    private LocalDate data;
    private BigDecimal valor;
    private BigDecimal valorEstornado;
    private String descricao;

    public EmpenhoRetencaoDTO(RetencaoLiquidacaoDTO retencao, LiquidacaoDTO liquidacao) {
        ExercicioDTO exercicioLiq = Optional.ofNullable(liquidacao.getExercicio()).orElse(new ExercicioDTO());
        this.entidade = exercicioLiq.getEntidade().getId();
        this.exercicio = exercicioLiq.getExercicio();
        this.exercicioLiquidacao = exercicioLiq.getExercicio();
        this.empenho = liquidacao.getEmpenho().getNumeroEmpenho();
        this.noLiquidacao = liquidacao.getNumeroLiquidacao();
        this.data = liquidacao.getDataLiquidacao();
        this.valor = retencao.getSaldoRetido();
        this.valorEstornado = retencao.getSaldoRetidoAnulado();
        this.descricao = Optional.ofNullable(retencao.getExtraOrcamentario()).orElse(new ExtraOrcamentarioDTO()).getDescricao();
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getEmpenho() {
        return this.empenho;
    }

    @Generated
    public String getUnidadeOrcamentaria() {
        return this.unidadeOrcamentaria;
    }

    @Generated
    public Long getExercicioLiquidacao() {
        return this.exercicioLiquidacao;
    }

    @Generated
    public Long getNoLiquidacao() {
        return this.noLiquidacao;
    }

    @Generated
    public LocalDate getData() {
        return this.data;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public BigDecimal getValorEstornado() {
        return this.valorEstornado;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setEmpenho(Long empenho) {
        this.empenho = empenho;
    }

    @Generated
    public void setUnidadeOrcamentaria(String unidadeOrcamentaria) {
        this.unidadeOrcamentaria = unidadeOrcamentaria;
    }

    @Generated
    public void setExercicioLiquidacao(Long exercicioLiquidacao) {
        this.exercicioLiquidacao = exercicioLiquidacao;
    }

    @Generated
    public void setNoLiquidacao(Long noLiquidacao) {
        this.noLiquidacao = noLiquidacao;
    }

    @Generated
    public void setData(LocalDate data) {
        this.data = data;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setValorEstornado(BigDecimal valorEstornado) {
        this.valorEstornado = valorEstornado;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmpenhoRetencaoDTO)) {
            return false;
        }
        EmpenhoRetencaoDTO other = (EmpenhoRetencaoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$empenho = this.getEmpenho();
        Long other$empenho = other.getEmpenho();
        if (this$empenho == null ? other$empenho != null : !((Object)this$empenho).equals(other$empenho)) {
            return false;
        }
        Long this$exercicioLiquidacao = this.getExercicioLiquidacao();
        Long other$exercicioLiquidacao = other.getExercicioLiquidacao();
        if (this$exercicioLiquidacao == null ? other$exercicioLiquidacao != null : !((Object)this$exercicioLiquidacao).equals(other$exercicioLiquidacao)) {
            return false;
        }
        Long this$noLiquidacao = this.getNoLiquidacao();
        Long other$noLiquidacao = other.getNoLiquidacao();
        if (this$noLiquidacao == null ? other$noLiquidacao != null : !((Object)this$noLiquidacao).equals(other$noLiquidacao)) {
            return false;
        }
        String this$unidadeOrcamentaria = this.getUnidadeOrcamentaria();
        String other$unidadeOrcamentaria = other.getUnidadeOrcamentaria();
        if (this$unidadeOrcamentaria == null ? other$unidadeOrcamentaria != null : !this$unidadeOrcamentaria.equals(other$unidadeOrcamentaria)) {
            return false;
        }
        LocalDate this$data = this.getData();
        LocalDate other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        BigDecimal this$valor = this.getValor();
        BigDecimal other$valor = other.getValor();
        if (this$valor == null ? other$valor != null : !((Object)this$valor).equals(other$valor)) {
            return false;
        }
        BigDecimal this$valorEstornado = this.getValorEstornado();
        BigDecimal other$valorEstornado = other.getValorEstornado();
        if (this$valorEstornado == null ? other$valorEstornado != null : !((Object)this$valorEstornado).equals(other$valorEstornado)) {
            return false;
        }
        String this$descricao = this.getDescricao();
        String other$descricao = other.getDescricao();
        return !(this$descricao == null ? other$descricao != null : !this$descricao.equals(other$descricao));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EmpenhoRetencaoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $empenho = this.getEmpenho();
        result = result * 59 + ($empenho == null ? 43 : ((Object)$empenho).hashCode());
        Long $exercicioLiquidacao = this.getExercicioLiquidacao();
        result = result * 59 + ($exercicioLiquidacao == null ? 43 : ((Object)$exercicioLiquidacao).hashCode());
        Long $noLiquidacao = this.getNoLiquidacao();
        result = result * 59 + ($noLiquidacao == null ? 43 : ((Object)$noLiquidacao).hashCode());
        String $unidadeOrcamentaria = this.getUnidadeOrcamentaria();
        result = result * 59 + ($unidadeOrcamentaria == null ? 43 : $unidadeOrcamentaria.hashCode());
        LocalDate $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        BigDecimal $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : ((Object)$valor).hashCode());
        BigDecimal $valorEstornado = this.getValorEstornado();
        result = result * 59 + ($valorEstornado == null ? 43 : ((Object)$valorEstornado).hashCode());
        String $descricao = this.getDescricao();
        result = result * 59 + ($descricao == null ? 43 : $descricao.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EmpenhoRetencaoDTO(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", empenho=" + this.getEmpenho() + ", unidadeOrcamentaria=" + this.getUnidadeOrcamentaria() + ", exercicioLiquidacao=" + this.getExercicioLiquidacao() + ", noLiquidacao=" + this.getNoLiquidacao() + ", data=" + String.valueOf(this.getData()) + ", valor=" + String.valueOf(this.getValor()) + ", valorEstornado=" + String.valueOf(this.getValorEstornado()) + ", descricao=" + this.getDescricao() + ")";
    }

    @Generated
    public EmpenhoRetencaoDTO() {
    }
}

