/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.resource.params;

import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindPessoaAdmParams;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class FindPessoaAdmParams {
    private Long pessoa;
    private Long idUnico;
    private String tipoPessoa;
    private String nome;
    private String cnpjCpf;
    private String fornecedor;
    private Long situacao;
    private String inicioDataIniSuspensao;
    private String fimDataIniSuspensao;
    private String inicioDataFinSuspensao;
    private String fimDataFinSuspensao;
    private String observacao;
    private Boolean somenteSuspensos;
    private String exportType;

    public String montaWhere() {
        StringBuilder where = new StringBuilder();
        where.append("\n WHERE 1 = 1 ");
        if (Objects.nonNull(this.pessoa)) {
            where.append("\n AND A.PESSOA = :pessoa");
        }
        if (Objects.nonNull(this.idUnico)) {
            where.append("\n AND A.IDUNICO = :idUnico");
        }
        if (Objects.nonNull(this.tipoPessoa)) {
            where.append("\n AND A.TIPOPESSOA = :tipoPessoa");
        }
        if (Objects.nonNull(this.nome)) {
            where.append(SqlUtils.andLike((String)"${db.compras.schema}", (String)"A.NOME", (String)this.nome));
        }
        if (Objects.nonNull(this.observacao)) {
            where.append(SqlUtils.andLike((String)"${db.compras.schema}", (String)"A.OBSERVACAO", (String)this.observacao));
        }
        if (Objects.nonNull(this.cnpjCpf)) {
            where.append("\n AND A.CNPJ_CPF = :cnpjCpf ");
        }
        if (Objects.nonNull(this.fornecedor)) {
            where.append("\n AND A.FORNECEDOR = :fornecedor");
        }
        if (Objects.nonNull(this.situacao)) {
            where.append("\n AND A.SITUACAO = :situacao");
        }
        if (Objects.nonNull(this.inicioDataIniSuspensao)) {
            where.append("\n AND A.DATAINISUSPENSAO >= :inicioDataIniSuspensao");
        }
        if (Objects.nonNull(this.fimDataIniSuspensao)) {
            where.append("\n AND A.DATAINISUSPENSAO <= :fimDataIniSuspensao");
        }
        if (Objects.nonNull(this.inicioDataFinSuspensao)) {
            where.append("\n AND A.DATAFINSUSPENSAO >= :inicioDataFinSuspensao");
        }
        if (Objects.nonNull(this.fimDataFinSuspensao)) {
            where.append("\n AND A.DATAFINSUSPENSAO <= :fimDataFinSuspensao");
        }
        if (Boolean.TRUE.equals(this.somenteSuspensos)) {
            where.append("\n AND A.SITUACAO NOT IN (0)");
        }
        return where.toString();
    }

    public String montaWhereUnico() {
        StringBuilder where = new StringBuilder();
        where.append("\n WHERE 1 = 1 ");
        if (Objects.nonNull(this.pessoa)) {
            where.append("\n AND A.PESSOA = :pessoa");
        }
        if (Objects.nonNull(this.idUnico)) {
            where.append("\n AND A.ID = :idUnico");
        }
        if (Objects.nonNull(this.tipoPessoa)) {
            where.append("\n AND A.TIPOPESSOA = :tipoPessoa");
        }
        if (Objects.nonNull(this.nome)) {
            where.append(" AND UPPER(A.NOME) LIKE UPPER('").append(SqlUtils.toSqlLike((String)this.nome)).append("')");
        }
        if (Objects.nonNull(this.observacao)) {
            where.append(" AND UPPER(A.OBSERVACAO) LIKE UPPER('").append(SqlUtils.toSqlLike((String)this.observacao)).append("')");
        }
        if (Objects.nonNull(this.cnpjCpf)) {
            where.append("\n AND A.CNPJ_CPF = :cnpjCpf ");
        }
        if (Objects.nonNull(this.fornecedor)) {
            where.append("\n AND A.FORNECEDOR = :fornecedor");
        }
        if (Objects.nonNull(this.situacao)) {
            where.append("\n AND A.SITUACAO = :situacao");
        }
        if (Objects.nonNull(this.inicioDataIniSuspensao)) {
            where.append("\n AND A.DATAINISUSPENSAO >= :inicioDataIniSuspensao");
        }
        if (Objects.nonNull(this.fimDataIniSuspensao)) {
            where.append("\n AND A.DATAINISUSPENSAO <= :fimDataIniSuspensao");
        }
        if (Objects.nonNull(this.inicioDataFinSuspensao)) {
            where.append("\n AND A.DATAFIMSUSPENSAO >= :inicioDataFinSuspensao");
        }
        if (Objects.nonNull(this.fimDataFinSuspensao)) {
            where.append("\n AND A.DATAFIMSUSPENSAO <= :fimDataFinSuspensao");
        }
        if (Boolean.TRUE.equals(this.somenteSuspensos)) {
            where.append("\n AND A.SITUACAO NOT IN (0)");
        }
        return where.toString();
    }

    public MapSqlParameterSource toJdbcParameter() {
        MapSqlParameterSource params = new MapSqlParameterSource();
        this.addPessoa(params);
        this.addIdUnico(params);
        this.addTipoPessoa(params);
        this.addNome(params);
        this.addCnpjCpf(params);
        this.addFornecedor(params);
        this.addSituacao(params);
        this.addDatasSuspensao(params);
        this.addObservacao(params);
        return params;
    }

    private void addPessoa(MapSqlParameterSource params) {
        if (Objects.nonNull(this.pessoa)) {
            params.addValue("pessoa", (Object)this.pessoa, 2);
        }
    }

    private void addIdUnico(MapSqlParameterSource params) {
        if (Objects.nonNull(this.idUnico)) {
            params.addValue("idUnico", (Object)this.idUnico, 2);
        }
    }

    private void addTipoPessoa(MapSqlParameterSource params) {
        if (Objects.nonNull(this.tipoPessoa)) {
            params.addValue("tipoPessoa", (Object)this.tipoPessoa, 12);
        }
    }

    private void addNome(MapSqlParameterSource params) {
        if (Objects.nonNull(this.nome)) {
            params.addValue("nome", (Object)this.nome, 12);
        }
    }

    private void addCnpjCpf(MapSqlParameterSource params) {
        if (Objects.nonNull(this.cnpjCpf)) {
            params.addValue("cnpjCpf", (Object)this.cnpjCpf, 12);
        }
    }

    private void addFornecedor(MapSqlParameterSource params) {
        if (Objects.nonNull(this.fornecedor)) {
            params.addValue("fornecedor", (Object)this.fornecedor, 12);
        }
    }

    private void addSituacao(MapSqlParameterSource params) {
        if (Objects.nonNull(this.situacao)) {
            params.addValue("situacao", (Object)this.situacao, 2);
        }
    }

    private void addObservacao(MapSqlParameterSource params) {
        if (Objects.nonNull(this.observacao)) {
            params.addValue("observacao", (Object)this.observacao, 12);
        }
    }

    private void addDatasSuspensao(MapSqlParameterSource params) {
        if (Objects.nonNull(this.inicioDataIniSuspensao)) {
            params.addValue("inicioDataIniSuspensao", (Object)this.inicioDataIniSuspensao, 91);
        }
        if (Objects.nonNull(this.fimDataIniSuspensao)) {
            params.addValue("fimDataIniSuspensao", (Object)this.fimDataIniSuspensao, 91);
        }
        if (Objects.nonNull(this.inicioDataFinSuspensao)) {
            params.addValue("inicioDataFinSuspensao", (Object)this.inicioDataFinSuspensao, 91);
        }
        if (Objects.nonNull(this.fimDataFinSuspensao)) {
            params.addValue("fimDataFinSuspensao", (Object)this.fimDataFinSuspensao, 91);
        }
    }

    public String toOxy() {
        ArrayList<String> filter = new ArrayList<String>();
        Optional.ofNullable(this.nome).ifPresent(nome -> filter.add(String.format("pessoa.nome==\"*%s*\"", nome)));
        Optional.ofNullable(this.cnpjCpf).ifPresent(cnpjCpf -> filter.add(String.format("pessoa.cnpjCpf==\"*%s*\"", cnpjCpf)));
        Optional.ofNullable(this.inicioDataIniSuspensao).ifPresent(inicioDataIniSuspensao -> filter.add(String.format("dataRestricaoInicio=ge=%s", inicioDataIniSuspensao)));
        Optional.ofNullable(this.fimDataIniSuspensao).ifPresent(fimDataIniSuspensao -> filter.add(String.format("dataRestricaoInicio=le=%s", fimDataIniSuspensao)));
        Optional.ofNullable(this.inicioDataFinSuspensao).ifPresent(inicioDataFinSuspensao -> filter.add(String.format("dataRestricaoFim=ge=%s", inicioDataFinSuspensao)));
        Optional.ofNullable(this.fimDataFinSuspensao).ifPresent(fimDataFinSuspensao -> filter.add(String.format("dataRestricaoFim=le=%s", fimDataFinSuspensao)));
        Optional.ofNullable(this.observacao).ifPresent(observacao -> filter.add(String.format("observacao==\"*%s*\"", observacao)));
        if (Boolean.TRUE.equals(this.somenteSuspensos)) {
            filter.add("tipo.controlaRestricao==true");
        }
        return String.join((CharSequence)" and ", filter);
    }

    @Generated
    public static FindPessoaAdmParamsBuilder builder() {
        return new FindPessoaAdmParamsBuilder();
    }

    @Generated
    public FindPessoaAdmParams(Long pessoa, Long idUnico, String tipoPessoa, String nome, String cnpjCpf, String fornecedor, Long situacao, String inicioDataIniSuspensao, String fimDataIniSuspensao, String inicioDataFinSuspensao, String fimDataFinSuspensao, String observacao, Boolean somenteSuspensos, String exportType) {
        this.pessoa = pessoa;
        this.idUnico = idUnico;
        this.tipoPessoa = tipoPessoa;
        this.nome = nome;
        this.cnpjCpf = cnpjCpf;
        this.fornecedor = fornecedor;
        this.situacao = situacao;
        this.inicioDataIniSuspensao = inicioDataIniSuspensao;
        this.fimDataIniSuspensao = fimDataIniSuspensao;
        this.inicioDataFinSuspensao = inicioDataFinSuspensao;
        this.fimDataFinSuspensao = fimDataFinSuspensao;
        this.observacao = observacao;
        this.somenteSuspensos = somenteSuspensos;
        this.exportType = exportType;
    }

    @Generated
    public FindPessoaAdmParams() {
    }

    @Generated
    public Long getPessoa() {
        return this.pessoa;
    }

    @Generated
    public Long getIdUnico() {
        return this.idUnico;
    }

    @Generated
    public String getTipoPessoa() {
        return this.tipoPessoa;
    }

    @Generated
    public String getNome() {
        return this.nome;
    }

    @Generated
    public String getCnpjCpf() {
        return this.cnpjCpf;
    }

    @Generated
    public String getFornecedor() {
        return this.fornecedor;
    }

    @Generated
    public Long getSituacao() {
        return this.situacao;
    }

    @Generated
    public String getInicioDataIniSuspensao() {
        return this.inicioDataIniSuspensao;
    }

    @Generated
    public String getFimDataIniSuspensao() {
        return this.fimDataIniSuspensao;
    }

    @Generated
    public String getInicioDataFinSuspensao() {
        return this.inicioDataFinSuspensao;
    }

    @Generated
    public String getFimDataFinSuspensao() {
        return this.fimDataFinSuspensao;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public Boolean getSomenteSuspensos() {
        return this.somenteSuspensos;
    }

    @Generated
    public String getExportType() {
        return this.exportType;
    }

    @Generated
    public void setPessoa(Long pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setIdUnico(Long idUnico) {
        this.idUnico = idUnico;
    }

    @Generated
    public void setTipoPessoa(String tipoPessoa) {
        this.tipoPessoa = tipoPessoa;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setCnpjCpf(String cnpjCpf) {
        this.cnpjCpf = cnpjCpf;
    }

    @Generated
    public void setFornecedor(String fornecedor) {
        this.fornecedor = fornecedor;
    }

    @Generated
    public void setSituacao(Long situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setInicioDataIniSuspensao(String inicioDataIniSuspensao) {
        this.inicioDataIniSuspensao = inicioDataIniSuspensao;
    }

    @Generated
    public void setFimDataIniSuspensao(String fimDataIniSuspensao) {
        this.fimDataIniSuspensao = fimDataIniSuspensao;
    }

    @Generated
    public void setInicioDataFinSuspensao(String inicioDataFinSuspensao) {
        this.inicioDataFinSuspensao = inicioDataFinSuspensao;
    }

    @Generated
    public void setFimDataFinSuspensao(String fimDataFinSuspensao) {
        this.fimDataFinSuspensao = fimDataFinSuspensao;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setSomenteSuspensos(Boolean somenteSuspensos) {
        this.somenteSuspensos = somenteSuspensos;
    }

    @Generated
    public void setExportType(String exportType) {
        this.exportType = exportType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindPessoaAdmParams)) {
            return false;
        }
        FindPessoaAdmParams other = (FindPessoaAdmParams)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$pessoa = this.getPessoa();
        Long other$pessoa = other.getPessoa();
        if (this$pessoa == null ? other$pessoa != null : !((Object)this$pessoa).equals(other$pessoa)) {
            return false;
        }
        Long this$idUnico = this.getIdUnico();
        Long other$idUnico = other.getIdUnico();
        if (this$idUnico == null ? other$idUnico != null : !((Object)this$idUnico).equals(other$idUnico)) {
            return false;
        }
        Long this$situacao = this.getSituacao();
        Long other$situacao = other.getSituacao();
        if (this$situacao == null ? other$situacao != null : !((Object)this$situacao).equals(other$situacao)) {
            return false;
        }
        Boolean this$somenteSuspensos = this.getSomenteSuspensos();
        Boolean other$somenteSuspensos = other.getSomenteSuspensos();
        if (this$somenteSuspensos == null ? other$somenteSuspensos != null : !((Object)this$somenteSuspensos).equals(other$somenteSuspensos)) {
            return false;
        }
        String this$tipoPessoa = this.getTipoPessoa();
        String other$tipoPessoa = other.getTipoPessoa();
        if (this$tipoPessoa == null ? other$tipoPessoa != null : !this$tipoPessoa.equals(other$tipoPessoa)) {
            return false;
        }
        String this$nome = this.getNome();
        String other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !this$nome.equals(other$nome)) {
            return false;
        }
        String this$cnpjCpf = this.getCnpjCpf();
        String other$cnpjCpf = other.getCnpjCpf();
        if (this$cnpjCpf == null ? other$cnpjCpf != null : !this$cnpjCpf.equals(other$cnpjCpf)) {
            return false;
        }
        String this$fornecedor = this.getFornecedor();
        String other$fornecedor = other.getFornecedor();
        if (this$fornecedor == null ? other$fornecedor != null : !this$fornecedor.equals(other$fornecedor)) {
            return false;
        }
        String this$inicioDataIniSuspensao = this.getInicioDataIniSuspensao();
        String other$inicioDataIniSuspensao = other.getInicioDataIniSuspensao();
        if (this$inicioDataIniSuspensao == null ? other$inicioDataIniSuspensao != null : !this$inicioDataIniSuspensao.equals(other$inicioDataIniSuspensao)) {
            return false;
        }
        String this$fimDataIniSuspensao = this.getFimDataIniSuspensao();
        String other$fimDataIniSuspensao = other.getFimDataIniSuspensao();
        if (this$fimDataIniSuspensao == null ? other$fimDataIniSuspensao != null : !this$fimDataIniSuspensao.equals(other$fimDataIniSuspensao)) {
            return false;
        }
        String this$inicioDataFinSuspensao = this.getInicioDataFinSuspensao();
        String other$inicioDataFinSuspensao = other.getInicioDataFinSuspensao();
        if (this$inicioDataFinSuspensao == null ? other$inicioDataFinSuspensao != null : !this$inicioDataFinSuspensao.equals(other$inicioDataFinSuspensao)) {
            return false;
        }
        String this$fimDataFinSuspensao = this.getFimDataFinSuspensao();
        String other$fimDataFinSuspensao = other.getFimDataFinSuspensao();
        if (this$fimDataFinSuspensao == null ? other$fimDataFinSuspensao != null : !this$fimDataFinSuspensao.equals(other$fimDataFinSuspensao)) {
            return false;
        }
        String this$observacao = this.getObservacao();
        String other$observacao = other.getObservacao();
        if (this$observacao == null ? other$observacao != null : !this$observacao.equals(other$observacao)) {
            return false;
        }
        String this$exportType = this.getExportType();
        String other$exportType = other.getExportType();
        return !(this$exportType == null ? other$exportType != null : !this$exportType.equals(other$exportType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FindPessoaAdmParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $pessoa = this.getPessoa();
        result = result * 59 + ($pessoa == null ? 43 : ((Object)$pessoa).hashCode());
        Long $idUnico = this.getIdUnico();
        result = result * 59 + ($idUnico == null ? 43 : ((Object)$idUnico).hashCode());
        Long $situacao = this.getSituacao();
        result = result * 59 + ($situacao == null ? 43 : ((Object)$situacao).hashCode());
        Boolean $somenteSuspensos = this.getSomenteSuspensos();
        result = result * 59 + ($somenteSuspensos == null ? 43 : ((Object)$somenteSuspensos).hashCode());
        String $tipoPessoa = this.getTipoPessoa();
        result = result * 59 + ($tipoPessoa == null ? 43 : $tipoPessoa.hashCode());
        String $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : $nome.hashCode());
        String $cnpjCpf = this.getCnpjCpf();
        result = result * 59 + ($cnpjCpf == null ? 43 : $cnpjCpf.hashCode());
        String $fornecedor = this.getFornecedor();
        result = result * 59 + ($fornecedor == null ? 43 : $fornecedor.hashCode());
        String $inicioDataIniSuspensao = this.getInicioDataIniSuspensao();
        result = result * 59 + ($inicioDataIniSuspensao == null ? 43 : $inicioDataIniSuspensao.hashCode());
        String $fimDataIniSuspensao = this.getFimDataIniSuspensao();
        result = result * 59 + ($fimDataIniSuspensao == null ? 43 : $fimDataIniSuspensao.hashCode());
        String $inicioDataFinSuspensao = this.getInicioDataFinSuspensao();
        result = result * 59 + ($inicioDataFinSuspensao == null ? 43 : $inicioDataFinSuspensao.hashCode());
        String $fimDataFinSuspensao = this.getFimDataFinSuspensao();
        result = result * 59 + ($fimDataFinSuspensao == null ? 43 : $fimDataFinSuspensao.hashCode());
        String $observacao = this.getObservacao();
        result = result * 59 + ($observacao == null ? 43 : $observacao.hashCode());
        String $exportType = this.getExportType();
        result = result * 59 + ($exportType == null ? 43 : $exportType.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FindPessoaAdmParams(pessoa=" + this.getPessoa() + ", idUnico=" + this.getIdUnico() + ", tipoPessoa=" + this.getTipoPessoa() + ", nome=" + this.getNome() + ", cnpjCpf=" + this.getCnpjCpf() + ", fornecedor=" + this.getFornecedor() + ", situacao=" + this.getSituacao() + ", inicioDataIniSuspensao=" + this.getInicioDataIniSuspensao() + ", fimDataIniSuspensao=" + this.getFimDataIniSuspensao() + ", inicioDataFinSuspensao=" + this.getInicioDataFinSuspensao() + ", fimDataFinSuspensao=" + this.getFimDataFinSuspensao() + ", observacao=" + this.getObservacao() + ", somenteSuspensos=" + this.getSomenteSuspensos() + ", exportType=" + this.getExportType() + ")";
    }
}

