/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.resource;

import br.com.elotech.portaltransparencia.comprasportal.domain.AditivoArquivo;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.AditivoDTO;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindAditivoParams;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindContratoParams;
import br.com.elotech.portaltransparencia.comprasportal.service.AditivoService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/aditivos"})
public class AditivoResource {
    private final AditivoService aditivoService;

    @Autowired
    public AditivoResource(AditivoService aditivoService) {
        this.aditivoService = aditivoService;
    }

    @GetMapping
    public ResponseEntity<List<AditivoDTO>> findAditivos(FindContratoParams params) {
        return ResponseEntity.ok((Object)this.aditivoService.findAditivos(params));
    }

    @GetMapping(value={"/detalhes"}, params={"entidade", "exercicio", "numero", "sequencia", "tipoAto", "numeroContrato", "exercicioContrato"})
    public ResponseEntity<AditivoDTO> findAditivo(FindAditivoParams params) {
        return ResponseEntity.ok((Object)this.aditivoService.findAditivo(params));
    }

    @GetMapping(value={"/arquivos"}, params={"entidade", "exercicio", "numero", "sequencia"})
    public ResponseEntity<List<AditivoArquivo>> findArquivos(FindAditivoParams params) {
        List listMidia = this.aditivoService.findArquivos(params);
        return ResponseEntity.ok((Object)listMidia);
    }
}

