/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.arquivoportal.service;

import br.com.elotech.portaltransparencia.arquivoportal.domain.Arquivo;
import br.com.elotech.portaltransparencia.arquivoportal.repository.EloArquivoRepository;
import br.com.elotech.portaltransparencia.arquivoportal.repository.impl.EloArquivoCustomRepository;
import br.com.elotech.portaltransparencia.arquivoportal.service.FindArquivoServiceInt;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.catalina.connector.ClientAbortException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Profile(value={"!cloud"})
@Service
public class FindArquivoSustentacaoService
implements FindArquivoServiceInt {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FindArquivoSustentacaoService.class);
    private final EloArquivoRepository arquivoRepository;
    private final EloArquivoCustomRepository customArquivoRepository;

    public FindArquivoSustentacaoService(EloArquivoRepository arquivoRepository, EloArquivoCustomRepository customArquivoRepository) {
        this.arquivoRepository = arquivoRepository;
        this.customArquivoRepository = customArquivoRepository;
    }

    public Arquivo findOne(Long id) {
        return (Arquivo)this.arquivoRepository.findOne((Object)id);
    }

    public void downloadArquivo(HttpServletResponse outputStream, Long id) throws ClientAbortException, InterruptedException {
        this.customArquivoRepository.downloadArquivo(outputStream, id);
    }

    public String getArquivoNome(Long id) {
        return Optional.ofNullable(this.arquivoRepository.getNameArquivo(id)).orElseThrow(() -> new IllegalArgumentException(String.format("Arquivo [%s] n\u00e3o encontrado", id)));
    }
}

