/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.service;

import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorVencimentosDescontosDTO;
import br.com.elotech.portaltransparencia.web.rest.params.ServidorParams;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.servlet.ModelAndView;

public interface InativoService {
    public Page<ServidorDTO> loadInativos(ServidorParams var1, Pageable var2);

    public Optional<ServidorDTO> loadInativo(ServidorParams var1);

    public List<ServidorVencimentosDescontosDTO> loadVencimentoEDescontos(ServidorParams var1);

    public String findNomeEntidadeById(Long var1);

    public BaseExport getBaseExport();

    public Boolean isIntegradoOxy();

    default public ModelAndView exportReport(HttpServletRequest request, HttpServletResponse response, ServidorParams servidorParams, Page<ServidorDTO> servidoresPage) throws Throwable {
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(this.findNomeEntidadeById(servidorParams.getEntidade()));
        reportParam.setReportTitle("Inativos");
        reportParam.setClazzDTO(ServidorDTO.class);
        String headerFields = "Nome,Matr\u00edcula,Situa\u00e7\u00e3o,Cargo,Classe,Lota\u00e7\u00e3o";
        String fields = "nome,matricula,situacao,descricaoCargo,descricaoClasse,descricaoLotacao";
        float[] fieldsPerc = new float[]{1.5f, 0.9f, 1.0f, 1.5f, 1.8f, 1.5f};
        int[] fieldTab = new int[]{100, 20, 20, 100, 100, 100};
        if (this.isIntegradoOxy().booleanValue()) {
            headerFields = "Nome,Matr\u00edcula,Situa\u00e7\u00e3o,Admiss\u00e3o,Desligamento,Cargo,Classe,Lota\u00e7\u00e3o";
            fields = "nome,matricula,situacao,dataAdmissao,dataFimContrato,descricaoCargo,descricaoClasse,descricaoLotacao";
            fieldsPerc = new float[]{1.5f, 0.9f, 1.0f, 0.9f, 1.2f, 1.5f, 1.8f, 1.5f};
            fieldTab = new int[]{100, 20, 20, 20, 20, 100, 100, 100};
        }
        reportParam.setHeaderFields(headerFields);
        reportParam.setFields(fields);
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setPage(servidoresPage);
        reportParam.setFontSize(8.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(servidorParams.getExportType());
        reportParam.setMaxRecord(servidoresPage.getSize());
        return this.getBaseExport().toExport(reportParam);
    }
}

