/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.service;

import br.com.elotech.portaltransparencia.aiseportal.domain.dto.CedidoDTO;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.FindCedidoParams;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.servlet.ModelAndView;

public interface CedidoService {
    public Page<CedidoDTO> findCedidos(FindCedidoParams var1, Pageable var2);

    public String findNomeEntidadeById(Long var1);

    public BaseExport getBaseExport();

    default public ModelAndView exportReport(HttpServletRequest request, HttpServletResponse response, @Valid FindCedidoParams params, Pageable pageable, int size) throws Throwable {
        PageRequest pageRequest = PageRequest.of((int)0, (int)size, (Sort)pageable.getSort());
        Page page = this.findCedidos(params, (Pageable)pageRequest);
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(this.findNomeEntidadeById(params.getEntidade()));
        reportParam.setReportTitle(String.format("Servidores %s", this.getDescricaoTipo(params.getTipoMovimentacao(), params.getCedenteFinalizado())));
        reportParam.setClazzDTO(CedidoDTO.class);
        reportParam.setHeaderFields("Matricula,Nome,Entidade,N\u00famero do Ato,Ano do Ato,Tipo do Ato, In\u00edcio Vig\u00eancia, Fim Vig\u00eancia");
        reportParam.setFields("matricula,nome,localCedido,numeroAto,anoAto,tipoAto,dataInicio,dataFim");
        float[] fieldsPerc = new float[]{2.0f, 4.0f, 4.0f, 2.0f, 2.0f, 4.0f, 2.0f, 2.0f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{20, 100, 100, 20, 20, 50, 20, 20};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setPage(page);
        reportParam.setFontSize(8.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.getBaseExport().toExport(reportParam);
    }

    private String getDescricaoTipo(Long tipoMovimentacao, Boolean finalizados) {
        Long cedidosDE = 90L;
        if (cedidosDE.equals(tipoMovimentacao) && !finalizados.booleanValue()) {
            return "Cedidos DE";
        }
        Long cedidosPARA = 23L;
        if (cedidosPARA.equals(tipoMovimentacao) && !finalizados.booleanValue()) {
            return "Cedidos PARA";
        }
        if (cedidosDE.equals(tipoMovimentacao)) {
            return "Cedidos DE (Finalizados)";
        }
        if (cedidosPARA.equals(tipoMovimentacao)) {
            return "Cedidos PARA (Finalizados)";
        }
        return "Cedidos";
    }
}

