/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.repository.impl;

import br.com.elotech.adm.compras.client.ObrasClient;
import br.com.elotech.core.utils.EloPage;
import br.com.elotech.oxy.adm.compras.client.portal.ObrasPortalDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.ObraAcompanhamentoImagem;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.MedicaoObraDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ObraDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ObraEmpenhoPortalDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ObraFontesRescursosPortalDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ObraOrdemServicoArquivoDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ObrasResponsavelDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.PlanilhaObraDTO;
import br.com.elotech.portaltransparencia.aiseportal.repository.ObraRepository;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.FindObraParams;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.UltimaAtualizacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.mapper.ObrasEmpenhoPortalDTOToObraEmpenhoPortalDTO;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class ObraOxyRepositoryImpl
implements ObraRepository {
    private final ObrasClient obrasClient;

    public ObraOxyRepositoryImpl(ObrasClient obrasClient) {
        this.obrasClient = obrasClient;
    }

    public Page<ObraDTO> findObras(FindObraParams params, Pageable pageable) {
        EloPage oxyDtoPage = this.obrasClient.findObras(params.toObrasOxyParams(), pageable);
        List obrasList = oxyDtoPage.getContent().stream().map(ObraDTO::fromOxy).collect(Collectors.toList());
        ObraDTO.setFieldsDisplay(obrasList);
        return new PageImpl(obrasList, pageable, oxyDtoPage.getTotalElements());
    }

    public ObraDTO findObra(FindObraParams params) {
        return ObraDTO.fromOxy((ObrasPortalDTO)this.obrasClient.findObra(params.toObrasOxyParams()));
    }

    public List<MedicaoObraDTO> findMedicoes(FindObraParams params) {
        return this.obrasClient.findMedicoes(params.toObrasOxyParams()).stream().map(MedicaoObraDTO::fromOxy).collect(Collectors.toList());
    }

    public List<PlanilhaObraDTO> findPlanilhas(FindObraParams params) {
        return this.obrasClient.findPlanilhas(params.toObrasOxyParams()).stream().map(PlanilhaObraDTO::fromOxy).collect(Collectors.toList());
    }

    public List<ObraAcompanhamentoImagem> findArquivosMedicao(FindObraParams params) {
        return this.obrasClient.findImagensMedicao(params.toObrasOxyParams()).stream().map(ObraAcompanhamentoImagem::fromOxy).collect(Collectors.toList());
    }

    public List<UltimaAtualizacaoDTO> findUltimaAtualizacao() {
        return this.obrasClient.findUltimaAtualizacao().stream().map(UltimaAtualizacaoDTO::fromUltimaAtualizacaoOxy).collect(Collectors.toList());
    }

    public List<ObraEmpenhoPortalDTO> findEmpenhos(FindObraParams params) {
        return this.obrasClient.findEmpenhos(params.toObrasOxyParams()).stream().map(new ObrasEmpenhoPortalDTOToObraEmpenhoPortalDTO()).collect(Collectors.toList());
    }

    public List<ObraOrdemServicoArquivoDTO> findObraServicoArquivos(FindObraParams params) {
        return this.obrasClient.findArquivos(params.toObrasOxyParams()).stream().map(ObraOrdemServicoArquivoDTO::fromOxy).collect(Collectors.toList());
    }

    public List<ObraFontesRescursosPortalDTO> findFontesRescurso(FindObraParams params) {
        return this.obrasClient.findFontesRecursos(params.toObrasOxyParams()).stream().map(ObraFontesRescursosPortalDTO::fromOxy).collect(Collectors.toList());
    }

    public List<ObrasResponsavelDTO> findResponsaveis(FindObraParams params) {
        return this.obrasClient.findResponsaveis(params.toObrasOxyParams()).stream().map(ObrasResponsavelDTO::fromOxy).collect(Collectors.toList());
    }
}

