/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.admportal.service;

import br.com.elotech.console.dto.Modulo;
import br.com.elotech.portaltransparencia.admportal.converter.ArquivoDTOConverter;
import br.com.elotech.portaltransparencia.admportal.service.ActiveProfile;
import br.com.elotech.portaltransparencia.admportal.service.UsuarioService;
import br.com.elotech.portaltransparencia.arquivoportal.domain.Arquivo;
import br.com.elotech.portaltransparencia.contabportal.domain.ArquivoContab;
import br.com.elotech.portaltransparencia.contabportal.repository.ArquivoContabRepository;
import br.com.elotech.unico.client.ArquivoStorageFeignClient;
import br.com.elotech.unico.client.domain.TipoArquivoEnum;
import br.com.elotech.unico.client.dto.ArquivoDTO;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.UUID;
import javax.persistence.EntityNotFoundException;
import lombok.Generated;
import org.keycloak.representations.AccessToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class PortalAdminArquivoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PortalAdminArquivoService.class);
    private final Environment environment;
    private final ArquivoContabRepository repository;
    private final ArquivoStorageFeignClient arquivoClient;
    private final UsuarioService usuarioService;

    private boolean isCloudEnvironment() {
        return ActiveProfile.isProfileActive((Environment)this.environment, (String)"cloud");
    }

    @Transactional
    public ArquivoContab adicionarArquivo(MultipartFile multipartFile) {
        ArquivoContab novoArquivoContab = this.criarEstruturaEUploadArquivo(multipartFile);
        return (ArquivoContab)this.repository.save((Object)novoArquivoContab);
    }

    @Transactional
    public ArquivoContab atualizarArquivo(Long idArquivoContab, MultipartFile multipartFile) {
        ArquivoContab arquivoExistente = (ArquivoContab)this.repository.findById((Object)idArquivoContab).orElseThrow(() -> new EntityNotFoundException("ArquivoContab n\u00e3o encontrado com o ID: " + idArquivoContab + ", tente enviar novamente o arquivo"));
        Long idArquivoAntigo = arquivoExistente.getEloArquivo().getId();
        ArquivoContab dadosParaAtualizar = this.criarEstruturaEUploadArquivo(multipartFile);
        arquivoExistente.setNome(dadosParaAtualizar.getNome());
        arquivoExistente.setDataArquivo(dadosParaAtualizar.getDataArquivo());
        arquivoExistente.setEloArquivo(dadosParaAtualizar.getEloArquivo());
        arquivoExistente.setData(LocalDateTime.now());
        ArquivoContab arquivoSalvo = (ArquivoContab)this.repository.save((Object)arquivoExistente);
        this.deletarArquivoFisico(idArquivoAntigo);
        return arquivoSalvo;
    }

    @Transactional
    public void deletarArquivo(ArquivoContab arquivoContab) {
        if (arquivoContab != null && arquivoContab.getEloArquivo().getId() != null) {
            this.repository.delete((Object)arquivoContab);
        }
    }

    private ArquivoContab criarEstruturaEUploadArquivo(MultipartFile multipartFile) {
        ArquivoDTO novoArquivoDTO = this.buildArquivoDTO(multipartFile);
        Arquivo arquivoSalvoNoUnico = this.criarArquivoNoUnico(novoArquivoDTO, multipartFile);
        ArquivoContab arquivoEntity = new ArquivoContab();
        arquivoEntity.setEloArquivo(arquivoSalvoNoUnico);
        arquivoEntity.setNome(novoArquivoDTO.getNome());
        arquivoEntity.setDataArquivo(LocalDateTime.now());
        arquivoEntity.setData(LocalDateTime.now());
        return arquivoEntity;
    }

    private ArquivoDTO buildArquivoDTO(MultipartFile multipartFile) {
        ArquivoDTO novoArquivo = new ArquivoDTO();
        novoArquivo.setDataCriacao(LocalDate.now());
        novoArquivo.setMimeType(multipartFile.getContentType());
        novoArquivo.setNome(multipartFile.getOriginalFilename());
        novoArquivo.setTipo(TipoArquivoEnum.PUBLICACAO_PORTAL);
        novoArquivo.setModulo(Modulo.OXY_PORTAL_TRANSPARENCIA);
        if (this.isCloudEnvironment()) {
            AccessToken accessToken = (AccessToken)this.usuarioService.getAcessToken().orElseThrow(() -> new IllegalStateException("N\u00e3o foi poss\u00edvel obter o AccessToken do usu\u00e1rio."));
            novoArquivo.setUsuario(UUID.fromString(accessToken.getSubject()));
        }
        return novoArquivo;
    }

    private Arquivo criarArquivoNoUnico(ArquivoDTO novoArquivo, MultipartFile multipartFile) {
        return ArquivoDTOConverter.getConverterInstance().from(this.arquivoClient.createWithFile(novoArquivo, multipartFile));
    }

    public void deletarArquivoFisico(Long idArquivo) {
        this.arquivoClient.delete(idArquivo);
    }

    @Generated
    public PortalAdminArquivoService(Environment environment, ArquivoContabRepository repository, ArquivoStorageFeignClient arquivoClient, UsuarioService usuarioService) {
        this.environment = environment;
        this.repository = repository;
        this.arquivoClient = arquivoClient;
        this.usuarioService = usuarioService;
    }
}

