/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.admportal.resource;

import br.com.elotech.portaltransparencia.admportal.domain.dto.ConfiguracaoDTO;
import br.com.elotech.portaltransparencia.admportal.domain.dto.converter.ConfiguracaoConverter;
import br.com.elotech.portaltransparencia.admportal.service.S3Service;
import br.com.elotech.portaltransparencia.contabportal.domain.Configuracao;
import br.com.elotech.portaltransparencia.contabportal.domain.ConfiguracaoInterface;
import br.com.elotech.portaltransparencia.contabportal.service.ConfiguracaoService;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.InvalidPathException;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/configuracoes-gerais", "/admin/configuracoes-gerais"})
public class ConfiguracaoResource {
    private final ConfiguracaoService configuracaoService;
    private final S3Service s3Service;

    public ConfiguracaoResource(ConfiguracaoService configuracaoService, S3Service s3Service) {
        this.configuracaoService = configuracaoService;
        this.s3Service = s3Service;
    }

    @GetMapping
    public ResponseEntity<ConfiguracaoDTO> getConfiguracao() {
        return ResponseEntity.ok((Object)this.configuracaoService.getConfiguracaoDTO());
    }

    @PostMapping
    public ResponseEntity<ConfiguracaoDTO> save(@RequestBody @Valid ConfiguracaoDTO configuracaoDTO) throws URISyntaxException {
        Configuracao configuracao = ConfiguracaoConverter.toEntity((ConfiguracaoDTO)configuracaoDTO);
        return ResponseEntity.created((URI)new URI("")).body((Object)ConfiguracaoConverter.toDTO((Configuracao)this.configuracaoService.save(configuracao)));
    }

    @PutMapping
    public ResponseEntity<ConfiguracaoDTO> update(@RequestBody ConfiguracaoDTO configuracaoDTO) {
        Configuracao saved = this.configuracaoService.save(ConfiguracaoConverter.toEntity((ConfiguracaoDTO)configuracaoDTO));
        return ResponseEntity.ok((Object)ConfiguracaoConverter.toDTO((Configuracao)saved));
    }

    @PostMapping(value={"/imagem"})
    public ResponseEntity<Map<String, String>> saveArquivo(@RequestParam(value="file") MultipartFile file) throws URISyntaxException {
        if (file.isEmpty()) {
            return ResponseEntity.noContent().build();
        }
        ConfiguracaoInterface configuracao = this.configuracaoService.getConfiguracao();
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            map.put("url", this.s3Service.uploadToS3(file, configuracao));
            return ResponseEntity.created((URI)new URI("")).body(map);
        }
        catch (IOException | InvalidPathException e) {
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
    }

    @DeleteMapping(value={"/imagem"})
    public ResponseEntity<Void> deleteArquivo() throws IOException {
        try {
            ConfiguracaoInterface cofiguracao = this.configuracaoService.getConfiguracao();
            if (cofiguracao.getUrlImagem() != null) {
                String key = this.s3Service.getKeyByUrl(cofiguracao.getUrlImagem());
                this.s3Service.removeFromS3(key);
            }
            return ResponseEntity.ok().build();
        }
        catch (InvalidPathException e) {
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
    }
}

