 SELECT TB1.ENTIDADE,                                               
        TB1.EXERCICIO,                                             
        TB1.VALORPLANEJADO,                                             
        TB1.VALORPLANEJADOATUALIZADO,                               
        TB1.VALOREXECUTADO,                 
        TB1.PROJETO,         
        TB1.UNIDADE,    
        TB1.FUNCAO,    
        TB1.PROGRAMA,
        TB1.DESCRICAOPROJETO,                                              
        CASE WHEN :exercicio = ACAOPPA.ANO1 THEN ACAOPPA.METAFISICA1
             WHEN :exercicio = ACAOPPA.ANO2 THEN ACAOPPA.METAFISICA2
             WHEN :exercicio = ACAOPPA.ANO3 THEN ACAOPPA.METAFISICA3
             WHEN :exercicio = ACAOPPA.ANO4 THEN ACAOPPA.METAFISICA4
             ELSE 0
        END METAFISICAPREVISTA, 
        ACAOPPA.NUMEROREALIZADO, 
        MAX(ACAOPPA.RESULTADOOBTIDO) OVER (PARTITION BY TB1.PROJETO) RESULTADOOBTIDO, 
        MAX(ACAOPPA.DSUNIDADEMEDIDA) OVER (PARTITION BY TB1.PROJETO) UNIDADEMEDIDA    
   FROM (                                            
         SELECT A.ENTIDADE,                          
                A.EXERCICIO,                         
                SUM(A.VALORPREVISTO) VALORPLANEJADO, 
                SUM(A.VALORPREVISTO + B.VALORSUPLEMENTACAO - B.VALORREDUCAO - B.VALORESTSUPLEMENTACAO + B.VALORESTREDUCAO) VALORPLANEJADOATUALIZADO, 
                SUM(B.VALOREMPENHO - B.VALORANULACAOEMPENHO + B.VALORESTANULACAOEMPENHO) VALOREXECUTADO,                          
                CAST(SUBSTR(A.PROGRAMATICA, 15, 4) AS VARCHAR(10)) PROJETO,
                CAST(SUBSTR(A.PROGRAMATICA, 1,  5) AS VARCHAR(10)) UNIDADE, 
                CAST(SUBSTR(A.PROGRAMATICA, 6,  2) AS VARCHAR(10)) FUNCAO,
                CAST(SUBSTR(A.PROGRAMATICA, 11, 4) AS VARCHAR(10)) PROGRAMA, 
                (SELECT DESCRICAO                
                   FROM ${db.contabilidade.schema}.ORCPARAMETRODESPESA
                  WHERE ENTIDADE  = A.ENTIDADE   
                    AND EXERCICIO = A.EXERCICIO  
                    AND ORDEM     = 6            
                    AND CODIGO    = SUBSTR(A.PROGRAMATICA, 15, 4)) DESCRICAOPROJETO 
           FROM ${db.contabilidade.schema}.DESPESA A
           JOIN (SELECT DESPESA.ENTIDADE, DESPESA.EXERCICIO, DESPESA.PROGRAMATICA, DESPESA.FONTERECURSO, 
                        SUM(DESPESAMENSAL.VALORSUPLEMENTACAO) AS VALORSUPLEMENTACAO,          
                        SUM(DESPESAMENSAL.VALORREDUCAO) AS VALORREDUCAO,                      
                        SUM(DESPESAMENSAL.VALOREMPENHO) AS VALOREMPENHO,                      
                        SUM(DESPESAMENSAL.VALORANULACAOEMPENHO) AS VALORANULACAOEMPENHO,      
                        SUM(DESPESAMENSAL.VALORESTSUPLEMENTACAO) AS VALORESTSUPLEMENTACAO,    
                        SUM(DESPESAMENSAL.VALORESTREDUCAO) AS VALORESTREDUCAO,                
                        SUM(DESPESAMENSAL.VALORESTANULACAOEMPENHO) AS VALORESTANULACAOEMPENHO 
                   FROM ${db.contabilidade.schema}.DESPESAMENSAL DESPESAMENSAL
                   JOIN ${db.contabilidade.schema}.DESPESA DESPESA
                     ON DESPESA.ENTIDADE     = DESPESAMENSAL.ENTIDADE                   
                    AND DESPESA.EXERCICIO    = DESPESAMENSAL.EXERCICIO                  
                    AND DESPESA.PROGRAMATICA = DESPESAMENSAL.PROGRAMATICA               
                    AND DESPESA.FONTERECURSO = DESPESAMENSAL.FONTERECURSO               
                  WHERE DESPESA.EXERCICIO BETWEEN :exercicio - 2 AND :exercicio
                    AND DESPESA.NIVEL = 6                                               
                  GROUP BY DESPESA.ENTIDADE, DESPESA.EXERCICIO, DESPESA.PROGRAMATICA, DESPESA.FONTERECURSO) B 
             ON A.ENTIDADE     = B.ENTIDADE                                                
            AND A.EXERCICIO    = B.EXERCICIO                                               
            AND A.PROGRAMATICA = B.PROGRAMATICA                                            
            AND A.FONTERECURSO = B.FONTERECURSO                                            
          WHERE A.EXERCICIO BETWEEN :exercicio - 2 AND :exercicio
            AND A.NIVEL = 6                                                                
            AND SUBSTR(A.PROGRAMATICA, 15, 4) 
             IN (SELECT C.PROJETOATIVIDADE          
                   FROM ${db.contabilidade.schema}.ORCPPA A
                   JOIN ${db.contabilidade.schema}.ORCPPAVALOR B
                     ON A.ENTIDADE   = B.ENTIDADE   
                    AND A.EXERCICIO  = B.EXERCICIO  
                    AND A.COD_ORCPPA = B.COD_ORCPPA 
                   JOIN ${db.contabilidade.schema}.ORCACAO C
                     ON B.ENTIDADE   = C.ENTIDADE   
                    AND B.EXERCICIO = C.EXERCICIO   
                    AND B.IDORCACAO = C.ID          
                  WHERE B.EXERCICIO = :exercicio    
                    AND A.TIPOPLANO = 1)            
            $[filtros]
          GROUP BY A.ENTIDADE, A.EXERCICIO, A.PROGRAMATICA 
        ) TB1 
   LEFT JOIN (SELECT ORCACAO.ENTIDADE, ORCACAO.EXERCICIO, ORCACAO.ACAO, 
                     ORCACAO.NUMEROREALIZADO, ORCACAO.PROJETOATIVIDADE,
                     ORCPPAVALOR.ANO1, SUM(ORCPPAVALOR.METAFISICA1) AS METAFISICA1,
                     ORCPPAVALOR.ANO2, SUM(ORCPPAVALOR.METAFISICA2) AS METAFISICA2,
                     ORCPPAVALOR.ANO3, SUM(ORCPPAVALOR.METAFISICA3) AS METAFISICA3,
                     ORCPPAVALOR.ANO4, SUM(ORCPPAVALOR.METAFISICA4) AS METAFISICA4,
                     TIPOUNIDADEMEDIDA.DSUNIDADEMEDIDA,
                     ORCPPAAVALIACAOACAO.RESULTADOOBTIDO
                FROM ${db.contabilidade.schema}.ORCACAO ORCACAO
                LEFT JOIN ${db.contabilidade.schema}.ORCPPAAVALIACAOACAO ORCPPAAVALIACAOACAO
                  ON ORCACAO.ENTIDADE  = ORCPPAAVALIACAOACAO.ENTIDADE
                 AND ORCACAO.EXERCICIO = ORCPPAAVALIACAOACAO.EXERCICIO
                 AND ORCACAO.ID        = ORCPPAAVALIACAOACAO.IDORCACAO
                JOIN ${db.contabilidade.schema}.ORCPPA ORCPPA
                  ON ORCACAO.ENTIDADE  = ORCPPA.ENTIDADE
                 AND ORCACAO.EXERCICIO = ORCPPA.EXERCICIO
                JOIN ${db.contabilidade.schema}.ORCPPAVALOR ORCPPAVALOR
                  ON ORCACAO.ENTIDADE  = ORCPPAVALOR.ENTIDADE
                 AND ORCACAO.EXERCICIO = ORCPPAVALOR.EXERCICIO
                 AND ORCACAO.ID = ORCPPAVALOR.IDORCACAO
                JOIN ${db.contabilidade.schema}.VERSAOPPA VP
                  ON ORCPPA.VERSAO = VP.CODIGOVERSAO
                 AND VP.SITUACAO   = '2'
                LEFT JOIN ${db.contabilidade.schema}.TIPOUNIDADEMEDIDA TIPOUNIDADEMEDIDA
                  ON ORCACAO.IDUNIDADEMEDIDA = TIPOUNIDADEMEDIDA.CODIGO
               WHERE ORCPPA.COD_ORCPPA = ORCPPAVALOR.COD_ORCPPA
                 AND ORCPPA.TIPOPLANO  = 1
               GROUP BY ORCACAO.ENTIDADE, ORCACAO.EXERCICIO, ORCACAO.ACAO, ORCACAO.PROJETOATIVIDADE,
                     ORCACAO.NUMEROREALIZADO, ORCPPAVALOR.ANO1, ORCPPAVALOR.ANO2, ORCPPAVALOR.ANO3, 
                     ORCPPAVALOR.ANO4, TIPOUNIDADEMEDIDA.DSUNIDADEMEDIDA, ORCPPAAVALIACAOACAO.RESULTADOOBTIDO) ACAOPPA
     ON TB1.ENTIDADE  = ACAOPPA.ENTIDADE
    AND TB1.EXERCICIO = ACAOPPA.EXERCICIO
    AND TB1.PROJETO   = ACAOPPA.PROJETOATIVIDADE
  ORDER BY TB1.PROJETO, TB1.EXERCICIO