/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.utils;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Objects;
import javax.swing.text.MaskFormatter;

/*
 * Exception performing whole class analysis ignored.
 */
public final class MaskFormatterUtils {
    private static final int COMPRIMENTO_CPF = 11;

    public static String getMaskFormatado(String value, String mask) {
        try {
            MaskFormatter formatter = new MaskFormatter(mask);
            formatter.setValueContainsLiteralCharacters(false);
            return formatter.valueToString(value);
        }
        catch (ParseException e) {
            return value;
        }
    }

    public static String configMaskCnpjCpf(String cnpjCpf) {
        if (Objects.isNull(cnpjCpf)) {
            return "";
        }
        if ((cnpjCpf = MaskFormatterUtils.somenteNumeros((String)cnpjCpf)).length() == 11) {
            return MaskFormatterUtils.setMaskCpf((String)cnpjCpf);
        }
        return MaskFormatterUtils.getMaskFormatado((String)cnpjCpf, (String)"##.###.###/####-##");
    }

    public static String setMaskCpf(String cpf) {
        return "****" + cpf.substring(4, 7) + "****";
    }

    public static String setMaskCnpj(String cnpj) {
        return "****" + cnpj.substring(4, 8) + "******";
    }

    public static String somenteNumeros(String valor) {
        return valor.replaceAll("[^0-9]", "");
    }

    public static String anonimizarNome(String entrada) {
        String cpf;
        if (entrada.isEmpty()) {
            return "";
        }
        String[] nomeParte = entrada.trim().split("\\s+");
        String string = cpf = nomeParte[nomeParte.length - 1].matches("\\d{11}") ? nomeParte[nomeParte.length - 1] : null;
        if (cpf != null) {
            nomeParte = Arrays.copyOf(nomeParte, nomeParte.length - 1);
        }
        StringBuilder nomeAnonimizado = new StringBuilder(nomeParte[0]);
        for (int i = 1; i < nomeParte.length; ++i) {
            nomeAnonimizado.append(' ').append(nomeParte[i].charAt(0)).append('.');
        }
        if (cpf != null) {
            nomeAnonimizado.append(' ').append(MaskFormatterUtils.setMaskCpf((String)cpf));
        }
        return nomeAnonimizado.toString();
    }
}

