/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.protocportal.dto;

import br.com.elotech.portaltransparencia.protocportal.domain.Funcao;
import br.com.elotech.protocolo.dto.LocalDTO;
import br.com.elotech.protocolo.dto.SituacaoDTO;
import br.com.elotech.protocolo.dto.TramiteDTO;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import lombok.Generated;

public class TramitacaoDTO {
    private Long sequencia;
    private String data;
    private String local;
    private Funcao funcao;
    private String situacao;
    private Long idSituacao;
    private String parecer;

    public static TramitacaoDTO fromOxyTramite(TramiteDTO tramiteDTO) {
        TramitacaoDTO tramitacaoDTO = new TramitacaoDTO();
        tramitacaoDTO.setSequencia(tramiteDTO.getSequencia());
        String dataTramite = tramiteDTO.getData().format(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
        tramitacaoDTO.setData(dataTramite);
        LocalDTO local = Optional.ofNullable(tramiteDTO.getLocal()).orElse(new LocalDTO());
        tramitacaoDTO.setLocal(local.getDescricao());
        tramitacaoDTO.setFuncao(Funcao.fromAcao((String)tramiteDTO.getFuncao().getAcao()));
        SituacaoDTO situacao = Optional.ofNullable(tramiteDTO.getSituacao()).orElse(new SituacaoDTO());
        tramitacaoDTO.setSituacao(situacao.getDescricao());
        tramitacaoDTO.setIdSituacao(situacao.getId());
        tramitacaoDTO.setParecer(tramiteDTO.getParecer());
        return tramitacaoDTO;
    }

    @Generated
    public TramitacaoDTO() {
    }

    @Generated
    public Long getSequencia() {
        return this.sequencia;
    }

    @Generated
    public String getData() {
        return this.data;
    }

    @Generated
    public String getLocal() {
        return this.local;
    }

    @Generated
    public Funcao getFuncao() {
        return this.funcao;
    }

    @Generated
    public String getSituacao() {
        return this.situacao;
    }

    @Generated
    public Long getIdSituacao() {
        return this.idSituacao;
    }

    @Generated
    public String getParecer() {
        return this.parecer;
    }

    @Generated
    public void setSequencia(Long sequencia) {
        this.sequencia = sequencia;
    }

    @Generated
    public void setData(String data) {
        this.data = data;
    }

    @Generated
    public void setLocal(String local) {
        this.local = local;
    }

    @Generated
    public void setFuncao(Funcao funcao) {
        this.funcao = funcao;
    }

    @Generated
    public void setSituacao(String situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setIdSituacao(Long idSituacao) {
        this.idSituacao = idSituacao;
    }

    @Generated
    public void setParecer(String parecer) {
        this.parecer = parecer;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TramitacaoDTO)) {
            return false;
        }
        TramitacaoDTO other = (TramitacaoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$sequencia = this.getSequencia();
        Long other$sequencia = other.getSequencia();
        if (this$sequencia == null ? other$sequencia != null : !((Object)this$sequencia).equals(other$sequencia)) {
            return false;
        }
        Long this$idSituacao = this.getIdSituacao();
        Long other$idSituacao = other.getIdSituacao();
        if (this$idSituacao == null ? other$idSituacao != null : !((Object)this$idSituacao).equals(other$idSituacao)) {
            return false;
        }
        String this$data = this.getData();
        String other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$local = this.getLocal();
        String other$local = other.getLocal();
        if (this$local == null ? other$local != null : !this$local.equals(other$local)) {
            return false;
        }
        Funcao this$funcao = this.getFuncao();
        Funcao other$funcao = other.getFuncao();
        if (this$funcao == null ? other$funcao != null : !this$funcao.equals(other$funcao)) {
            return false;
        }
        String this$situacao = this.getSituacao();
        String other$situacao = other.getSituacao();
        if (this$situacao == null ? other$situacao != null : !this$situacao.equals(other$situacao)) {
            return false;
        }
        String this$parecer = this.getParecer();
        String other$parecer = other.getParecer();
        return !(this$parecer == null ? other$parecer != null : !this$parecer.equals(other$parecer));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TramitacaoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $sequencia = this.getSequencia();
        result = result * 59 + ($sequencia == null ? 43 : ((Object)$sequencia).hashCode());
        Long $idSituacao = this.getIdSituacao();
        result = result * 59 + ($idSituacao == null ? 43 : ((Object)$idSituacao).hashCode());
        String $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $local = this.getLocal();
        result = result * 59 + ($local == null ? 43 : $local.hashCode());
        Funcao $funcao = this.getFuncao();
        result = result * 59 + ($funcao == null ? 43 : $funcao.hashCode());
        String $situacao = this.getSituacao();
        result = result * 59 + ($situacao == null ? 43 : $situacao.hashCode());
        String $parecer = this.getParecer();
        result = result * 59 + ($parecer == null ? 43 : $parecer.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TramitacaoDTO(sequencia=" + this.getSequencia() + ", data=" + this.getData() + ", local=" + this.getLocal() + ", funcao=" + String.valueOf(this.getFuncao()) + ", situacao=" + this.getSituacao() + ", idSituacao=" + this.getIdSituacao() + ", parecer=" + this.getParecer() + ")";
    }
}

