/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service.impl;

import br.com.elotech.contabilidade.client.DiariaFeignClient;
import br.com.elotech.core.utils.EloPage;
import br.com.elotech.dto.EnumCodigoDescricaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ArquivoPessoalDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.DiariaMovimentacaoPassagensDTO;
import br.com.elotech.portaltransparencia.contabportal.resource.params.FindPessoalParams;
import br.com.elotech.portaltransparencia.contabportal.service.PassagemService;
import br.com.elotech.portaltransparencia.contabportal.utils.DiariaOxyUtils;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class PassagemOxyService
implements PassagemService {
    private final DiariaFeignClient diariaFeignClient;
    private static final String ADIANTAMENTO = "2";

    public List<EnumCodigoDescricaoDTO<Long>> getTiposPassagem() {
        List tiposPassagem = this.diariaFeignClient.findTiposPassagem();
        return tiposPassagem.stream().map(tipoPassagem -> new EnumCodigoDescricaoDTO((Object)tipoPassagem.getValue(), tipoPassagem.getDescricao())).collect(Collectors.toList());
    }

    public Page<DiariaMovimentacaoPassagensDTO> findPassagens(FindPessoalParams findPessoalParams, Pageable pageable) {
        String search = DiariaOxyUtils.buildSearch((FindPessoalParams)findPessoalParams, (String)";", (String)ADIANTAMENTO, (Boolean)Boolean.FALSE);
        EloPage passagens = this.diariaFeignClient.findPassagens(Optional.ofNullable(search).orElse(""), findPessoalParams.getExercicio(), findPessoalParams.getEntidade(), pageable);
        List diariaMovimentacaoPassagens = passagens.getContent().stream().map(DiariaMovimentacaoPassagensDTO::new).collect(Collectors.toList());
        return new PageImpl(diariaMovimentacaoPassagens, pageable, passagens.getTotalElements());
    }

    public Optional<DiariaMovimentacaoPassagensDTO> findPassagem(FindPessoalParams filter) {
        return Optional.ofNullable(this.diariaFeignClient.findDiariaById(filter.getIdAdiantamento())).map(DiariaMovimentacaoPassagensDTO::new);
    }

    public List<ArquivoPessoalDTO> findArquivos(FindPessoalParams findPessoalParams) {
        return this.diariaFeignClient.findAnexosDiaria(findPessoalParams.getIdAdiantamento()).stream().map(ArquivoPessoalDTO::new).collect(Collectors.toList());
    }

    @Generated
    public PassagemOxyService(DiariaFeignClient diariaFeignClient) {
        this.diariaFeignClient = diariaFeignClient;
    }
}

