/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.contabilidade.client.EmpenhoFeignClient;
import br.com.elotech.contabilidade.client.dto.EmpenhoTotalDTO;
import br.com.elotech.contabilidade.client.params.EmpenhoParamsDTO;
import br.com.elotech.core.utils.EloPage;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.FornecedorAPagarDTO;
import br.com.elotech.portaltransparencia.contabportal.service.FornecedorAPagarService;
import br.com.elotech.portaltransparencia.contabportal.utils.EmpenhoOxyUtils;
import br.com.elotech.portaltransparencia.web.rest.params.FornecedorAPagarParams;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class FornecedorAPagarOxyService
implements FornecedorAPagarService {
    private final EmpenhoFeignClient empenhoFeignClient;

    public Page<FornecedorAPagarDTO> getFornecedoresAPagar(Pageable pageable, FornecedorAPagarParams params) {
        EloPage fornecedores = this.empenhoFeignClient.findAllFornecedoresByRsqlWithMovimento(params.getEntidade(), params.getExercicio(), this.buildSearch(params), EmpenhoOxyUtils.translateSortToOxy((Pageable)pageable), EmpenhoParamsDTO.builder().onlyAPagar(Boolean.TRUE).entidade(params.getEntidade()).exercicio(params.getExercicio()).build());
        return new PageImpl(fornecedores.getContent().stream().map(FornecedorAPagarDTO::new).collect(Collectors.toList()), pageable, fornecedores.getTotalElements());
    }

    public FornecedorAPagarDTO getFornecedoresAPagarTotais(FornecedorAPagarParams params) {
        EmpenhoTotalDTO empenhoTotalDTO = this.empenhoFeignClient.getTotal(this.buildSearch(params), EmpenhoParamsDTO.builder().onlyAPagar(Boolean.TRUE).entidade(params.getEntidade()).exercicio(params.getExercicio()).build());
        return new FornecedorAPagarDTO(empenhoTotalDTO);
    }

    private String buildSearch(FornecedorAPagarParams params) {
        StringBuilder rsql = new StringBuilder();
        EmpenhoOxyUtils.applyFilter((StringBuilder)rsql, (String)params.getNome(), (String)"credor.nome=='*%s*'");
        if (rsql.length() > 0) {
            EmpenhoOxyUtils.applyFilter((StringBuilder)rsql, (String)params.getCnpjCpf(), (String)";credor.cnpjCpf=='*%s*'");
        } else {
            EmpenhoOxyUtils.applyFilter((StringBuilder)rsql, (String)params.getCnpjCpf(), (String)"credor.cnpjCpf=='*%s*'");
        }
        return rsql.toString();
    }

    @Generated
    public FornecedorAPagarOxyService(EmpenhoFeignClient empenhoFeignClient) {
        this.empenhoFeignClient = empenhoFeignClient;
    }
}

