/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource.params;

import br.com.elotech.portaltransparencia.contabportal.resource.params.FindReceitaParams;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

/*
 * Exception performing whole class analysis ignored.
 */
public class FindReceitaParams {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private Long entidade;
    private Long exercicio;
    private Integer diasRetroativo;
    private Integer mesDiasRetroativos;
    private String receita;
    private String receitaStart;
    private String receitaLike;
    private String descricaoReceita;
    private Long numeroDias;
    private String data;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    private LocalDate dataInicial;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    private LocalDate dataFinal;
    private Long fonteRecurso;
    private String descricaoFonteRecurso;
    private String exportType;
    private String covid;
    private Long fonteRecursoRateio;
    private Boolean fundeb;
    private Boolean execucao;
    private String tipoPesquisa;

    public Integer getMesDiasRetroativos() {
        if (Objects.isNull(this.numeroDias)) {
            this.setNumeroDias(Long.valueOf(0L));
        }
        return FindReceitaParams.getMesDiasRetroativos((int)this.numeroDias.intValue());
    }

    public Optional<String> getCovid() {
        return Optional.ofNullable(this.covid);
    }

    public String getTipoPesquisa() {
        if (Objects.isNull(this.tipoPesquisa)) {
            this.setTipoPesquisa("");
        }
        return this.tipoPesquisa;
    }

    public Boolean getFundeb() {
        if (Objects.isNull(this.fundeb)) {
            this.setFundeb(Boolean.valueOf(false));
        }
        return this.fundeb;
    }

    public Boolean getExecucao() {
        if (Objects.isNull(this.execucao)) {
            this.setExecucao(Boolean.valueOf(false));
        }
        return this.execucao;
    }

    public Optional<String> getReceita() {
        return Optional.ofNullable(this.receita);
    }

    public Optional<String> getReceitaStart() {
        return Optional.ofNullable(this.receitaStart);
    }

    public Optional<String> getReceitaLike() {
        return Optional.ofNullable(this.receitaLike);
    }

    public Optional<String> getDescricaoReceita() {
        return Optional.ofNullable(this.descricaoReceita);
    }

    public Optional<Long> getNumeroDias() {
        return Optional.ofNullable(this.numeroDias);
    }

    public Optional<LocalDate> getDataInicial() {
        return Optional.ofNullable(this.dataInicial);
    }

    public Optional<LocalDate> getDataFinal() {
        return Optional.ofNullable(this.dataFinal);
    }

    public Optional<Long> getFonteRecurso() {
        return Optional.ofNullable(this.fonteRecurso);
    }

    public Optional<Long> getFonteRecursoRateio() {
        return Optional.ofNullable(this.fonteRecursoRateio);
    }

    public Optional<String> getDescricaoFonteRecurso() {
        return Optional.ofNullable(this.descricaoFonteRecurso);
    }

    public MapSqlParameterSource toJdbcParameter(int tamanho) {
        MapSqlParameterSource params = new MapSqlParameterSource();
        this.addEntidade(params);
        this.addExercicio(params);
        this.addDiasRetroativo(params);
        this.addMesDiasRetroativos(params);
        this.addReceita(params, tamanho);
        this.addReceitaStart(params);
        this.addReceitaLike(params);
        this.addDescricaoReceita(params);
        this.addNumeroDias(params);
        this.addTamanho(params, tamanho);
        this.addData(params);
        this.addDataInicial(params);
        this.addDataFinal(params);
        this.addFonteRecurso(params);
        this.addFonteRecursoRateio(params);
        this.addDescricaoFonteRecurso(params);
        return params;
    }

    private void addExercicio(MapSqlParameterSource params) {
        if (Objects.nonNull(this.exercicio)) {
            params.addValue("exercicio", (Object)this.exercicio, 2);
        }
    }

    private void addEntidade(MapSqlParameterSource params) {
        if (Objects.nonNull(this.entidade)) {
            params.addValue("entidade", (Object)this.entidade, 2);
        }
    }

    private void addReceita(MapSqlParameterSource params, int tamanho) {
        if (Objects.nonNull(this.receita)) {
            params.addValue("receita", (Object)StringUtils.rightPad((String)this.receita, (int)tamanho, (String)"0"), 12);
        }
    }

    private void addReceitaStart(MapSqlParameterSource params) {
        if (Objects.nonNull(this.receitaStart)) {
            params.addValue("receitaStart", (Object)String.format("%s%%", this.receitaStart), 12);
        }
    }

    private void addReceitaLike(MapSqlParameterSource params) {
        if (Objects.nonNull(this.receitaLike)) {
            params.addValue("receitaLike", (Object)String.format("%%%s%%", this.receitaLike), 12);
        }
    }

    private void addDescricaoReceita(MapSqlParameterSource params) {
        if (Objects.nonNull(this.descricaoReceita)) {
            params.addValue("descricaoReceita", (Object)("%" + this.descricaoReceita + "%"), 12);
        }
    }

    private void addDiasRetroativo(MapSqlParameterSource params) {
        if (Objects.isNull(this.numeroDias)) {
            this.setNumeroDias(Long.valueOf(0L));
        }
        params.addValue("diasRetroativo", (Object)FindReceitaParams.toSQLDateDiasRetroativoString((int)this.numeroDias.intValue()), 91);
    }

    private void addMesDiasRetroativos(MapSqlParameterSource params) {
        if (Objects.nonNull(this.numeroDias)) {
            params.addValue("mesDiasRetroativos", (Object)this.mesDiasRetroativos, 2);
        }
    }

    private void addNumeroDias(MapSqlParameterSource params) {
        if (Objects.nonNull(this.numeroDias)) {
            params.addValue("numeroDias", (Object)FindReceitaParams.toSQLDateDiasRetroativoString((int)this.numeroDias.intValue()), 91);
        }
    }

    private void addTamanho(MapSqlParameterSource params, int tamanho) {
        if (Objects.nonNull(tamanho)) {
            params.addValue("tamanho", (Object)tamanho, 2);
        }
    }

    private void addData(MapSqlParameterSource params) {
        if (Objects.nonNull(this.data)) {
            params.addValue("data", (Object)this.data, 91);
        }
    }

    public static String toSQLDateDiasRetroativoString(int diasRetroativo) {
        LocalDate data = LocalDate.now().minus(diasRetroativo, ChronoUnit.DAYS);
        return data.format(DATE_FORMAT);
    }

    public static int getMesDiasRetroativos(int diasRetroativo) {
        LocalDate data = LocalDate.now().minus(diasRetroativo, ChronoUnit.DAYS);
        return data.getMonthValue();
    }

    private void addDataInicial(MapSqlParameterSource params) {
        if (Objects.nonNull(this.dataInicial)) {
            params.addValue("dataInicial", (Object)this.dataInicial.format(DATE_FORMAT), 91);
        }
    }

    private void addDataFinal(MapSqlParameterSource params) {
        if (Objects.nonNull(this.dataFinal)) {
            params.addValue("dataFinal", (Object)this.dataFinal.format(DATE_FORMAT), 91);
        }
    }

    private void addFonteRecurso(MapSqlParameterSource params) {
        if (Objects.nonNull(this.fonteRecurso)) {
            params.addValue("fonteRecurso", (Object)this.fonteRecurso, 2);
        }
    }

    private void addFonteRecursoRateio(MapSqlParameterSource params) {
        if (Objects.nonNull(this.fonteRecursoRateio)) {
            params.addValue("fonteRecursoRateio", (Object)this.fonteRecursoRateio, 2);
        }
    }

    private void addDescricaoFonteRecurso(MapSqlParameterSource params) {
        if (Objects.nonNull(this.descricaoFonteRecurso)) {
            params.addValue("descricaoFonteRecurso", (Object)String.format("%%%s%%", this.descricaoFonteRecurso), 12);
        }
    }

    @Generated
    public static FindReceitaParamsBuilder builder() {
        return new FindReceitaParamsBuilder();
    }

    @Generated
    public String toString() {
        return "FindReceitaParams(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", diasRetroativo=" + this.getDiasRetroativo() + ", mesDiasRetroativos=" + this.getMesDiasRetroativos() + ", receita=" + String.valueOf(this.getReceita()) + ", receitaStart=" + String.valueOf(this.getReceitaStart()) + ", receitaLike=" + String.valueOf(this.getReceitaLike()) + ", descricaoReceita=" + String.valueOf(this.getDescricaoReceita()) + ", numeroDias=" + String.valueOf(this.getNumeroDias()) + ", data=" + this.getData() + ", dataInicial=" + String.valueOf(this.getDataInicial()) + ", dataFinal=" + String.valueOf(this.getDataFinal()) + ", fonteRecurso=" + String.valueOf(this.getFonteRecurso()) + ", descricaoFonteRecurso=" + String.valueOf(this.getDescricaoFonteRecurso()) + ", exportType=" + this.getExportType() + ", covid=" + String.valueOf(this.getCovid()) + ", fonteRecursoRateio=" + String.valueOf(this.getFonteRecursoRateio()) + ", fundeb=" + this.getFundeb() + ", execucao=" + this.getExecucao() + ", tipoPesquisa=" + this.getTipoPesquisa() + ")";
    }

    @Generated
    public FindReceitaParams() {
    }

    @Generated
    public FindReceitaParams(Long entidade, Long exercicio, Integer diasRetroativo, Integer mesDiasRetroativos, String receita, String receitaStart, String receitaLike, String descricaoReceita, Long numeroDias, String data, LocalDate dataInicial, LocalDate dataFinal, Long fonteRecurso, String descricaoFonteRecurso, String exportType, String covid, Long fonteRecursoRateio, Boolean fundeb, Boolean execucao, String tipoPesquisa) {
        this.entidade = entidade;
        this.exercicio = exercicio;
        this.diasRetroativo = diasRetroativo;
        this.mesDiasRetroativos = mesDiasRetroativos;
        this.receita = receita;
        this.receitaStart = receitaStart;
        this.receitaLike = receitaLike;
        this.descricaoReceita = descricaoReceita;
        this.numeroDias = numeroDias;
        this.data = data;
        this.dataInicial = dataInicial;
        this.dataFinal = dataFinal;
        this.fonteRecurso = fonteRecurso;
        this.descricaoFonteRecurso = descricaoFonteRecurso;
        this.exportType = exportType;
        this.covid = covid;
        this.fonteRecursoRateio = fonteRecursoRateio;
        this.fundeb = fundeb;
        this.execucao = execucao;
        this.tipoPesquisa = tipoPesquisa;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Integer getDiasRetroativo() {
        return this.diasRetroativo;
    }

    @Generated
    public String getData() {
        return this.data;
    }

    @Generated
    public String getExportType() {
        return this.exportType;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setDiasRetroativo(Integer diasRetroativo) {
        this.diasRetroativo = diasRetroativo;
    }

    @Generated
    public void setMesDiasRetroativos(Integer mesDiasRetroativos) {
        this.mesDiasRetroativos = mesDiasRetroativos;
    }

    @Generated
    public void setReceita(String receita) {
        this.receita = receita;
    }

    @Generated
    public void setReceitaStart(String receitaStart) {
        this.receitaStart = receitaStart;
    }

    @Generated
    public void setReceitaLike(String receitaLike) {
        this.receitaLike = receitaLike;
    }

    @Generated
    public void setDescricaoReceita(String descricaoReceita) {
        this.descricaoReceita = descricaoReceita;
    }

    @Generated
    public void setNumeroDias(Long numeroDias) {
        this.numeroDias = numeroDias;
    }

    @Generated
    public void setData(String data) {
        this.data = data;
    }

    @Generated
    public void setDataInicial(LocalDate dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Generated
    public void setDataFinal(LocalDate dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Generated
    public void setFonteRecurso(Long fonteRecurso) {
        this.fonteRecurso = fonteRecurso;
    }

    @Generated
    public void setDescricaoFonteRecurso(String descricaoFonteRecurso) {
        this.descricaoFonteRecurso = descricaoFonteRecurso;
    }

    @Generated
    public void setExportType(String exportType) {
        this.exportType = exportType;
    }

    @Generated
    public void setCovid(String covid) {
        this.covid = covid;
    }

    @Generated
    public void setFonteRecursoRateio(Long fonteRecursoRateio) {
        this.fonteRecursoRateio = fonteRecursoRateio;
    }

    @Generated
    public void setFundeb(Boolean fundeb) {
        this.fundeb = fundeb;
    }

    @Generated
    public void setExecucao(Boolean execucao) {
        this.execucao = execucao;
    }

    @Generated
    public void setTipoPesquisa(String tipoPesquisa) {
        this.tipoPesquisa = tipoPesquisa;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindReceitaParams)) {
            return false;
        }
        FindReceitaParams other = (FindReceitaParams)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Integer this$diasRetroativo = this.getDiasRetroativo();
        Integer other$diasRetroativo = other.getDiasRetroativo();
        if (this$diasRetroativo == null ? other$diasRetroativo != null : !((Object)this$diasRetroativo).equals(other$diasRetroativo)) {
            return false;
        }
        Integer this$mesDiasRetroativos = this.getMesDiasRetroativos();
        Integer other$mesDiasRetroativos = other.getMesDiasRetroativos();
        if (this$mesDiasRetroativos == null ? other$mesDiasRetroativos != null : !((Object)this$mesDiasRetroativos).equals(other$mesDiasRetroativos)) {
            return false;
        }
        Optional this$numeroDias = this.getNumeroDias();
        Optional other$numeroDias = other.getNumeroDias();
        if (this$numeroDias == null ? other$numeroDias != null : !((Object)this$numeroDias).equals(other$numeroDias)) {
            return false;
        }
        Optional this$fonteRecurso = this.getFonteRecurso();
        Optional other$fonteRecurso = other.getFonteRecurso();
        if (this$fonteRecurso == null ? other$fonteRecurso != null : !((Object)this$fonteRecurso).equals(other$fonteRecurso)) {
            return false;
        }
        Optional this$fonteRecursoRateio = this.getFonteRecursoRateio();
        Optional other$fonteRecursoRateio = other.getFonteRecursoRateio();
        if (this$fonteRecursoRateio == null ? other$fonteRecursoRateio != null : !((Object)this$fonteRecursoRateio).equals(other$fonteRecursoRateio)) {
            return false;
        }
        Boolean this$fundeb = this.getFundeb();
        Boolean other$fundeb = other.getFundeb();
        if (this$fundeb == null ? other$fundeb != null : !((Object)this$fundeb).equals(other$fundeb)) {
            return false;
        }
        Boolean this$execucao = this.getExecucao();
        Boolean other$execucao = other.getExecucao();
        if (this$execucao == null ? other$execucao != null : !((Object)this$execucao).equals(other$execucao)) {
            return false;
        }
        Optional this$receita = this.getReceita();
        Optional other$receita = other.getReceita();
        if (this$receita == null ? other$receita != null : !((Object)this$receita).equals(other$receita)) {
            return false;
        }
        Optional this$receitaStart = this.getReceitaStart();
        Optional other$receitaStart = other.getReceitaStart();
        if (this$receitaStart == null ? other$receitaStart != null : !((Object)this$receitaStart).equals(other$receitaStart)) {
            return false;
        }
        Optional this$receitaLike = this.getReceitaLike();
        Optional other$receitaLike = other.getReceitaLike();
        if (this$receitaLike == null ? other$receitaLike != null : !((Object)this$receitaLike).equals(other$receitaLike)) {
            return false;
        }
        Optional this$descricaoReceita = this.getDescricaoReceita();
        Optional other$descricaoReceita = other.getDescricaoReceita();
        if (this$descricaoReceita == null ? other$descricaoReceita != null : !((Object)this$descricaoReceita).equals(other$descricaoReceita)) {
            return false;
        }
        String this$data = this.getData();
        String other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        Optional this$dataInicial = this.getDataInicial();
        Optional other$dataInicial = other.getDataInicial();
        if (this$dataInicial == null ? other$dataInicial != null : !((Object)this$dataInicial).equals(other$dataInicial)) {
            return false;
        }
        Optional this$dataFinal = this.getDataFinal();
        Optional other$dataFinal = other.getDataFinal();
        if (this$dataFinal == null ? other$dataFinal != null : !((Object)this$dataFinal).equals(other$dataFinal)) {
            return false;
        }
        Optional this$descricaoFonteRecurso = this.getDescricaoFonteRecurso();
        Optional other$descricaoFonteRecurso = other.getDescricaoFonteRecurso();
        if (this$descricaoFonteRecurso == null ? other$descricaoFonteRecurso != null : !((Object)this$descricaoFonteRecurso).equals(other$descricaoFonteRecurso)) {
            return false;
        }
        String this$exportType = this.getExportType();
        String other$exportType = other.getExportType();
        if (this$exportType == null ? other$exportType != null : !this$exportType.equals(other$exportType)) {
            return false;
        }
        Optional this$covid = this.getCovid();
        Optional other$covid = other.getCovid();
        if (this$covid == null ? other$covid != null : !((Object)this$covid).equals(other$covid)) {
            return false;
        }
        String this$tipoPesquisa = this.getTipoPesquisa();
        String other$tipoPesquisa = other.getTipoPesquisa();
        return !(this$tipoPesquisa == null ? other$tipoPesquisa != null : !this$tipoPesquisa.equals(other$tipoPesquisa));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FindReceitaParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Integer $diasRetroativo = this.getDiasRetroativo();
        result = result * 59 + ($diasRetroativo == null ? 43 : ((Object)$diasRetroativo).hashCode());
        Integer $mesDiasRetroativos = this.getMesDiasRetroativos();
        result = result * 59 + ($mesDiasRetroativos == null ? 43 : ((Object)$mesDiasRetroativos).hashCode());
        Optional $numeroDias = this.getNumeroDias();
        result = result * 59 + ($numeroDias == null ? 43 : ((Object)$numeroDias).hashCode());
        Optional $fonteRecurso = this.getFonteRecurso();
        result = result * 59 + ($fonteRecurso == null ? 43 : ((Object)$fonteRecurso).hashCode());
        Optional $fonteRecursoRateio = this.getFonteRecursoRateio();
        result = result * 59 + ($fonteRecursoRateio == null ? 43 : ((Object)$fonteRecursoRateio).hashCode());
        Boolean $fundeb = this.getFundeb();
        result = result * 59 + ($fundeb == null ? 43 : ((Object)$fundeb).hashCode());
        Boolean $execucao = this.getExecucao();
        result = result * 59 + ($execucao == null ? 43 : ((Object)$execucao).hashCode());
        Optional $receita = this.getReceita();
        result = result * 59 + ($receita == null ? 43 : ((Object)$receita).hashCode());
        Optional $receitaStart = this.getReceitaStart();
        result = result * 59 + ($receitaStart == null ? 43 : ((Object)$receitaStart).hashCode());
        Optional $receitaLike = this.getReceitaLike();
        result = result * 59 + ($receitaLike == null ? 43 : ((Object)$receitaLike).hashCode());
        Optional $descricaoReceita = this.getDescricaoReceita();
        result = result * 59 + ($descricaoReceita == null ? 43 : ((Object)$descricaoReceita).hashCode());
        String $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        Optional $dataInicial = this.getDataInicial();
        result = result * 59 + ($dataInicial == null ? 43 : ((Object)$dataInicial).hashCode());
        Optional $dataFinal = this.getDataFinal();
        result = result * 59 + ($dataFinal == null ? 43 : ((Object)$dataFinal).hashCode());
        Optional $descricaoFonteRecurso = this.getDescricaoFonteRecurso();
        result = result * 59 + ($descricaoFonteRecurso == null ? 43 : ((Object)$descricaoFonteRecurso).hashCode());
        String $exportType = this.getExportType();
        result = result * 59 + ($exportType == null ? 43 : $exportType.hashCode());
        Optional $covid = this.getCovid();
        result = result * 59 + ($covid == null ? 43 : ((Object)$covid).hashCode());
        String $tipoPesquisa = this.getTipoPesquisa();
        result = result * 59 + ($tipoPesquisa == null ? 43 : $tipoPesquisa.hashCode());
        return result;
    }
}

