/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.contabilidade.client.enums.TipoSolicitacaoReembolso;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ArquivoPessoalDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ReembolsoRessarcimentoDTO;
import br.com.elotech.portaltransparencia.contabportal.resource.params.ReembolsoRessarcimentoParams;
import br.com.elotech.portaltransparencia.contabportal.service.ReembolsoRessarcimentoService;
import java.util.List;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/reembolsos"})
public class ReembolsoRessarcimentoResource {
    private final ReembolsoRessarcimentoService reembolsoRessarcimentoService;

    @GetMapping
    public ResponseEntity<Page<ReembolsoRessarcimentoDTO>> findAllReembolsos(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, ReembolsoRessarcimentoParams params, Pageable pageable) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.reembolsoRessarcimentoService.findReembolsosRessarcimentos(params, pageable));
    }

    @GetMapping(value={"/detail"})
    public ResponseEntity<ReembolsoRessarcimentoDTO> findReembolso(@RequestParam(value="reembolsoId") Long reembolsoId) {
        return ResponseEntity.ok((Object)this.reembolsoRessarcimentoService.findReembolsoRessarcimento(reembolsoId));
    }

    @GetMapping(value={"/arquivos"}, params={"reembolsoId"})
    public ResponseEntity<List<ArquivoPessoalDTO>> findArquivos(@RequestParam(value="reembolsoId") Long reembolsoId) {
        return ResponseEntity.ok((Object)this.reembolsoRessarcimentoService.findArquivos(reembolsoId));
    }

    @GetMapping(value={"/tipos-reembolso"})
    public ResponseEntity<List<TipoSolicitacaoReembolso>> getTiposReembolso() {
        return ResponseEntity.ok((Object)this.reembolsoRessarcimentoService.getTiposReembolso());
    }

    @Generated
    public ReembolsoRessarcimentoResource(ReembolsoRessarcimentoService reembolsoRessarcimentoService) {
        this.reembolsoRessarcimentoService = reembolsoRessarcimentoService;
    }
}

