/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository.impl;

import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeCustomRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class EntidadeContabilidadeRepositoryImpl
implements EntidadeContabilidadeCustomRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntidadeContabilidadeRepositoryImpl.class);
    private static final String TAMANHO_RECEITA = "db/sql/contab/tamanho-receita.sql";
    private final DatasourceWrapper datasourceWrapper;
    private static final int ORGAO = 1;
    private static final int UNIDADE = 2;

    @Autowired
    public EntidadeContabilidadeRepositoryImpl(DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    public Integer getTamanhoReceita(Long entidade, Long exercicio) {
        String sql = FileUtils.readResourceAsString((String)TAMANHO_RECEITA);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("entidade", (Object)entidade, 2);
        params.addValue("exercicio", (Object)exercicio, 2);
        LOGGER.debug(sql);
        return (Integer)this.datasourceWrapper.getJdbcTemplate().queryForObject(sql, (SqlParameterSource)params, Integer.class);
    }

    public String getUf(Long entidade) {
        String sql = "SELECT uf FROM ${db.contabilidade.schema}.entidade WHERE entidade = :entidade";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("entidade", (Object)entidade, 2);
        LOGGER.debug(sql);
        return (String)this.datasourceWrapper.getJdbcTemplate().queryForObject(sql, (SqlParameterSource)params, String.class);
    }

    public String getNomeFundo(Long entidade, Long exercicio, String orgao, String unidade) {
        String sql = "SELECT nomeentidade FROM ${db.contabilidade.schema}.parametrosfundo WHERE entidade = :entidade and exercicio = :exercicio and idtipofiltroparametrosfundo = :tipofiltrofundo and codigo = :orgaounidade";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("entidade", (Object)entidade, 2);
        params.addValue("exercicio", (Object)exercicio, 2);
        LOGGER.debug(sql);
        try {
            params.addValue("tipofiltrofundo", (Object)1, 2);
            params.addValue("orgaounidade", (Object)orgao, 12);
            return (String)this.datasourceWrapper.getJdbcTemplate().queryForObject(sql, (SqlParameterSource)params, String.class);
        }
        catch (EmptyResultDataAccessException e) {
            params.addValue("tipofiltrofundo", (Object)2, 2);
            params.addValue("orgaounidade", (Object)unidade, 12);
            return (String)this.datasourceWrapper.getJdbcTemplate().queryForObject(sql, (SqlParameterSource)params, String.class);
        }
    }

    public String getCNPJFundo(Long entidade, Long exercicio, String orgao, String unidade) {
        String sql = "SELECT cnpj FROM ${db.contabilidade.schema}.parametrosfundo WHERE entidade = :entidade and exercicio = :exercicio and idtipofiltroparametrosfundo = :tipofiltrofundo and codigo = :orgaounidade";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("entidade", (Object)entidade, 2);
        params.addValue("exercicio", (Object)exercicio, 2);
        LOGGER.debug(sql);
        try {
            params.addValue("tipofiltrofundo", (Object)1, 2);
            params.addValue("orgaounidade", (Object)orgao, 12);
            return (String)this.datasourceWrapper.getJdbcTemplate().queryForObject(sql, (SqlParameterSource)params, String.class);
        }
        catch (EmptyResultDataAccessException e) {
            params.addValue("tipofiltrofundo", (Object)2, 2);
            params.addValue("orgaounidade", (Object)unidade, 12);
            return (String)this.datasourceWrapper.getJdbcTemplate().queryForObject(sql, (SqlParameterSource)params, String.class);
        }
    }

    public String isHabilitadoAssinaturaPersonalizadaFundo(Long entidade, Long exercicio, String orgao, String unidade) {
        String sql = "SELECT personalizafundo FROM ${db.contabilidade.schema}.parametrosfundo WHERE entidade = :entidade and exercicio = :exercicio and idtipofiltroparametrosfundo = :tipofiltrofundo and codigo = :orgaounidade";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("entidade", (Object)entidade, 2);
        params.addValue("exercicio", (Object)exercicio, 2);
        LOGGER.debug(sql);
        try {
            params.addValue("tipofiltrofundo", (Object)1, 2);
            params.addValue("orgaounidade", (Object)orgao, 12);
            return (String)this.datasourceWrapper.getJdbcTemplate().queryForObject(sql, (SqlParameterSource)params, String.class);
        }
        catch (EmptyResultDataAccessException e) {
            try {
                params.addValue("tipofiltrofundo", (Object)2, 2);
                params.addValue("orgaounidade", (Object)unidade, 12);
                return (String)this.datasourceWrapper.getJdbcTemplate().queryForObject(sql, (SqlParameterSource)params, String.class);
            }
            catch (EmptyResultDataAccessException e1) {
                return "N";
            }
        }
    }
}

