/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.arquivoportal.service.ArquivoService;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.AcordoSemRecurso;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.AcordoSemRecursoDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.AcordoSemRecursoRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.AcordoSemRecursoParams;
import br.com.elotech.portaltransparencia.contabportal.service.ArquivoContabilService;
import br.com.elotech.portaltransparencia.contabportal.service.FornecedorService;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class AcordoSemRecursoRepositoryImpl
implements AcordoSemRecursoRepository {
    private final DatasourceWrapper datasourceWrapper;
    private final FornecedorService fornecedorService;
    private final ArquivoContabilService arquivoContabilService;
    private final ArquivoService arquivoService;
    private static final String SQL_ACORDOS = "db/sql/contab/acordo-sem-recursos-financeiros.sql";

    @Autowired
    public AcordoSemRecursoRepositoryImpl(DatasourceWrapper datasourceWrapper, FornecedorService fornecedorService, ArquivoContabilService arquivoContabilService, ArquivoService arquivoService) {
        this.datasourceWrapper = datasourceWrapper;
        this.fornecedorService = fornecedorService;
        this.arquivoContabilService = arquivoContabilService;
        this.arquivoService = arquivoService;
    }

    public Page<AcordoSemRecurso> findByParams(AcordoSemRecursoParams params, Pageable pageable) {
        String filtro = this.getFiltros(params);
        String sql = FileUtils.readResourceAsString((String)SQL_ACORDOS).replace("schema_eloarquivo", this.arquivoService.getNomeSchemaEloArquivo()) + filtro;
        String queryOrder = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)sql, (String)" ORDER BY E.NUMERO DESC ");
        sql = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)queryOrder, (String)this.datasourceWrapper.getPlatform());
        List acordosDTO = this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(AcordoSemRecursoDTO.class));
        List acordos = this.createListaAcordos(acordosDTO);
        return new PageImpl(acordos, pageable, this.getQuantidade(sql.toString(), params).longValue());
    }

    public AcordoSemRecurso findById(Long id) {
        StringBuilder filtro = new StringBuilder().append(" WHERE E.ID = ").append(id);
        String sql = FileUtils.readResourceAsString((String)SQL_ACORDOS).replace("schema_eloarquivo", this.arquivoService.getNomeSchemaEloArquivo()) + filtro;
        Optional acordoSemRecursoDTO = this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)new MapSqlParameterSource(), (RowMapper)new ElotechBeanPropertyRowMapper(AcordoSemRecursoDTO.class)).stream().findFirst();
        return acordoSemRecursoDTO.map(arg_0 -> this.createAcordo(arg_0)).orElse(null);
    }

    private List<AcordoSemRecurso> createListaAcordos(List<AcordoSemRecursoDTO> acordosDTO) {
        ArrayList<AcordoSemRecurso> listAcordo = new ArrayList<AcordoSemRecurso>();
        for (AcordoSemRecursoDTO acordoSemRecursoDTO : acordosDTO) {
            AcordoSemRecurso acordo = this.createAcordo(acordoSemRecursoDTO);
            listAcordo.add(acordo);
        }
        return listAcordo;
    }

    private AcordoSemRecurso createAcordo(AcordoSemRecursoDTO acordoSemRecursoDTO) {
        new AcordoSemRecurso();
        AcordoSemRecurso acordo = AcordoSemRecurso.builder().id(acordoSemRecursoDTO.getId()).entidade(acordoSemRecursoDTO.getEntidade()).exercicio(acordoSemRecursoDTO.getExercicio()).ano(acordoSemRecursoDTO.getAno()).numero(acordoSemRecursoDTO.getNumero()).tipo(acordoSemRecursoDTO.getTipo()).situacao(acordoSemRecursoDTO.getSituacao()).dataInicio(acordoSemRecursoDTO.getDataInicio()).dataTermino(acordoSemRecursoDTO.getDataTermino()).objeto(acordoSemRecursoDTO.getObjeto()).dataUltimaAtualizacao(acordoSemRecursoDTO.getDataUltimaAtualizacao()).nomeFornecedor(acordoSemRecursoDTO.getNomeFornecedor()).tamanhoArquivo(acordoSemRecursoDTO.getTamanhoArquivo()).build();
        if (Objects.nonNull(acordoSemRecursoDTO.getIdFornecedor()) && acordoSemRecursoDTO.getIdFornecedor() > 0L && Objects.nonNull(this.fornecedorService)) {
            acordo.setFornecedor(acordoSemRecursoDTO.getIdFornecedor());
        }
        if (Objects.nonNull(acordoSemRecursoDTO.getIdArquivo()) && acordoSemRecursoDTO.getIdArquivo() > 0L && Objects.nonNull(this.arquivoContabilService)) {
            acordo.setArquivo(this.arquivoContabilService.findOne(acordoSemRecursoDTO.getIdArquivo()));
            if (Objects.nonNull(acordo.getArquivo()) && Objects.nonNull(acordo.getArquivo().getEloArquivo().getId()) && Objects.nonNull(this.arquivoService)) {
                Long tamanhoArquivo = this.arquivoService.getTamanhoArquivo(acordo.getArquivo().getEloArquivo().getId());
                acordo.getArquivo().setTamanhoArquivo(tamanhoArquivo);
            }
        }
        return acordo;
    }

    private String getFiltros(AcordoSemRecursoParams params) {
        StringBuilder filtro = new StringBuilder();
        filtro.append(" WHERE 1 = 1 ");
        params.getId().ifPresent(i -> filtro.append(" AND E.ID = :id "));
        params.getEntidade().ifPresent(i -> filtro.append(" AND E.ENTIDADE = :entidade "));
        params.getExercicio().ifPresent(i -> filtro.append(" AND E.EXERCICIO = :exercicio "));
        params.getNumero().ifPresent(i -> filtro.append(" AND E.NUMERO = :numero "));
        params.getAno().ifPresent(i -> filtro.append(" AND E.ANO = :ano "));
        params.getNomeFornecedor().ifPresent(i -> filtro.append(" AND ${db.contabilidade.schema}.tiraacento(LOWER(F.NOME)) LIKE ${db.contabilidade.schema}.tiraacento(LOWER('%").append((String)params.getNomeFornecedor().get()).append("%')) "));
        params.getTipo().ifPresent(i -> filtro.append(" AND ${db.contabilidade.schema}.tiraacento(LOWER(E.TIPO)) LIKE ${db.contabilidade.schema}.tiraacento(LOWER('%").append((String)params.getTipo().get()).append("%')) "));
        params.getSituacao().ifPresent(i -> filtro.append(" AND ${db.contabilidade.schema}.tiraacento(LOWER(E.SITUACAO)) LIKE ${db.contabilidade.schema}.tiraacento(LOWER('%").append((String)params.getSituacao().get()).append("%')) "));
        params.getDataInicio().ifPresent(dataInicio -> filtro.append(" AND E.DATAINICIO >= :dataInicio"));
        params.getDataTermino().ifPresent(dataTermino -> filtro.append(" AND E.DATATERMINO <= :dataTermino"));
        params.getObjeto().ifPresent(i -> filtro.append(" AND ${db.contabilidade.schema}.tiraacento(LOWER(E.OBJETO)) LIKE ${db.contabilidade.schema}.tiraacento(LOWER('%").append((String)params.getObjeto().get()).append("%')) "));
        return filtro.toString();
    }

    private Long getQuantidade(String query, AcordoSemRecursoParams params) {
        StringBuilder queryCount = new StringBuilder("SELECT COUNT(*) FROM (").append(query).append(") COUNT");
        return (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(queryCount.toString(), (SqlParameterSource)params.toJdbcParameter(), Long.class);
    }
}

