/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository;

import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.EmpresaTerceirizadaFuncionario;
import br.com.elotech.portaltransparencia.contabportal.resource.params.EmpresaTerceirizadaFuncionarioParams;
import br.com.elotech.portaltransparencia.contabportal.utils.EmpresaTercerizadaRowMapper;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class EmpresaTerceirizadaFuncionarioRepository {
    private static final String EMPRESA_TERCEIRIZADA_FUNCIONARIO = "db/sql/contab/empresa-terceirizada-funcionario.sql";
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public EmpresaTerceirizadaFuncionarioRepository(DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    private Long getCount(EmpresaTerceirizadaFuncionarioParams params, String sql) {
        StringBuilder sqlCount = new StringBuilder();
        sqlCount.append("SELECT COUNT(*) AS TOTAL");
        sqlCount.append(" FROM (");
        sqlCount.append(sql);
        sqlCount.append(") X");
        return (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(sqlCount.toString(), (SqlParameterSource)params.toJdbcParameter(), Long.class);
    }

    public Page<EmpresaTerceirizadaFuncionario> findByEntidadeAndExercicio(Pageable pageable, String additionalSql, Long entidade, EmpresaTerceirizadaFuncionarioParams params) {
        String sqlFuncionario = FileUtils.readResourceAsString((String)EMPRESA_TERCEIRIZADA_FUNCIONARIO);
        Object filter = "AND ET.ENTIDADE = " + entidade;
        if (params.getDataInicial().isPresent()) {
            filter = ((String)filter).concat(" AND e.data >= :dataInicial ");
        }
        if (params.getDataFinal().isPresent()) {
            filter = ((String)filter).concat(" AND e.data <= :dataFinal ");
        }
        filter = ((String)filter).concat(additionalSql);
        sqlFuncionario = sqlFuncionario.replace("$[FILTRO]", (CharSequence)filter);
        String query = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)sqlFuncionario, (String)" ORDER BY E.ID");
        query = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)query, (String)this.datasourceWrapper.getPlatform());
        List list = this.datasourceWrapper.getJdbcTemplate().query(query, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new EmpresaTercerizadaRowMapper());
        return new PageImpl(list, pageable, this.getCount(params, sqlFuncionario).longValue());
    }
}

