/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.domain.dto;

import br.com.elotech.contabilidade.client.dto.DemonstrativoInterferenciaFinanceiraDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.RepasseRecebidoDTO;
import java.math.BigDecimal;
import lombok.Generated;

public class RepasseRecebidoDTO {
    private Long entidade;
    private Long exercicio;
    private BigDecimal valorLancado;
    private BigDecimal valorPrevistoReceberMensal;
    private BigDecimal valorDevolvido;
    private BigDecimal valorRecebido;
    private BigDecimal valorRestanteReceber;
    private BigDecimal valorAutorizadoMensal;
    private BigDecimal valorRestanteAutorizado;
    private Long mes;
    private BigDecimal valorRecebidoSobrePrevisto;
    private BigDecimal valorRecebidoSobreAutorizado;

    public static RepasseRecebidoDTO ofDemonstrativo(DemonstrativoInterferenciaFinanceiraDTO demonstrativo, String tipo) {
        RepasseRecebidoDTO repasseDTO = new RepasseRecebidoDTO();
        repasseDTO.setEntidade(demonstrativo.getIdEntidade());
        repasseDTO.setExercicio(demonstrativo.getExercicio());
        if (tipo.equals("R")) {
            repasseDTO.setValorLancado(demonstrativo.getIngresso().abs());
        } else {
            repasseDTO.setValorLancado(demonstrativo.getEgresso().abs());
        }
        return repasseDTO;
    }

    public BigDecimal getValorRecebidoSobrePrevisto() {
        if (this.valorPrevistoReceberMensal.compareTo(BigDecimal.ZERO) > 0) {
            return this.valorRestanteReceber.multiply(BigDecimal.valueOf(100L)).divide(this.valorPrevistoReceberMensal, 2);
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getValorRecebidoSobreAutorizado() {
        if (this.valorAutorizadoMensal.compareTo(BigDecimal.ZERO) > 0) {
            return this.valorRestanteAutorizado.multiply(BigDecimal.valueOf(100L)).divide(this.valorAutorizadoMensal, 2);
        }
        return BigDecimal.ZERO;
    }

    @Generated
    public static RepasseRecebidoDTOBuilder builder() {
        return new RepasseRecebidoDTOBuilder();
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public BigDecimal getValorLancado() {
        return this.valorLancado;
    }

    @Generated
    public BigDecimal getValorPrevistoReceberMensal() {
        return this.valorPrevistoReceberMensal;
    }

    @Generated
    public BigDecimal getValorDevolvido() {
        return this.valorDevolvido;
    }

    @Generated
    public BigDecimal getValorRecebido() {
        return this.valorRecebido;
    }

    @Generated
    public BigDecimal getValorRestanteReceber() {
        return this.valorRestanteReceber;
    }

    @Generated
    public BigDecimal getValorAutorizadoMensal() {
        return this.valorAutorizadoMensal;
    }

    @Generated
    public BigDecimal getValorRestanteAutorizado() {
        return this.valorRestanteAutorizado;
    }

    @Generated
    public Long getMes() {
        return this.mes;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setValorLancado(BigDecimal valorLancado) {
        this.valorLancado = valorLancado;
    }

    @Generated
    public void setValorPrevistoReceberMensal(BigDecimal valorPrevistoReceberMensal) {
        this.valorPrevistoReceberMensal = valorPrevistoReceberMensal;
    }

    @Generated
    public void setValorDevolvido(BigDecimal valorDevolvido) {
        this.valorDevolvido = valorDevolvido;
    }

    @Generated
    public void setValorRecebido(BigDecimal valorRecebido) {
        this.valorRecebido = valorRecebido;
    }

    @Generated
    public void setValorRestanteReceber(BigDecimal valorRestanteReceber) {
        this.valorRestanteReceber = valorRestanteReceber;
    }

    @Generated
    public void setValorAutorizadoMensal(BigDecimal valorAutorizadoMensal) {
        this.valorAutorizadoMensal = valorAutorizadoMensal;
    }

    @Generated
    public void setValorRestanteAutorizado(BigDecimal valorRestanteAutorizado) {
        this.valorRestanteAutorizado = valorRestanteAutorizado;
    }

    @Generated
    public void setMes(Long mes) {
        this.mes = mes;
    }

    @Generated
    public void setValorRecebidoSobrePrevisto(BigDecimal valorRecebidoSobrePrevisto) {
        this.valorRecebidoSobrePrevisto = valorRecebidoSobrePrevisto;
    }

    @Generated
    public void setValorRecebidoSobreAutorizado(BigDecimal valorRecebidoSobreAutorizado) {
        this.valorRecebidoSobreAutorizado = valorRecebidoSobreAutorizado;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RepasseRecebidoDTO)) {
            return false;
        }
        RepasseRecebidoDTO other = (RepasseRecebidoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$mes = this.getMes();
        Long other$mes = other.getMes();
        if (this$mes == null ? other$mes != null : !((Object)this$mes).equals(other$mes)) {
            return false;
        }
        BigDecimal this$valorLancado = this.getValorLancado();
        BigDecimal other$valorLancado = other.getValorLancado();
        if (this$valorLancado == null ? other$valorLancado != null : !((Object)this$valorLancado).equals(other$valorLancado)) {
            return false;
        }
        BigDecimal this$valorPrevistoReceberMensal = this.getValorPrevistoReceberMensal();
        BigDecimal other$valorPrevistoReceberMensal = other.getValorPrevistoReceberMensal();
        if (this$valorPrevistoReceberMensal == null ? other$valorPrevistoReceberMensal != null : !((Object)this$valorPrevistoReceberMensal).equals(other$valorPrevistoReceberMensal)) {
            return false;
        }
        BigDecimal this$valorDevolvido = this.getValorDevolvido();
        BigDecimal other$valorDevolvido = other.getValorDevolvido();
        if (this$valorDevolvido == null ? other$valorDevolvido != null : !((Object)this$valorDevolvido).equals(other$valorDevolvido)) {
            return false;
        }
        BigDecimal this$valorRecebido = this.getValorRecebido();
        BigDecimal other$valorRecebido = other.getValorRecebido();
        if (this$valorRecebido == null ? other$valorRecebido != null : !((Object)this$valorRecebido).equals(other$valorRecebido)) {
            return false;
        }
        BigDecimal this$valorRestanteReceber = this.getValorRestanteReceber();
        BigDecimal other$valorRestanteReceber = other.getValorRestanteReceber();
        if (this$valorRestanteReceber == null ? other$valorRestanteReceber != null : !((Object)this$valorRestanteReceber).equals(other$valorRestanteReceber)) {
            return false;
        }
        BigDecimal this$valorAutorizadoMensal = this.getValorAutorizadoMensal();
        BigDecimal other$valorAutorizadoMensal = other.getValorAutorizadoMensal();
        if (this$valorAutorizadoMensal == null ? other$valorAutorizadoMensal != null : !((Object)this$valorAutorizadoMensal).equals(other$valorAutorizadoMensal)) {
            return false;
        }
        BigDecimal this$valorRestanteAutorizado = this.getValorRestanteAutorizado();
        BigDecimal other$valorRestanteAutorizado = other.getValorRestanteAutorizado();
        if (this$valorRestanteAutorizado == null ? other$valorRestanteAutorizado != null : !((Object)this$valorRestanteAutorizado).equals(other$valorRestanteAutorizado)) {
            return false;
        }
        BigDecimal this$valorRecebidoSobrePrevisto = this.getValorRecebidoSobrePrevisto();
        BigDecimal other$valorRecebidoSobrePrevisto = other.getValorRecebidoSobrePrevisto();
        if (this$valorRecebidoSobrePrevisto == null ? other$valorRecebidoSobrePrevisto != null : !((Object)this$valorRecebidoSobrePrevisto).equals(other$valorRecebidoSobrePrevisto)) {
            return false;
        }
        BigDecimal this$valorRecebidoSobreAutorizado = this.getValorRecebidoSobreAutorizado();
        BigDecimal other$valorRecebidoSobreAutorizado = other.getValorRecebidoSobreAutorizado();
        return !(this$valorRecebidoSobreAutorizado == null ? other$valorRecebidoSobreAutorizado != null : !((Object)this$valorRecebidoSobreAutorizado).equals(other$valorRecebidoSobreAutorizado));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RepasseRecebidoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $mes = this.getMes();
        result = result * 59 + ($mes == null ? 43 : ((Object)$mes).hashCode());
        BigDecimal $valorLancado = this.getValorLancado();
        result = result * 59 + ($valorLancado == null ? 43 : ((Object)$valorLancado).hashCode());
        BigDecimal $valorPrevistoReceberMensal = this.getValorPrevistoReceberMensal();
        result = result * 59 + ($valorPrevistoReceberMensal == null ? 43 : ((Object)$valorPrevistoReceberMensal).hashCode());
        BigDecimal $valorDevolvido = this.getValorDevolvido();
        result = result * 59 + ($valorDevolvido == null ? 43 : ((Object)$valorDevolvido).hashCode());
        BigDecimal $valorRecebido = this.getValorRecebido();
        result = result * 59 + ($valorRecebido == null ? 43 : ((Object)$valorRecebido).hashCode());
        BigDecimal $valorRestanteReceber = this.getValorRestanteReceber();
        result = result * 59 + ($valorRestanteReceber == null ? 43 : ((Object)$valorRestanteReceber).hashCode());
        BigDecimal $valorAutorizadoMensal = this.getValorAutorizadoMensal();
        result = result * 59 + ($valorAutorizadoMensal == null ? 43 : ((Object)$valorAutorizadoMensal).hashCode());
        BigDecimal $valorRestanteAutorizado = this.getValorRestanteAutorizado();
        result = result * 59 + ($valorRestanteAutorizado == null ? 43 : ((Object)$valorRestanteAutorizado).hashCode());
        BigDecimal $valorRecebidoSobrePrevisto = this.getValorRecebidoSobrePrevisto();
        result = result * 59 + ($valorRecebidoSobrePrevisto == null ? 43 : ((Object)$valorRecebidoSobrePrevisto).hashCode());
        BigDecimal $valorRecebidoSobreAutorizado = this.getValorRecebidoSobreAutorizado();
        result = result * 59 + ($valorRecebidoSobreAutorizado == null ? 43 : ((Object)$valorRecebidoSobreAutorizado).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RepasseRecebidoDTO(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", valorLancado=" + String.valueOf(this.getValorLancado()) + ", valorPrevistoReceberMensal=" + String.valueOf(this.getValorPrevistoReceberMensal()) + ", valorDevolvido=" + String.valueOf(this.getValorDevolvido()) + ", valorRecebido=" + String.valueOf(this.getValorRecebido()) + ", valorRestanteReceber=" + String.valueOf(this.getValorRestanteReceber()) + ", valorAutorizadoMensal=" + String.valueOf(this.getValorAutorizadoMensal()) + ", valorRestanteAutorizado=" + String.valueOf(this.getValorRestanteAutorizado()) + ", mes=" + this.getMes() + ", valorRecebidoSobrePrevisto=" + String.valueOf(this.getValorRecebidoSobrePrevisto()) + ", valorRecebidoSobreAutorizado=" + String.valueOf(this.getValorRecebidoSobreAutorizado()) + ")";
    }

    @Generated
    public RepasseRecebidoDTO() {
    }

    @Generated
    public RepasseRecebidoDTO(Long entidade, Long exercicio, BigDecimal valorLancado, BigDecimal valorPrevistoReceberMensal, BigDecimal valorDevolvido, BigDecimal valorRecebido, BigDecimal valorRestanteReceber, BigDecimal valorAutorizadoMensal, BigDecimal valorRestanteAutorizado, Long mes, BigDecimal valorRecebidoSobrePrevisto, BigDecimal valorRecebidoSobreAutorizado) {
        this.entidade = entidade;
        this.exercicio = exercicio;
        this.valorLancado = valorLancado;
        this.valorPrevistoReceberMensal = valorPrevistoReceberMensal;
        this.valorDevolvido = valorDevolvido;
        this.valorRecebido = valorRecebido;
        this.valorRestanteReceber = valorRestanteReceber;
        this.valorAutorizadoMensal = valorAutorizadoMensal;
        this.valorRestanteAutorizado = valorRestanteAutorizado;
        this.mes = mes;
        this.valorRecebidoSobrePrevisto = valorRecebidoSobrePrevisto;
        this.valorRecebidoSobreAutorizado = valorRecebidoSobreAutorizado;
    }
}

