/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.domain.dto;

import br.com.elotech.contabilidade.client.dto.CidadeDTO;
import br.com.elotech.contabilidade.client.dto.PessoaDTO;
import br.com.elotech.contabilidade.client.dto.ReembolsoMovimentacaoDTO;
import br.com.elotech.orcamento.utils.MaskUtils;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ReembolsoRessarcimentoDTO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public class ReembolsoRessarcimentoDTO {
    private Long reembolsoId;
    private Long entidade;
    private Long exercicio;
    private Long numeroSolicitacao;
    private String tipoSolicitacao;
    private LocalDate dataSolicitacao;
    private String servidor;
    private String cargo;
    private String matricula;
    private String dotacao;
    private BigDecimal valor;
    private String empresaFornecedora;
    private String cnpjCpfEmpressaFornecedora;
    private LocalDate dataSaida;
    private LocalDate dataRetorno;
    private String destino;
    private String transporte;
    private String justificativa;

    public static ReembolsoRessarcimentoDTO fromReembolsoMovimentacaoDTO(ReembolsoMovimentacaoDTO reembolsoMovimentacaoDTO) {
        ReembolsoRessarcimentoDTO dto = new ReembolsoRessarcimentoDTO();
        PessoaDTO servidor = reembolsoMovimentacaoDTO.getServidor();
        PessoaDTO empresaFornecedora = reembolsoMovimentacaoDTO.getEmpresaFornecedora();
        if (Objects.nonNull(empresaFornecedora)) {
            dto.setEmpresaFornecedora(String.format("%s - %s", empresaFornecedora.getId(), empresaFornecedora.getNome()));
            dto.setCnpjCpfEmpressaFornecedora(MaskUtils.formataCnpjCpf((String)empresaFornecedora.getCnpjCpf()));
        }
        dto.setEntidade(reembolsoMovimentacaoDTO.getExercicio().getEntidade().getId());
        dto.setExercicio(reembolsoMovimentacaoDTO.getExercicio().getExercicio());
        dto.setReembolsoId(reembolsoMovimentacaoDTO.getId());
        dto.setNumeroSolicitacao(reembolsoMovimentacaoDTO.getNumeroSolicitacao());
        dto.setTipoSolicitacao(reembolsoMovimentacaoDTO.getTipoSolicitacao().getDescricao());
        dto.setDataSolicitacao(reembolsoMovimentacaoDTO.getDataSolicitacao());
        dto.setServidor(servidor.getNome());
        dto.setCargo(servidor.getCargo());
        dto.setMatricula(servidor.getMatricula());
        dto.setDotacao(Optional.ofNullable(reembolsoMovimentacaoDTO.getDotacao()).map(dotacao -> String.format("%s - %s", dotacao.getCodigoFormatted(), dotacao.getDescricao())).orElse(""));
        dto.setValor(reembolsoMovimentacaoDTO.getValor());
        dto.setDataSaida(reembolsoMovimentacaoDTO.getDataInicio());
        dto.setDataRetorno(reembolsoMovimentacaoDTO.getDataFim());
        dto.setDestino(Optional.ofNullable(reembolsoMovimentacaoDTO.getDestinoViagem()).map(CidadeDTO::getDescricao).orElse(""));
        dto.setTransporte(reembolsoMovimentacaoDTO.getMeioTransporte());
        dto.setJustificativa(reembolsoMovimentacaoDTO.getJustificativa());
        return dto;
    }

    @Generated
    public static ReembolsoRessarcimentoDTOBuilder builder() {
        return new ReembolsoRessarcimentoDTOBuilder();
    }

    @Generated
    public Long getReembolsoId() {
        return this.reembolsoId;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getNumeroSolicitacao() {
        return this.numeroSolicitacao;
    }

    @Generated
    public String getTipoSolicitacao() {
        return this.tipoSolicitacao;
    }

    @Generated
    public LocalDate getDataSolicitacao() {
        return this.dataSolicitacao;
    }

    @Generated
    public String getServidor() {
        return this.servidor;
    }

    @Generated
    public String getCargo() {
        return this.cargo;
    }

    @Generated
    public String getMatricula() {
        return this.matricula;
    }

    @Generated
    public String getDotacao() {
        return this.dotacao;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public String getEmpresaFornecedora() {
        return this.empresaFornecedora;
    }

    @Generated
    public String getCnpjCpfEmpressaFornecedora() {
        return this.cnpjCpfEmpressaFornecedora;
    }

    @Generated
    public LocalDate getDataSaida() {
        return this.dataSaida;
    }

    @Generated
    public LocalDate getDataRetorno() {
        return this.dataRetorno;
    }

    @Generated
    public String getDestino() {
        return this.destino;
    }

    @Generated
    public String getTransporte() {
        return this.transporte;
    }

    @Generated
    public String getJustificativa() {
        return this.justificativa;
    }

    @Generated
    public void setReembolsoId(Long reembolsoId) {
        this.reembolsoId = reembolsoId;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setNumeroSolicitacao(Long numeroSolicitacao) {
        this.numeroSolicitacao = numeroSolicitacao;
    }

    @Generated
    public void setTipoSolicitacao(String tipoSolicitacao) {
        this.tipoSolicitacao = tipoSolicitacao;
    }

    @Generated
    public void setDataSolicitacao(LocalDate dataSolicitacao) {
        this.dataSolicitacao = dataSolicitacao;
    }

    @Generated
    public void setServidor(String servidor) {
        this.servidor = servidor;
    }

    @Generated
    public void setCargo(String cargo) {
        this.cargo = cargo;
    }

    @Generated
    public void setMatricula(String matricula) {
        this.matricula = matricula;
    }

    @Generated
    public void setDotacao(String dotacao) {
        this.dotacao = dotacao;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setEmpresaFornecedora(String empresaFornecedora) {
        this.empresaFornecedora = empresaFornecedora;
    }

    @Generated
    public void setCnpjCpfEmpressaFornecedora(String cnpjCpfEmpressaFornecedora) {
        this.cnpjCpfEmpressaFornecedora = cnpjCpfEmpressaFornecedora;
    }

    @Generated
    public void setDataSaida(LocalDate dataSaida) {
        this.dataSaida = dataSaida;
    }

    @Generated
    public void setDataRetorno(LocalDate dataRetorno) {
        this.dataRetorno = dataRetorno;
    }

    @Generated
    public void setDestino(String destino) {
        this.destino = destino;
    }

    @Generated
    public void setTransporte(String transporte) {
        this.transporte = transporte;
    }

    @Generated
    public void setJustificativa(String justificativa) {
        this.justificativa = justificativa;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReembolsoRessarcimentoDTO)) {
            return false;
        }
        ReembolsoRessarcimentoDTO other = (ReembolsoRessarcimentoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$reembolsoId = this.getReembolsoId();
        Long other$reembolsoId = other.getReembolsoId();
        if (this$reembolsoId == null ? other$reembolsoId != null : !((Object)this$reembolsoId).equals(other$reembolsoId)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$numeroSolicitacao = this.getNumeroSolicitacao();
        Long other$numeroSolicitacao = other.getNumeroSolicitacao();
        if (this$numeroSolicitacao == null ? other$numeroSolicitacao != null : !((Object)this$numeroSolicitacao).equals(other$numeroSolicitacao)) {
            return false;
        }
        String this$tipoSolicitacao = this.getTipoSolicitacao();
        String other$tipoSolicitacao = other.getTipoSolicitacao();
        if (this$tipoSolicitacao == null ? other$tipoSolicitacao != null : !this$tipoSolicitacao.equals(other$tipoSolicitacao)) {
            return false;
        }
        LocalDate this$dataSolicitacao = this.getDataSolicitacao();
        LocalDate other$dataSolicitacao = other.getDataSolicitacao();
        if (this$dataSolicitacao == null ? other$dataSolicitacao != null : !((Object)this$dataSolicitacao).equals(other$dataSolicitacao)) {
            return false;
        }
        String this$servidor = this.getServidor();
        String other$servidor = other.getServidor();
        if (this$servidor == null ? other$servidor != null : !this$servidor.equals(other$servidor)) {
            return false;
        }
        String this$cargo = this.getCargo();
        String other$cargo = other.getCargo();
        if (this$cargo == null ? other$cargo != null : !this$cargo.equals(other$cargo)) {
            return false;
        }
        String this$matricula = this.getMatricula();
        String other$matricula = other.getMatricula();
        if (this$matricula == null ? other$matricula != null : !this$matricula.equals(other$matricula)) {
            return false;
        }
        String this$dotacao = this.getDotacao();
        String other$dotacao = other.getDotacao();
        if (this$dotacao == null ? other$dotacao != null : !this$dotacao.equals(other$dotacao)) {
            return false;
        }
        BigDecimal this$valor = this.getValor();
        BigDecimal other$valor = other.getValor();
        if (this$valor == null ? other$valor != null : !((Object)this$valor).equals(other$valor)) {
            return false;
        }
        String this$empresaFornecedora = this.getEmpresaFornecedora();
        String other$empresaFornecedora = other.getEmpresaFornecedora();
        if (this$empresaFornecedora == null ? other$empresaFornecedora != null : !this$empresaFornecedora.equals(other$empresaFornecedora)) {
            return false;
        }
        String this$cnpjCpfEmpressaFornecedora = this.getCnpjCpfEmpressaFornecedora();
        String other$cnpjCpfEmpressaFornecedora = other.getCnpjCpfEmpressaFornecedora();
        if (this$cnpjCpfEmpressaFornecedora == null ? other$cnpjCpfEmpressaFornecedora != null : !this$cnpjCpfEmpressaFornecedora.equals(other$cnpjCpfEmpressaFornecedora)) {
            return false;
        }
        LocalDate this$dataSaida = this.getDataSaida();
        LocalDate other$dataSaida = other.getDataSaida();
        if (this$dataSaida == null ? other$dataSaida != null : !((Object)this$dataSaida).equals(other$dataSaida)) {
            return false;
        }
        LocalDate this$dataRetorno = this.getDataRetorno();
        LocalDate other$dataRetorno = other.getDataRetorno();
        if (this$dataRetorno == null ? other$dataRetorno != null : !((Object)this$dataRetorno).equals(other$dataRetorno)) {
            return false;
        }
        String this$destino = this.getDestino();
        String other$destino = other.getDestino();
        if (this$destino == null ? other$destino != null : !this$destino.equals(other$destino)) {
            return false;
        }
        String this$transporte = this.getTransporte();
        String other$transporte = other.getTransporte();
        if (this$transporte == null ? other$transporte != null : !this$transporte.equals(other$transporte)) {
            return false;
        }
        String this$justificativa = this.getJustificativa();
        String other$justificativa = other.getJustificativa();
        return !(this$justificativa == null ? other$justificativa != null : !this$justificativa.equals(other$justificativa));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReembolsoRessarcimentoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $reembolsoId = this.getReembolsoId();
        result = result * 59 + ($reembolsoId == null ? 43 : ((Object)$reembolsoId).hashCode());
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $numeroSolicitacao = this.getNumeroSolicitacao();
        result = result * 59 + ($numeroSolicitacao == null ? 43 : ((Object)$numeroSolicitacao).hashCode());
        String $tipoSolicitacao = this.getTipoSolicitacao();
        result = result * 59 + ($tipoSolicitacao == null ? 43 : $tipoSolicitacao.hashCode());
        LocalDate $dataSolicitacao = this.getDataSolicitacao();
        result = result * 59 + ($dataSolicitacao == null ? 43 : ((Object)$dataSolicitacao).hashCode());
        String $servidor = this.getServidor();
        result = result * 59 + ($servidor == null ? 43 : $servidor.hashCode());
        String $cargo = this.getCargo();
        result = result * 59 + ($cargo == null ? 43 : $cargo.hashCode());
        String $matricula = this.getMatricula();
        result = result * 59 + ($matricula == null ? 43 : $matricula.hashCode());
        String $dotacao = this.getDotacao();
        result = result * 59 + ($dotacao == null ? 43 : $dotacao.hashCode());
        BigDecimal $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : ((Object)$valor).hashCode());
        String $empresaFornecedora = this.getEmpresaFornecedora();
        result = result * 59 + ($empresaFornecedora == null ? 43 : $empresaFornecedora.hashCode());
        String $cnpjCpfEmpressaFornecedora = this.getCnpjCpfEmpressaFornecedora();
        result = result * 59 + ($cnpjCpfEmpressaFornecedora == null ? 43 : $cnpjCpfEmpressaFornecedora.hashCode());
        LocalDate $dataSaida = this.getDataSaida();
        result = result * 59 + ($dataSaida == null ? 43 : ((Object)$dataSaida).hashCode());
        LocalDate $dataRetorno = this.getDataRetorno();
        result = result * 59 + ($dataRetorno == null ? 43 : ((Object)$dataRetorno).hashCode());
        String $destino = this.getDestino();
        result = result * 59 + ($destino == null ? 43 : $destino.hashCode());
        String $transporte = this.getTransporte();
        result = result * 59 + ($transporte == null ? 43 : $transporte.hashCode());
        String $justificativa = this.getJustificativa();
        result = result * 59 + ($justificativa == null ? 43 : $justificativa.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ReembolsoRessarcimentoDTO(reembolsoId=" + this.getReembolsoId() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", numeroSolicitacao=" + this.getNumeroSolicitacao() + ", tipoSolicitacao=" + this.getTipoSolicitacao() + ", dataSolicitacao=" + String.valueOf(this.getDataSolicitacao()) + ", servidor=" + this.getServidor() + ", cargo=" + this.getCargo() + ", matricula=" + this.getMatricula() + ", dotacao=" + this.getDotacao() + ", valor=" + String.valueOf(this.getValor()) + ", empresaFornecedora=" + this.getEmpresaFornecedora() + ", cnpjCpfEmpressaFornecedora=" + this.getCnpjCpfEmpressaFornecedora() + ", dataSaida=" + String.valueOf(this.getDataSaida()) + ", dataRetorno=" + String.valueOf(this.getDataRetorno()) + ", destino=" + this.getDestino() + ", transporte=" + this.getTransporte() + ", justificativa=" + this.getJustificativa() + ")";
    }

    @Generated
    public ReembolsoRessarcimentoDTO(Long reembolsoId, Long entidade, Long exercicio, Long numeroSolicitacao, String tipoSolicitacao, LocalDate dataSolicitacao, String servidor, String cargo, String matricula, String dotacao, BigDecimal valor, String empresaFornecedora, String cnpjCpfEmpressaFornecedora, LocalDate dataSaida, LocalDate dataRetorno, String destino, String transporte, String justificativa) {
        this.reembolsoId = reembolsoId;
        this.entidade = entidade;
        this.exercicio = exercicio;
        this.numeroSolicitacao = numeroSolicitacao;
        this.tipoSolicitacao = tipoSolicitacao;
        this.dataSolicitacao = dataSolicitacao;
        this.servidor = servidor;
        this.cargo = cargo;
        this.matricula = matricula;
        this.dotacao = dotacao;
        this.valor = valor;
        this.empresaFornecedora = empresaFornecedora;
        this.cnpjCpfEmpressaFornecedora = cnpjCpfEmpressaFornecedora;
        this.dataSaida = dataSaida;
        this.dataRetorno = dataRetorno;
        this.destino = destino;
        this.transporte = transporte;
        this.justificativa = justificativa;
    }

    @Generated
    public ReembolsoRessarcimentoDTO() {
    }
}

