/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.config;

import java.io.IOException;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.spi.CachingProvider;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.boot.autoconfigure.cache.CacheProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.jcache.JCacheCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Profile;
import org.springframework.core.io.Resource;

@Configuration
@EnableCaching
@Profile(value={"!test"})
@EnableConfigurationProperties(value={CacheProperties.class})
public class CacheConfiguration
implements BeanClassLoaderAware {
    private ClassLoader beanClassLoader;

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    @Bean
    @Primary
    public JCacheCacheManager cacheManager(CacheProperties cacheProperties) throws IOException {
        return new JCacheCacheManager(this.jCacheCacheManager(cacheProperties));
    }

    public CacheManager jCacheCacheManager(CacheProperties cacheProperties) throws IOException {
        CachingProvider cachingProvider = Caching.getCachingProvider((String)cacheProperties.getJcache().getProvider());
        Resource configLocation = cacheProperties.resolveConfigLocation(cacheProperties.getJcache().getConfig());
        return cachingProvider.getCacheManager(configLocation.getURI(), this.beanClassLoader);
    }
}

