/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.config;

import br.com.elotech.multitenant.context.HeaderContextHolder;
import br.com.elotech.portaltransparencia.admportal.domain.LogAcesso;
import br.com.elotech.portaltransparencia.admportal.service.LogAcessoService;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
@Profile(value={"cloud"})
public class AccessLogFilter
extends OncePerRequestFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AccessLogFilter.class);
    private final LogAcessoService service;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String entidade = request.getHeader("entidade");
        String exercicio = request.getHeader("exercicio");
        String rota = request.getHeader("ACTIVE_VIEW");
        String remoteAddress = HeaderContextHolder.getRemoteAddress();
        String requestURI = request.getHeader("location_search");
        if (StringUtils.isNotBlank((CharSequence)entidade) && StringUtils.isNotBlank((CharSequence)exercicio) && StringUtils.isNotBlank((CharSequence)rota) && !"/".equals(rota) && !rota.startsWith("/admin")) {
            try {
                log.debug("Request from {} - entidade: {} exercicio: {} rota: {} requestURI: {}", new Object[]{remoteAddress, entidade, exercicio, rota, requestURI});
                LogAcesso logAcesso = new LogAcesso();
                logAcesso.setEntidade(Long.valueOf(Long.parseLong(entidade)));
                logAcesso.setExercicio(Long.valueOf(Long.parseLong(exercicio)));
                logAcesso.setRota(rota);
                logAcesso.setIpaddress(remoteAddress);
                logAcesso.setDataHora(LocalDateTime.now().truncatedTo(ChronoUnit.MINUTES));
                this.service.insertIfNotExists(logAcesso, requestURI);
            }
            catch (Exception e) {
                log.error("Erro ao gravar log de acesso: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    @Generated
    public AccessLogFilter(LogAcessoService service) {
        this.service = service;
    }
}

