/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.domain;

import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.portaltransparencia.arquivoportal.domain.Arquivo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.Generated;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

@Entity
@Table(name="apice.ARQUIVO")
public class ArquivoCompras
implements EloEntity<Long> {
    @Id
    private Long id;
    private String nomeArquivo;
    private LocalDate data;
    private String usuario;
    private String tela;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean arquivoSigiloso = Boolean.FALSE;
    @OneToOne
    @JoinColumn(name="idArquivo", referencedColumnName="id")
    @JsonIgnore
    @NotFound(action=NotFoundAction.IGNORE)
    private Arquivo arquivo;
    @Transient
    private Long tamanhoArquivo;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setNomeArquivo(String nomeArquivo) {
        this.nomeArquivo = nomeArquivo;
    }

    public LocalDate getData() {
        return this.data;
    }

    public void setData(LocalDate data) {
        this.data = data;
    }

    public String getUsuario() {
        return this.usuario;
    }

    public void setUsuario(String usurio) {
        this.usuario = usurio;
    }

    public String getTela() {
        return this.tela;
    }

    public void setTela(String tela) {
        this.tela = tela;
    }

    public Boolean getArquivoSigiloso() {
        return this.arquivoSigiloso;
    }

    public void setArquivoSigiloso(Boolean arquivoSigiloso) {
        this.arquivoSigiloso = arquivoSigiloso;
    }

    public Arquivo getArquivo() {
        return this.arquivo;
    }

    public void setArquivo(Arquivo arquivo) {
        this.arquivo = arquivo;
    }

    public String getNomeArquivo() {
        if (Objects.nonNull(this.arquivo)) {
            return this.arquivo.getNome();
        }
        if (!Strings.isNullOrEmpty((String)this.nomeArquivo)) {
            return this.nomeArquivo;
        }
        return null;
    }

    @JsonProperty
    public Long getIdArquivo() {
        if (Objects.nonNull(this.arquivo)) {
            return this.arquivo.getId();
        }
        return null;
    }

    public Long getTamanhoArquivo() {
        return this.tamanhoArquivo;
    }

    public void setTamanhoArquivo(Long tamanhoArquivo) {
        this.tamanhoArquivo = tamanhoArquivo;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArquivoCompras)) {
            return false;
        }
        ArquivoCompras other = (ArquivoCompras)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ArquivoCompras;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ArquivoCompras(id=" + this.getId() + ", nomeArquivo=" + this.getNomeArquivo() + ", data=" + String.valueOf(this.getData()) + ", usuario=" + this.getUsuario() + ", tela=" + this.getTela() + ", arquivoSigiloso=" + this.getArquivoSigiloso() + ", arquivo=" + String.valueOf(this.getArquivo()) + ", tamanhoArquivo=" + this.getTamanhoArquivo() + ")";
    }
}

