/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.arquivoportal.service;

import br.com.elotech.core.config.DBConfigProperties;
import br.com.elotech.portaltransparencia.arquivoportal.domain.Arquivo;
import br.com.elotech.portaltransparencia.arquivoportal.domain.ArquivoInterface;
import br.com.elotech.portaltransparencia.arquivoportal.repository.EloArquivoRepository;
import br.com.elotech.portaltransparencia.arquivoportal.service.FindArquivoServiceInt;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ArquivoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ArquivoService.class);
    public static final String SCHEMA_ELOARQUIVO = "schema_eloarquivo";
    private final EloArquivoRepository arquivoRepository;
    private final DBConfigProperties dbConfigProperties;
    private final FindArquivoServiceInt findArquivoService;

    @Autowired
    public ArquivoService(EloArquivoRepository arquivoRepository, DBConfigProperties dbConfigProperties, FindArquivoServiceInt findArquivoService) {
        this.arquivoRepository = arquivoRepository;
        this.dbConfigProperties = dbConfigProperties;
        this.findArquivoService = findArquivoService;
    }

    public ArquivoInterface getArquivoInterface(Long id) {
        return this.arquivoRepository.findByIdProjection(id);
    }

    public Long getTamanhoArquivo(Long id) {
        return this.arquivoRepository.getTamanhoArquivo(id);
    }

    public String getNomeSchemaEloArquivo() {
        if (Objects.nonNull(this.dbConfigProperties.getEloarquivo()) && StringUtils.isNotBlank((String)this.dbConfigProperties.getEloarquivo().getSchema())) {
            return this.dbConfigProperties.getEloarquivo().getSchema();
        }
        return "ELOARQUIVO";
    }

    public Arquivo save(Arquivo arquivo) {
        return (Arquivo)this.arquivoRepository.save((Object)arquivo);
    }

    public void remove(Long id) {
        this.arquivoRepository.deleteById((Object)id);
    }

    public Arquivo findOne(Long id) {
        return this.findArquivoService.findOne(id);
    }

    public void downloadArquivo(HttpServletResponse response, Long id) {
        try {
            this.findArquivoService.downloadArquivo(response, id);
        }
        catch (ClientAbortException e) {
            log.debug("Cliente cancelou a requisi\u00e7\u00e3o", (Throwable)e);
        }
    }

    @Transactional(readOnly=true)
    public String getNomeArquivo(Long id) {
        return this.findArquivoService.getArquivoNome(id);
    }
}

