/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.service.impl;

import br.com.elotech.core.utils.StringUtils;
import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.service.PortalParametroService;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.EstagiarioDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter.EstagiarioDTOConverter;
import br.com.elotech.portaltransparencia.aiseportal.repository.EstagiarioRepository;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.AiseParams;
import br.com.elotech.portaltransparencia.aiseportal.service.EntidadeAiseService;
import br.com.elotech.portaltransparencia.aiseportal.service.EstagiarioService;
import br.com.elotech.portaltransparencia.aiseportal.service.IntegracaoAiseOxyFolhaPagamentoService;
import br.com.elotech.portaltransparencia.aiseportal.service.ServidorService;
import br.com.elotech.portaltransparencia.aiseportal.ws.service.ServidorServiceWS;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.portaltransparencia.folhaportal.service.EstagiarioServiceOxy;
import br.com.elotech.portaltransparencia.web.rest.params.ServidorParams;
import br.com.elotech.reportexport.exporter.BaseExport;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class EstagiarioServiceImpl
implements EstagiarioService {
    private static final long ENTIDADE_ESTAGIARIOS_PREFEITURA_MARINGA = 2L;
    private static final String headerFields = "Nome,Matr\u00edcula,Cargo,Lota\u00e7\u00e3o,In\u00edcio de Contrato,T\u00e9rmino de Contrato";
    private static final String fields = "nome,codigo,cargo,lotacao,inicioContrato,terminoContrato";
    private final EstagiarioRepository estagiarioRepository;
    private final PortalParametroService portalParametroService;
    private final IntegracaoAiseOxyFolhaPagamentoService integracaoAiseOxyService;
    private final EstagiarioServiceOxy serviceOxy;
    private final EntidadeAiseService entidadeAiseService;
    private final EntidadeContabilidadeRepository entidadeRepository;
    private final ServidorServiceWS servidorServiceWS;
    private final ServidorService servidorService;
    private final BaseExport baseExport;

    public Page<EstagiarioDTO> loadEstagiarios(ServidorParams params, Pageable pageable) {
        if (this.integracaoAiseOxyService.isParametroHabilitado(params.getEntidade(), params.getExercicio())) {
            this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
            return this.serviceOxy.loadEstagiarios(params, pageable);
        }
        if (this.utilizaWebService()) {
            params.setEntidade(Long.valueOf(2L));
            List estagiarios = this.servidorServiceWS.getEstagiarios(params);
            if (!estagiarios.isEmpty() && this.hasFiltroInformado(params)) {
                estagiarios = estagiarios.stream().filter(s -> this.possuiPalavraChave(s, params)).collect(Collectors.toList());
            }
            if (!estagiarios.isEmpty()) {
                return new PageImpl(estagiarios.stream().skip((long)pageable.getPageNumber() * (long)pageable.getPageSize()).limit(pageable.getPageSize()).collect(Collectors.toList()), pageable, (long)estagiarios.size());
            }
            return new PageImpl(new ArrayList());
        }
        return this.estagiarioRepository.loadEstagiarios(params, pageable);
    }

    public Optional<EstagiarioDTO> loadEstagiario(ServidorParams params) {
        if (this.integracaoAiseOxyService.isParametroHabilitado(params.getEntidade(), params.getExercicio())) {
            this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
            return this.serviceOxy.loadEstagiario(params);
        }
        if (this.utilizaWebService()) {
            Optional servidorDTO = this.servidorService.loadServidor(params);
            return Optional.of(EstagiarioDTOConverter.ServidorDTOToEstagiarioDTO((ServidorDTO)((ServidorDTO)servidorDTO.get())));
        }
        Optional estagiario = this.estagiarioRepository.loadEstagiario(params);
        estagiario.ifPresent(e -> e.setDadosFinanceiros(this.estagiarioRepository.loadDadosFinanceiros(params)));
        return estagiario;
    }

    public boolean utilizaWebService() {
        String parametro = this.portalParametroService.getPortalParametroValor(Parametros.NAO_DEPENDE_ENTIDADE, Parametros.NAO_DEPENDE_EXERCICIO, Parametros.PARAM_WEBSERVICE_MARINGA);
        return "1".equals(parametro);
    }

    public String findNomeEntidadeById(Long entidadeId) {
        Entidade entidade = (Entidade)this.entidadeRepository.findOne((Object)entidadeId);
        return Objects.nonNull(entidade) ? entidade.getNome() : "";
    }

    public String headerFields() {
        return headerFields;
    }

    public String fields() {
        return fields;
    }

    public float[] fieldsPerc() {
        return new float[]{1.5f, 0.8f, 1.5f, 1.5f, 0.8f, 0.8f};
    }

    public int[] fieldTab() {
        return new int[]{100, 50, 100, 100, 50, 50};
    }

    private boolean hasFiltroInformado(ServidorParams params) {
        return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)params.getNomeServidor()) || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)params.getSituacao()) || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)params.getCargo()) || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)params.getLotacao()) || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)params.getDescricaoNatureza()) || Objects.nonNull(params.getValorSalarioInicial()) || Objects.nonNull(params.getValorSalarioFinal()) || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)params.getVinculo());
    }

    private boolean possuiPalavraChave(EstagiarioDTO estagiario, ServidorParams params) {
        return this.containsFilterEmCampo(params.getNomeServidor(), estagiario.getNome()) && this.containsFilterEmCampo(params.getSituacao(), estagiario.getSituacao()) && this.containsFilterEmCampo(params.getCargo(), estagiario.getDescricaoCargo()) && this.containsFilterEmCampo(params.getLotacao(), estagiario.getDescricaoLotacao()) && this.containsFilterEmCampo(params.getDescricaoNatureza(), estagiario.getDescricaoNatureza()) && this.containsFilterEmCampo(params.getVinculo(), estagiario.getVinculo());
    }

    private boolean containsFilterEmCampo(String filter, String campo) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)filter)) {
            return StringUtils.retiraAcentos((String)campo.toUpperCase(Locale.getDefault())).contains(StringUtils.retiraAcentos((String)filter.toUpperCase(Locale.getDefault())));
        }
        return true;
    }

    @Generated
    public EstagiarioServiceImpl(EstagiarioRepository estagiarioRepository, PortalParametroService portalParametroService, IntegracaoAiseOxyFolhaPagamentoService integracaoAiseOxyService, EstagiarioServiceOxy serviceOxy, EntidadeAiseService entidadeAiseService, EntidadeContabilidadeRepository entidadeRepository, ServidorServiceWS servidorServiceWS, ServidorService servidorService, BaseExport baseExport) {
        this.estagiarioRepository = estagiarioRepository;
        this.portalParametroService = portalParametroService;
        this.integracaoAiseOxyService = integracaoAiseOxyService;
        this.serviceOxy = serviceOxy;
        this.entidadeAiseService = entidadeAiseService;
        this.entidadeRepository = entidadeRepository;
        this.servidorServiceWS = servidorServiceWS;
        this.servidorService = servidorService;
        this.baseExport = baseExport;
    }

    @Generated
    public BaseExport getBaseExport() {
        return this.baseExport;
    }
}

