/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.service.impl;

import br.com.elotech.folhapagamento.client.domain.CargoReduzidoDTO;
import br.com.elotech.folhapagamento.client.domain.MatrizSalarialDTO;
import br.com.elotech.folhapagamento.client.domain.PortalTransparenciaCargoDTO;
import br.com.elotech.folhapagamento.client.domain.PortalTransparenciaCargoQuadroSalarialDTO;
import br.com.elotech.folhapagamento.client.domain.PortalTransparenciaCargoQuadroSalarialViewDTO;
import br.com.elotech.folhapagamento.client.domain.PortalTransparenciaCargoViewDTO;
import br.com.elotech.folhapagamento.client.domain.QuadroSalarialDTO;
import br.com.elotech.folhapagamento.client.domain.enums.CargoTipo;
import br.com.elotech.portaltransparencia.aiseportal.domain.Cargo;
import br.com.elotech.portaltransparencia.aiseportal.domain.CargoPk;
import br.com.elotech.portaltransparencia.aiseportal.domain.GrupoOcupacional;
import br.com.elotech.portaltransparencia.aiseportal.domain.GrupoOcupacionalNivel;
import br.com.elotech.portaltransparencia.aiseportal.domain.GrupoOcupacionalNivelPk;
import br.com.elotech.portaltransparencia.aiseportal.domain.GrupoOcupacionalPk;
import br.com.elotech.portaltransparencia.aiseportal.domain.QuadroSalarial;
import br.com.elotech.portaltransparencia.aiseportal.domain.QuadroSalarialPk;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.CargoFaixaDTO;
import br.com.elotech.portaltransparencia.aiseportal.repository.CargoRepository;
import br.com.elotech.portaltransparencia.aiseportal.repository.GrupoOcupacionalNivelRepository;
import br.com.elotech.portaltransparencia.aiseportal.repository.GrupoOcupacionalRepository;
import br.com.elotech.portaltransparencia.aiseportal.repository.QuadroSalarialRepository;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.AiseParams;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.CargoParams;
import br.com.elotech.portaltransparencia.aiseportal.service.CargoService;
import br.com.elotech.portaltransparencia.aiseportal.service.EntidadeAiseService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class CargoServiceImpl
implements CargoService {
    private final CargoRepository cargoRepository;
    private final QuadroSalarialRepository quadroSalarialRepository;
    private final GrupoOcupacionalRepository grupoOcupacionalRepository;
    private final GrupoOcupacionalNivelRepository grupoOcupacionalNivelRepository;
    private final ExampleMatcher matcher;
    private final EntidadeAiseService entidadeAiseService;

    public CargoServiceImpl(CargoRepository cargoRepository, QuadroSalarialRepository quadroSalarialRepository, GrupoOcupacionalRepository grupoOcupacionalRepository, GrupoOcupacionalNivelRepository grupoOcupacionalNivel, EntidadeAiseService entidadeAiseService) {
        this.cargoRepository = cargoRepository;
        this.quadroSalarialRepository = quadroSalarialRepository;
        this.grupoOcupacionalRepository = grupoOcupacionalRepository;
        this.grupoOcupacionalNivelRepository = grupoOcupacionalNivel;
        this.matcher = ExampleMatcher.matching().withMatcher("descricao", ExampleMatcher.GenericPropertyMatcher::contains).withIgnoreCase();
        this.entidadeAiseService = entidadeAiseService;
    }

    public List<Cargo> findCargo(CargoParams params) {
        List cargoDTO = this.cargoRepository.findCargosComFaixa(params);
        ArrayList<Cargo> cargo = new ArrayList<Cargo>();
        cargoDTO.forEach(c -> {
            CargoPk pk = new CargoPk(params.getEntidade(), c.getCargo());
            cargo.add(new Cargo(pk, c.getClassificacao(), c.getDescricao()));
        });
        return cargo;
    }

    public List<QuadroSalarial> findQuadroSalarial(CargoParams params) {
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        QuadroSalarialPk pk = new QuadroSalarialPk(params.getEntidade());
        QuadroSalarial quadroSalarial = new QuadroSalarial(pk, (String)params.getDescricao().orElse(null));
        return Lists.newArrayList((Iterable)this.quadroSalarialRepository.findAll(Example.of((Object)quadroSalarial, (ExampleMatcher)this.matcher)));
    }

    public List<GrupoOcupacional> findGrupoOcupacional(CargoParams params) {
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        GrupoOcupacionalPk pk = new GrupoOcupacionalPk(params.getEntidade(), (String)params.getQuadro().orElse(null));
        GrupoOcupacional grupo = new GrupoOcupacional(pk, (String)params.getDescricao().orElse(null));
        return Lists.newArrayList((Iterable)this.grupoOcupacionalRepository.findAll(Example.of((Object)grupo, (ExampleMatcher)this.matcher)));
    }

    public List<GrupoOcupacionalNivel> findGrupoOcupacionalNivel(CargoParams params) {
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        String quadro = params.getQuadro().orElse(null);
        String grupo = params.getGrupo().orElse(null);
        GrupoOcupacionalNivelPk pk = new GrupoOcupacionalNivelPk(params.getEntidade(), quadro, grupo);
        GrupoOcupacionalNivel grupoNivel = new GrupoOcupacionalNivel(pk, (String)params.getDescricao().orElse(null));
        return Lists.newArrayList((Iterable)this.grupoOcupacionalNivelRepository.findAll(Example.of((Object)grupoNivel, (ExampleMatcher)this.matcher)));
    }

    public Page<CargoFaixaDTO> findCargos(CargoParams params, Pageable pageable) {
        return this.cargoRepository.findCargos(params, pageable);
    }

    public List<CargoFaixaDTO> findFaixas(CargoParams params) {
        return this.cargoRepository.findFaixas(params);
    }

    public Page<PortalTransparenciaCargoDTO> findCargosOxy(CargoParams params, Pageable pageable) {
        return new PageImpl(new ArrayList(), pageable, 0L);
    }

    public List<PortalTransparenciaCargoViewDTO> getMatrizVigente(CargoParams params) {
        return new ArrayList<PortalTransparenciaCargoViewDTO>();
    }

    public List<CargoTipo> getTipoCargo(String descricao) {
        return new ArrayList<CargoTipo>();
    }

    public List<String> getVigenciasMatrizSalarial(Long matrizId) {
        return new ArrayList<String>();
    }

    public List<CargoReduzidoDTO> getCargosReduzido(Long entidadeId, String descricao) {
        return new ArrayList<CargoReduzidoDTO>();
    }

    public List<MatrizSalarialDTO> findAllMatrizSalarial(Long entidadeId, String nomeMatrizSalarial) {
        return new ArrayList<MatrizSalarialDTO>();
    }

    public List<QuadroSalarialDTO> findAllQuadroSalarial(Long entidadeId, String nomeQuadroSalarial) {
        return new ArrayList<QuadroSalarialDTO>();
    }

    public Boolean getUtilizaNovaMatriz(Long entidadeId) {
        return null;
    }

    public Page<PortalTransparenciaCargoQuadroSalarialDTO> findCargosQuadroSalarialOxy(CargoParams params, Pageable pageable) {
        return new PageImpl(new ArrayList(), pageable, 0L);
    }

    public PortalTransparenciaCargoQuadroSalarialViewDTO getCargoDetalhes(CargoParams params) {
        return new PortalTransparenciaCargoQuadroSalarialViewDTO();
    }

    @Generated
    public CargoServiceImpl(CargoRepository cargoRepository, QuadroSalarialRepository quadroSalarialRepository, GrupoOcupacionalRepository grupoOcupacionalRepository, GrupoOcupacionalNivelRepository grupoOcupacionalNivelRepository, ExampleMatcher matcher, EntidadeAiseService entidadeAiseService) {
        this.cargoRepository = cargoRepository;
        this.quadroSalarialRepository = quadroSalarialRepository;
        this.grupoOcupacionalRepository = grupoOcupacionalRepository;
        this.grupoOcupacionalNivelRepository = grupoOcupacionalNivelRepository;
        this.matcher = matcher;
        this.entidadeAiseService = entidadeAiseService;
    }
}

