/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.resource;

import br.com.elotech.portaltransparencia.aiseportal.domain.dto.DividaAtivaContribuinteDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.DividaAtivaDTO;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.FindDividaAtivaParams;
import br.com.elotech.portaltransparencia.aiseportal.service.DividaAtivaService;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/dividas-ativas"})
public class DividaAtivaResource {
    private final DividaAtivaService service;
    private final BaseExport baseExport;
    private final EntidadeContabilidadeRepository entidadeRepository;
    private static final Integer DIVIDA_ATIVA_REPORT_PAGE_SIZE = Integer.MAX_VALUE;

    public DividaAtivaResource(DividaAtivaService service, BaseExport baseExport, EntidadeContabilidadeRepository entidadeRepository) {
        this.baseExport = baseExport;
        this.entidadeRepository = entidadeRepository;
        this.service = service;
    }

    @GetMapping
    public ResponseEntity<Page<DividaAtivaDTO>> findDividasAtivas(FindDividaAtivaParams params, Pageable pageable) {
        return ResponseEntity.ok((Object)this.service.findDividasAtivas(params, pageable));
    }

    @GetMapping(value={"/report"})
    public ModelAndView findDividasAtivasExport(HttpServletRequest request, HttpServletResponse response, FindDividaAtivaParams params, Pageable pageable) throws Throwable {
        PageRequest pageRequest = PageRequest.of((int)0, (int)DIVIDA_ATIVA_REPORT_PAGE_SIZE);
        Page dividasAtivasPage = this.service.findDividasAtivas(params, (Pageable)pageRequest);
        Entidade entidadeObj = (Entidade)this.entidadeRepository.findOne((Object)params.getEntidadeContabil());
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidadeObj.getNome());
        reportParam.setReportTitle("Divida Ativa");
        reportParam.setClazzDTO(DividaAtivaDTO.class);
        if (Boolean.TRUE.equals(params.getShowValor())) {
            reportParam.setHeaderFields("Nome,CPF/CNPJ,Valor");
            reportParam.setFields("nome,cnpjCpf,valor");
            float[] fieldsPerc = new float[]{5.0f, 3.0f, 2.0f};
            reportParam.setWidthsFieldsPerc(fieldsPerc);
            int[] fieldTab = new int[]{100, 20, 20};
            reportParam.setWidthsFieldsTab(fieldTab);
        } else {
            reportParam.setHeaderFields("Nome,CPF/CNPJ");
            reportParam.setFields("nome,cnpjCpf");
            float[] fieldsPerc = new float[]{6.0f, 4.0f};
            reportParam.setWidthsFieldsPerc(fieldsPerc);
            int[] fieldTab = new int[]{100, 20};
            reportParam.setWidthsFieldsTab(fieldTab);
        }
        reportParam.setPage(dividasAtivasPage);
        reportParam.setFontSize(8.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        reportParam.setMaxRecord(dividasAtivasPage.getSize());
        return this.baseExport.toExport(reportParam);
    }

    @GetMapping(value={"/contribuinte"})
    public ResponseEntity<List<DividaAtivaContribuinteDTO>> findDividasAtivasContribuinte(FindDividaAtivaParams params) {
        return ResponseEntity.ok((Object)this.service.findDividasAtivasContribuinte(params));
    }

    @GetMapping(value={"/total"})
    public ResponseEntity<DividaAtivaContribuinteDTO> findValorTotalDividasAtivas(FindDividaAtivaParams params) {
        return ResponseEntity.ok((Object)this.service.findValorTotalDividasAtivas(params));
    }
}

