/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.admportal.service.impl;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.portaltransparencia.admportal.repository.AcordoSemRecursoRepository;
import br.com.elotech.portaltransparencia.admportal.service.AcordoSemRecursoAdmService;
import br.com.elotech.portaltransparencia.contabportal.domain.AcordoSemRecurso;
import br.com.elotech.portaltransparencia.contabportal.domain.ArquivoContab;
import br.com.elotech.portaltransparencia.contabportal.domain.Fornecedor;
import br.com.elotech.portaltransparencia.contabportal.service.ArquivoContabilService;
import br.com.elotech.portaltransparencia.contabportal.service.FornecedorService;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.Authentication;
import org.springframework.web.multipart.MultipartFile;

public class AcordoSemRecursoServiceOxyAdmImpl
extends CrudService<AcordoSemRecurso, Long>
implements AcordoSemRecursoAdmService {
    private final FornecedorService fornecedorService;
    private final ArquivoContabilService arquivoService;
    private final AcordoSemRecursoRepository repository;

    protected void beforeSave(AcordoSemRecurso entity, Authentication authentication) {
        entity.setDataUltimaAtualizacao(new Timestamp(System.currentTimeMillis()));
        super.beforeSave((EloEntity)entity, authentication);
    }

    public Page<AcordoSemRecurso> findByEntidadeAndFiltro(Long idEntidade, Long exercicio, Pageable pageable) {
        Specification & Serializable specification = (Specification & Serializable)(root, query, criteriaBuilder) -> {
            Predicate predicate = criteriaBuilder.equal((Expression)root.get("entidade"), (Object)idEntidade);
            if (exercicio != null) {
                predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("exercicio"), (Object)exercicio));
            }
            return predicate;
        };
        List<AcordoSemRecurso> acordos = this.repository.findAll((Specification)specification, pageable).stream().toList();
        if (!acordos.isEmpty()) {
            Map credorById = this.fornecedorService.findAllById(acordos.stream().map(AcordoSemRecurso::getFornecedor).collect(Collectors.toSet())).stream().collect(Collectors.toMap(Fornecedor::getId, Function.identity()));
            acordos.forEach(a -> a.setNomeFornecedor(((Fornecedor)credorById.get(a.getFornecedor())).getNome()));
        }
        return new PageImpl(acordos, pageable, (long)acordos.size());
    }

    public AcordoSemRecurso update(AcordoSemRecurso acordo, Long idFornecedor) {
        acordo.setFornecedor(idFornecedor);
        return (AcordoSemRecurso)this.getCrudRepository().save((Object)acordo);
    }

    public AcordoSemRecurso save(AcordoSemRecurso acordo, Long idFornecedor, Authentication authentication) {
        acordo.setFornecedor(idFornecedor);
        return (AcordoSemRecurso)this.save((EloEntity)acordo, authentication);
    }

    public AcordoSemRecurso findOne(Long id) {
        AcordoSemRecurso acordo = (AcordoSemRecurso)this.repository.findOne((Object)id);
        Fornecedor fornecedor = this.fornecedorService.findById(acordo.getFornecedor());
        acordo.setNomeFornecedor(fornecedor.getNome());
        return acordo;
    }

    public void remove(Long idAcordo) {
        this.repository.delete((Object)this.removerArquivo(idAcordo));
    }

    public AcordoSemRecurso adicionarArquivo(Long id, MultipartFile file) {
        AcordoSemRecurso acordo = this.findOne(id);
        try {
            ArquivoContab novoArquivo = this.arquivoService.salvarArquivo(file, file.getOriginalFilename());
            acordo.setArquivo(this.arquivoService.save(novoArquivo));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (AcordoSemRecurso)this.save((EloEntity)acordo, null);
    }

    public AcordoSemRecurso removerArquivo(Long id) {
        AcordoSemRecurso acordo = this.findOne(id);
        Optional.ofNullable(acordo.getArquivo()).ifPresent(file -> {
            this.arquivoService.remove(acordo.getArquivo().getId());
            acordo.setArquivo(null);
        });
        return (AcordoSemRecurso)this.save((EloEntity)acordo, null);
    }

    @Generated
    public AcordoSemRecursoServiceOxyAdmImpl(FornecedorService fornecedorService, ArquivoContabilService arquivoService, AcordoSemRecursoRepository repository) {
        this.fornecedorService = fornecedorService;
        this.arquivoService = arquivoService;
        this.repository = repository;
    }
}

