/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.admportal.service;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.portaltransparencia.admportal.domain.LogAcesso;
import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.domain.Rota;
import br.com.elotech.portaltransparencia.admportal.repository.LogAcessoRepository;
import br.com.elotech.portaltransparencia.admportal.repository.RotaRepository;
import br.com.elotech.portaltransparencia.admportal.service.PortalParametroService;
import java.time.LocalDate;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LogAcessoService
extends CrudService<LogAcesso, UUID> {
    private final RotaRepository rotaRepository;
    private final PortalParametroService parametroService;

    @Async
    @Transactional
    public synchronized void insertIfNotExists(LogAcesso logAcesso, String requestURI) {
        boolean geraLogAcesso = "S".equalsIgnoreCase(this.parametroService.getPortalParametroValor(Parametros.NAO_DEPENDE_ENTIDADE, Parametros.NAO_DEPENDE_EXERCICIO, Parametros.PARAM_HABILITAR_LOG_ACESSO));
        if (geraLogAcesso) {
            Example example = Example.of((Object)logAcesso, (ExampleMatcher)ExampleMatcher.matchingAll());
            if (!this.getCrudRepository().exists(example)) {
                logAcesso.setId(UUID.randomUUID());
                logAcesso.setRequestURI(requestURI);
                Optional.ofNullable(this.rotaRepository.findFirstByRotaIgnoreCase(logAcesso.getRota())).map(Rota::getDescricao).ifPresent(arg_0 -> ((LogAcesso)logAcesso).setDescricao(arg_0));
                this.getCrudRepository().save((Object)logAcesso);
            }
        }
    }

    public Page<LogAcesso> getRelatorioAcessos(LocalDate dataInicial, LocalDate dataFinal, Pageable pageable) {
        return ((LogAcessoRepository)this.getCrudRepository(LogAcessoRepository.class)).getRelatorioAcessos(dataInicial, dataFinal, pageable);
    }

    @Generated
    public LogAcessoService(RotaRepository rotaRepository, PortalParametroService parametroService) {
        this.rotaRepository = rotaRepository;
        this.parametroService = parametroService;
    }
}

