/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.admportal.service;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.service.support.ReadOnlyService;
import br.com.elotech.portaltransparencia.admportal.domain.EmendaParlamentar;
import br.com.elotech.portaltransparencia.admportal.repository.EmendaParlamentarRepository;
import br.com.elotech.portaltransparencia.admportal.resource.params.EmendaParlamentarParams;
import br.com.elotech.portaltransparencia.contabportal.domain.ArquivoContab;
import br.com.elotech.portaltransparencia.contabportal.service.ArquivoContabilService;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class EmendaParlamentarService
extends ReadOnlyService<EmendaParlamentar, Long>
implements br.com.elotech.portaltransparencia.contabportal.service.EmendaParlamentarService {
    @Autowired
    private final EmendaParlamentarRepository emendaParlamentarRepository;
    private final ArquivoContabilService arquivoService;

    public EmendaParlamentarService(EmendaParlamentarRepository emendaParlamentarRepository, ArquivoContabilService arquivoService) {
        this.arquivoService = arquivoService;
        this.emendaParlamentarRepository = emendaParlamentarRepository;
    }

    public List<EmendaParlamentar> findEmendaParlamentar(Long entidade, Long exercicio) {
        return this.emendaParlamentarRepository.findByEntidadeAndExercicio(entidade, exercicio);
    }

    public Page<EmendaParlamentar> findByParams(EmendaParlamentarParams params, Pageable pageable) {
        return this.emendaParlamentarRepository.findByParams(params, pageable);
    }

    public Page<EmendaParlamentar> findByEntidadeAndExercicio(Long entidade, Long exercicio, Pageable pageable) {
        if (Objects.nonNull(exercicio)) {
            return this.emendaParlamentarRepository.findByEntidadeAndExercicio(entidade, exercicio, pageable);
        }
        return this.emendaParlamentarRepository.findByEntidade(entidade, pageable);
    }

    @Transactional
    public EmendaParlamentar save(EmendaParlamentar emendaParlamentar) {
        return (EmendaParlamentar)this.emendaParlamentarRepository.save((Object)emendaParlamentar);
    }

    @Transactional
    public EmendaParlamentar update(EmendaParlamentar emendaParlamentar) {
        EmendaParlamentar emendaFound = (EmendaParlamentar)this.emendaParlamentarRepository.findOne((Object)emendaParlamentar.getId());
        if (Objects.isNull(emendaFound)) {
            throw RestException.notFound();
        }
        emendaFound.setEntidade(emendaParlamentar.getEntidade());
        emendaFound.setExercicio(emendaParlamentar.getExercicio());
        emendaFound.setAutoria(emendaParlamentar.getAutoria());
        emendaFound.setTipo(emendaParlamentar.getTipo());
        emendaFound.setNumero(emendaParlamentar.getNumero());
        emendaFound.setObjeto(emendaParlamentar.getObjeto());
        emendaFound.setFuncao(emendaParlamentar.getFuncao());
        emendaFound.setAno(emendaParlamentar.getAno());
        emendaFound.setVinculadoConvenio(emendaParlamentar.getVinculadoConvenio());
        emendaFound.setValorPrevisto(emendaParlamentar.getValorPrevisto());
        emendaFound.setValorRealizado(emendaParlamentar.getValorRealizado());
        return (EmendaParlamentar)this.emendaParlamentarRepository.save((Object)emendaFound);
    }

    @Transactional
    public void delete(EmendaParlamentar emendaParlamentar) {
        this.emendaParlamentarRepository.delete((Object)emendaParlamentar);
    }

    @Transactional
    public EmendaParlamentar adicionarArquivoPublicacao(Long id, MultipartFile file) {
        EmendaParlamentar emendaParlamentar = (EmendaParlamentar)this.findOne((Serializable)id);
        try {
            ArquivoContab novoArquivo = this.arquivoService.salvarArquivo(file, file.getOriginalFilename());
            emendaParlamentar.setArquivo(this.arquivoService.save(novoArquivo));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.save(emendaParlamentar);
    }

    @Transactional
    public EmendaParlamentar removerArquivoPublicacao(Long id) {
        EmendaParlamentar emendaParlamentar = (EmendaParlamentar)this.findOne((Serializable)id);
        Long arquivoId = emendaParlamentar.getArquivo() != null ? emendaParlamentar.getArquivo().getId() : null;
        emendaParlamentar.setArquivo(null);
        if (arquivoId != null) {
            this.arquivoService.remove(arquivoId);
        }
        return emendaParlamentar;
    }
}

