/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.admportal.resource;

import br.com.elotech.portaltransparencia.admportal.service.AcordoSemRecursoAdmService;
import br.com.elotech.portaltransparencia.contabportal.domain.AcordoSemRecurso;
import java.io.IOException;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/admin/acordos-sem-recurso"})
public class AcordoSemRecursoAdmResource {
    private final AcordoSemRecursoAdmService service;

    @GetMapping(value={"/entidade"})
    public ResponseEntity<Page<AcordoSemRecurso>> findByEntidadeAndExercicio(Pageable pageable, @RequestParam(value="entidade") Long entidade, @RequestParam(value="exercicio", required=false) Long exercicio) {
        return ResponseEntity.ok((Object)this.service.findByEntidadeAndFiltro(entidade, exercicio, pageable));
    }

    @PutMapping(value={"/fornecedor/{idFornecedor}"})
    public ResponseEntity<AcordoSemRecurso> update(@RequestBody AcordoSemRecurso acordo, @PathVariable(value="idFornecedor") Long idFornecedor) {
        return ResponseEntity.ok((Object)this.service.update(acordo, idFornecedor));
    }

    @PostMapping(value={"/fornecedor/{idFornecedor}"})
    public ResponseEntity<AcordoSemRecurso> save(@PathVariable(value="idFornecedor") Long idFornecedor, @RequestBody AcordoSemRecurso acordo, @RequestParam(value="authentication", required=false) Authentication authentication) {
        return ResponseEntity.ok((Object)this.service.save(acordo, idFornecedor, authentication));
    }

    @PostMapping(value={"/{id}/arquivo"})
    public ResponseEntity<AcordoSemRecurso> salvarArquivo(@PathVariable(name="id") Long id, @RequestParam(value="files") MultipartFile file) throws IOException {
        return ResponseEntity.ok((Object)this.service.adicionarArquivo(id, file));
    }

    @DeleteMapping(value={"/{id}/arquivo"})
    public ResponseEntity<AcordoSemRecurso> deletarArquivo(@PathVariable(name="id") Long id) {
        return ResponseEntity.ok((Object)this.service.removerArquivo(id));
    }

    @GetMapping(value={"/view/{id}"})
    public ResponseEntity<AcordoSemRecurso> getView(@PathVariable(value="id") Long id) {
        AcordoSemRecurso acordo = this.service.findOne(id);
        if (acordo == null) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok((Object)acordo);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<AcordoSemRecurso> findOne(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.service.findOne(id));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> remove(@PathVariable(name="id") Long id) {
        this.service.remove(id);
        return ResponseEntity.ok().build();
    }

    @Generated
    public AcordoSemRecursoAdmResource(AcordoSemRecursoAdmService service) {
        this.service = service;
    }
}

