SELECT P.DATAPROCESSO AS DATA,
       P.TIPO,
       P.NUMERO AS PROCESSO,
       P.ANO AS EXERCICIO,
       P.ENTIDADE,
       P.DIGITACAO,
       P.USUARIOREG AS USUARIO,
       A.DESCRICAO AS ASSUNTO,
       S.DESCRICAO AS SITUACAO,
       G.DESCRICAO AS GRAUSIGILO,
       PE.NOME as REQUERENTE,
       G.ID AS IDGRAUSIGILO
  FROM ${db.protocolo.schema}.TRAMITACAO T
  LEFT OUTER JOIN ${db.protocolo.schema}.PROCESSOS P
    ON T.ENTIDADE = P.ENTIDADE 
   AND T.TIPO = P.TIPO
   AND T.NUMERO = P.NUMERO
   AND T.ANO = P.ANO
  LEFT OUTER JOIN ${db.protocolo.schema}.PESSOA PE
    ON PE.CODPESSOA = P.CODPESSOA
  LEFT OUTER JOIN ${db.protocolo.schema}.ASSUNTO A
    ON P.CODASSUNTO = A.CODIGO
  LEFT OUTER JOIN ${db.protocolo.schema}.SITUACOES S
    ON T.SITUACAO = S.CODIGO
  LEFT OUTER JOIN ${db.protocolo.schema}.GRAUSIGILO G
    ON G.ID = P.GRAUSIGILO
  LEFT OUTER JOIN ${db.protocolo.schema}.PARAMETROS B
    ON B.ENTIDADE = P.ENTIDADE
   AND B.EXERCICIO = P.ANO
   AND B.CODIGO = 91
   AND (B.VALOR IS NOT NULL AND B.VALOR <> '')
 WHERE P.ENTIDADE = :entidade
   AND P.TIPO = :tipo
   AND P.ANO = :exercicio
   AND T.SEQUENCIA = (SELECT MAX(X.SEQUENCIA) 
                        FROM ${db.protocolo.schema}.TRAMITACAO X
                       WHERE X.TIPO = T.TIPO
                         AND X.ANO = T.ANO
                         AND X.NUMERO = T.NUMERO
                         AND X.ENTIDADE = T.ENTIDADE)
